/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *   qimsys                                                                  *
 *   Copyright (C) 2010 by Tasuku Suzuki <stasuku@gmail.com>                 *
 *                                                                           *
 *   This program is free software; you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Lesser Public License as          *
 *   published by the Free Software Foundation; either version 2 of the      *
 *   License, or (at your option) any later version.                         *
 *                                                                           *
 *   This program is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 *   GNU Lesser General Public License for more details.                     *
 *                                                                           *
 *   You should have received a copy of the GNU Lesser General Public        *
 *   License along with this program; if not, write to the                   *
 *   Free Software Foundation, Inc.,                                         *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef TRANSLATOR_H
#define TRANSLATOR_H

#include <QObject>
#include "qimsysglobal.h"

class QTabWidget;
class QVariant;

#define TR Translator::tr

class QIMSYS_EXPORT Translator : public QObject
{
    Q_OBJECT
public:
    static Translator *instance();
private:
    Translator();
public:
    ~Translator();

    static void tr(QObject *object, const char *key, const QObject *context, const char *value, QString arg = QString());
    static void tr(QObject *object, const QVariant &key, const QObject *context, const char *value, QString arg = QString());
    static void tr(QObject *object, const QVariant &key, const char *context, const char *value, QString arg = QString());
    static void begin();
    static void end();
    static void ui(QWidget *parent, const char *context = 0);
    static void tr(QWidget *widget);
    static void installTranslator(const QString &prefix, const QString &directory = QString());

    static void setLanguage(const QString &lang);

signals:
    void languageChanged();

private:
    class Private;
    Private *d;
};

#endif//TRANSLATOR_H
