/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *   qimsys                                                                  *
 *   Copyright (C) 2010 by Tasuku Suzuki <stasuku@gmail.com>                 *
 *                                                                           *
 *   This program is free software; you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Lesser Public License as          *
 *   published by the Free Software Foundation; either version 2 of the      *
 *   License, or (at your option) any later version.                         *
 *                                                                           *
 *   This program is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 *   GNU Lesser General Public License for more details.                     *
 *                                                                           *
 *   You should have received a copy of the GNU Lesser General Public        *
 *   License along with this program; if not, write to the                   *
 *   Free Software Foundation, Inc.,                                         *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef QIMSYSCONVERTER_H
#define QIMSYSCONVERTER_H

#include "qimsysglobal.h"
#include "qimsysabstractpluginobject.h"

class QAction;

class QIMSYS_EXPORT QimsysConverter : public QimsysAbstractPluginObject
{
    Q_OBJECT
    Q_PROPERTY(bool active READ isActive WRITE setActive NOTIFY activeChanged)
public:
    explicit QimsysConverter(QObject *parent = 0);
    ~QimsysConverter();
    virtual QString identifier() const = 0;

    virtual QStringList locales() const = 0;

    virtual bool useEngine() const = 0;
    virtual QList<QAction*> actions() = 0;

    bool isActive() const;

public slots:
    void setActive(bool active);

signals:
    void activeChanged(bool active);

private:
    class Private;
    Private *d;
};

#endif//QIMSYSCONVERTER_H
