/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *   qimsys                                                                  *
 *   Copyright (C) 2010 by Tasuku Suzuki <stasuku@gmail.com>                 *
 *                                                                           *
 *   This program is free software; you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Lesser Public License as          *
 *   published by the Free Software Foundation; either version 2 of the      *
 *   License, or (at your option) any later version.                         *
 *                                                                           *
 *   This program is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 *   GNU Lesser General Public License for more details.                     *
 *                                                                           *
 *   You should have received a copy of the GNU Lesser General Public        *
 *   License along with this program; if not, write to the                   *
 *   Free Software Foundation, Inc.,                                         *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef QIMSYSPREEDITITEM_H
#define QIMSYSPREEDITITEM_H

#include "qimsysglobal.h"
#include "dbus.h"
#include <QMetaType>
#include <QTextCharFormat>

struct QIMSYS_EXPORT QimsysPreeditItem {
    QString text;
    int cursor;
    int selection;
    QTextCharFormat::UnderlineStyle underline;

    inline bool operator==(const QimsysPreeditItem &other) {
        return (text == other.text && cursor == other.cursor && selection == other.selection && underline == other.underline);
    }
};

typedef QList<QimsysPreeditItem> QimsysPreeditItemList;

QIMSYS_EXPORT QDebug &operator<<(QDebug &debug, const QimsysPreeditItem &elem);

Q_DECLARE_METATYPE(QimsysPreeditItem)
Q_DECLARE_METATYPE(QimsysPreeditItemList)

DATASTREAM_IN(QimsysPreeditItem &e,
              int underline;
              s >> e.text >> e.cursor >> e.selection >> underline;
              e.underline = (QTextCharFormat::UnderlineStyle)underline;
             )

DATASTREAM_OUT(const QimsysPreeditItem &e,
               s << e.text << e.cursor << e.selection << (int)e.underline;
              )

#ifndef QIMSYS_NO_DBUS
DBUSARGUMENT_IN(QimsysPreeditItem &e,
                arg.beginStructure();
                e.text = qdbus_cast<QString>(arg);
                e.cursor = qdbus_cast<int>(arg);
                e.selection = qdbus_cast<int>(arg);
                e.underline = (QTextCharFormat::UnderlineStyle)qdbus_cast<int>(arg);
                arg.endStructure();
               )

DBUSARGUMENT_OUT(const QimsysPreeditItem &e,
                 arg.beginStructure();
                 arg << e.text;
                 arg << e.cursor;
                 arg << e.selection;
                 arg << (int)e.underline;
                 arg.endStructure();
                )

DBUSARGUMENT_IN(QimsysPreeditItemList &c,
                arg.beginArray();
                while (!arg.atEnd())
{
QimsysPreeditItem e = qdbus_cast<QimsysPreeditItem>(arg);
    c.append(e);
}
arg.endArray();
               )

DBUSARGUMENT_OUT(QimsysPreeditItemList &c,
                 arg.beginArray();
                 foreach(QimsysPreeditItem e, c)
{
    arg << e;
}
arg.endArray();
                )
#endif // QIMSYS_NO_DBUS

#endif//QIMSYSPREEDITITEM_H
