/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *   qimsys                                                                  *
 *   Copyright (C) 2010 by Tasuku Suzuki <stasuku@gmail.com>                 *
 *                                                                           *
 *   This program is free software; you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Lesser Public License as          *
 *   published by the Free Software Foundation; either version 2 of the      *
 *   License, or (at your option) any later version.                         *
 *                                                                           *
 *   This program is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 *   GNU Lesser General Public License for more details.                     *
 *                                                                           *
 *   You should have received a copy of the GNU Lesser General Public        *
 *   License along with this program; if not, write to the                   *
 *   Free Software Foundation, Inc.,                                         *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "qimsyscandidates.h"

#include "qimsysdebug.h"

class QimsysCandidates::Private : private QObject
{
    Q_OBJECT
public:
    Private(QimsysCandidates *parent);
    ~Private();

    bool init();

private:
    QimsysCandidates *q;

public:
    static QimsysCandidates *server;
    QimsysConversionItemList candidates;
    int currentIndex;
};

QimsysCandidates *QimsysCandidates::Private::server = 0;

QimsysCandidates::Private::Private(QimsysCandidates *parent)
    : QObject(parent)
    , q(parent)
    , candidates()
    , currentIndex(-1)
{
    qimsysDebugIn() << parent;
    qRegisterMetaType<QimsysConversionItem>("QimsysConversionItem");
    qRegisterMetaTypeStreamOperators<QimsysConversionItem>("QimsysConversionItem");
    qRegisterMetaType< QimsysConversionItemList >("QimsysConversionItemList");
    qRegisterMetaTypeStreamOperators< QimsysConversionItemList >("QimsysConversionItemList");
#ifndef QIMSYS_NO_DBUS
    qDBusRegisterMetaType<QimsysConversionItem>();
    qDBusRegisterMetaType< QimsysConversionItemList >();
#endif
    switch (q->type()) {
    case Server:
        server = q;
        break;
    case Client:
        break;
    }
    qimsysDebugOut();
}

QimsysCandidates::Private::~Private()
{
    qimsysDebugIn();
    qimsysDebugOut();
}

bool QimsysCandidates::Private::init()
{
    qimsysDebugIn();
    bool ret = q->QimsysAbstractIpcObject::init();
    if (ret) {
        switch (q->type()) {
        case Server:
            break;
        case Client:
            connect(q->proxy(), SIGNAL(candidatesChanged(QimsysConversionItemList)), q, SIGNAL(candidatesChanged(QimsysConversionItemList)));
            connect(q->proxy(), SIGNAL(currentIndexChanged(int)), q, SIGNAL(currentIndexChanged(int)));
            break;
        }
    }
    qimsysDebugOut() << ret;
    return ret;
}

QimsysCandidates::QimsysCandidates(QObject *parent, Type type)
    : QimsysAbstractIpcObject(parent, type)
{
    qimsysDebugIn() << parent << type;
    d = new Private(this);
    qimsysDebugOut();
}

QimsysCandidates::~QimsysCandidates()
{
    qimsysDebugIn();
    delete d;
    qimsysDebugOut();
}

bool QimsysCandidates::init()
{
    qimsysDebugIn();
    bool ret = d->init();
    qimsysDebugOut() << ret;
    return ret;
}

QimsysAbstractIpcObject *QimsysCandidates::server() const
{
    return d->server;
}

getProp(QimsysCandidates, QimsysConversionItemList, candidates)
setProp(QimsysCandidates, const QimsysConversionItemList&, candidates, setCandidates)

getProp(QimsysCandidates, int, currentIndex)
setProp(QimsysCandidates, int, currentIndex, setCurrentIndex, if (!candidates().isEmpty())
{
currentIndex = (currentIndex + candidates().count()) % candidates().count();
})

void QimsysCandidates::clear()
{
    qimsysDebugIn();
    switch (type()) {
    case Server:
        d->currentIndex = -1;
        d->candidates.clear();
        emit candidatesChanged(d->candidates);
        emit currentIndexChanged(-1);
        break;
    case Client:
        proxy()->metaObject()->invokeMethod(proxy(), "clear");
        break;
    }
    qimsysDebugOut();
}

#include "qimsyscandidates.moc"
