/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *   qimsys                                                                  *
 *   Copyright (C) 2010 by Tasuku Suzuki <stasuku@gmail.com>                 *
 *                                                                           *
 *   This program is free software; you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Lesser Public License as          *
 *   published by the Free Software Foundation; either version 2 of the      *
 *   License, or (at your option) any later version.                         *
 *                                                                           *
 *   This program is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 *   GNU Lesser General Public License for more details.                     *
 *                                                                           *
 *   You should have received a copy of the GNU Lesser General Public        *
 *   License along with this program; if not, write to the                   *
 *   Free Software Foundation, Inc.,                                         *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "qimsysapplicationmanager.h"
#include "dbus.h"
#include "qimsysdebug.h"

enum {
    QIMSYSAPPLICATIONMANAGER_DISPLAY_LANGUAGE_CHANGED,
    QIMSYSAPPLICATIONMANAGER_FOCUS_CHANGED,
    QIMSYSAPPLICATIONMANAGER_COMPOSING_CHANGED,
    QIMSYSAPPLICATIONMANAGER_INPUT_LANGUAGE_CHANGED,
    QIMSYSAPPLICATIONMANAGER_CURRENT_ENGINE_CHANGED,
    QIMSYSAPPLICATIONMANAGER_TRIGGERED,
    QIMSYSAPPLICATIONMANAGER_SETTINGS_UPDATED,
    QIMSYSAPPLICATIONMANAGER_LAST_SIGNAL
};

static guint qimsys_application_manager_signals[QIMSYSAPPLICATIONMANAGER_LAST_SIGNAL] = { 0, 0 };

G_DEFINE_TYPE(QimsysApplicationManager, qimsys_application_manager, QIMSYSABSTRACTIPCOBJECT_TYPE)

static void qimsys_application_manager_display_language_changed(DBusGProxy *proxy, char *value, gpointer user_data);
static void qimsys_application_manager_focus_changed(DBusGProxy *proxy, guint value, gpointer user_data);
static void qimsys_application_manager_composing_changed(DBusGProxy *proxy, gboolean value, gpointer user_data);
static void qimsys_application_manager_input_language_changed(DBusGProxy *proxy, char *value, gpointer user_data);
static void qimsys_application_manager_current_engine_changed(DBusGProxy *proxy, char *value, gpointer user_data);
static void qimsys_application_manager_triggered(DBusGProxy *proxy, int value, gpointer user_data);
static void qimsys_application_manager_settings_updated(DBusGProxy *proxy, char *value, gpointer user_data);

static void qimsys_application_manager_class_init(QimsysApplicationManagerClass *klass)
{
    qimsys_debug_in();
    qimsys_application_manager_signals[QIMSYSAPPLICATIONMANAGER_DISPLAY_LANGUAGE_CHANGED]
            = g_signal_new("display-language-changed",
                           G_TYPE_FROM_CLASS(klass),
                           G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION,
                           G_STRUCT_OFFSET(QimsysApplicationManagerClass, qimsys_application_manager),
                           NULL, NULL,
                           g_cclosure_marshal_VOID__STRING,
                           G_TYPE_NONE, 1, G_TYPE_STRING);
    qimsys_application_manager_signals[QIMSYSAPPLICATIONMANAGER_FOCUS_CHANGED]
            = g_signal_new("focus-changed",
                           G_TYPE_FROM_CLASS(klass),
                           G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION,
                           G_STRUCT_OFFSET(QimsysApplicationManagerClass, qimsys_application_manager),
                           NULL, NULL,
                           g_cclosure_marshal_VOID__UINT,
                           G_TYPE_NONE, 1, G_TYPE_UINT);
    qimsys_application_manager_signals[QIMSYSAPPLICATIONMANAGER_COMPOSING_CHANGED]
            = g_signal_new("composing-changed",
                           G_TYPE_FROM_CLASS(klass),
                           G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION,
                           G_STRUCT_OFFSET(QimsysApplicationManagerClass, qimsys_application_manager),
                           NULL, NULL,
                           g_cclosure_marshal_VOID__BOOLEAN,
                           G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
    qimsys_application_manager_signals[QIMSYSAPPLICATIONMANAGER_INPUT_LANGUAGE_CHANGED]
            = g_signal_new("input-language-changed",
                           G_TYPE_FROM_CLASS(klass),
                           G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION,
                           G_STRUCT_OFFSET(QimsysApplicationManagerClass, qimsys_application_manager),
                           NULL, NULL,
                           g_cclosure_marshal_VOID__STRING,
                           G_TYPE_NONE, 1, G_TYPE_STRING);
    qimsys_application_manager_signals[QIMSYSAPPLICATIONMANAGER_CURRENT_ENGINE_CHANGED]
            = g_signal_new("current-engine-changed",
                           G_TYPE_FROM_CLASS(klass),
                           G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION,
                           G_STRUCT_OFFSET(QimsysApplicationManagerClass, qimsys_application_manager),
                           NULL, NULL,
                           g_cclosure_marshal_VOID__STRING,
                           G_TYPE_NONE, 1, G_TYPE_STRING);
    qimsys_application_manager_signals[QIMSYSAPPLICATIONMANAGER_TRIGGERED]
            = g_signal_new("triggered",
                           G_TYPE_FROM_CLASS(klass),
                           G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION,
                           G_STRUCT_OFFSET(QimsysApplicationManagerClass, qimsys_application_manager),
                           NULL, NULL,
                           g_cclosure_marshal_VOID__INT,
                           G_TYPE_NONE, 1, G_TYPE_INT);
    qimsys_application_manager_signals[QIMSYSAPPLICATIONMANAGER_SETTINGS_UPDATED]
            = g_signal_new("settings-updated",
                           G_TYPE_FROM_CLASS(klass),
                           G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION,
                           G_STRUCT_OFFSET(QimsysApplicationManagerClass, qimsys_application_manager),
                           NULL, NULL,
                           g_cclosure_marshal_VOID__STRING,
                           G_TYPE_NONE, 1, G_TYPE_STRING);
    qimsys_debug_out();
}

static void qimsys_application_manager_init(QimsysApplicationManager *qam)
{
    qimsys_debug_in();
    QimsysAbstractIpcObject *qaio;

    qaio = QIMSYSABSTRACTIPCOBJECT(qam);

    /* Create a proxy object */
    qimsys_abstract_ipc_object_connect(qaio, QIMSYS_DBUS_SERVICE, "/QimsysApplicationManager", "local.ApplicationManager");

    dbus_g_proxy_add_signal(qaio->proxy, "displayLanguageChanged", G_TYPE_STRING, G_TYPE_INVALID);
    dbus_g_proxy_connect_signal(qaio->proxy, "displayLanguageChanged", G_CALLBACK(qimsys_application_manager_display_language_changed), qam, NULL);

    dbus_g_proxy_add_signal(qaio->proxy, "focusChanged", G_TYPE_UINT, G_TYPE_INVALID);
    dbus_g_proxy_connect_signal(qaio->proxy, "focusChanged", G_CALLBACK(qimsys_application_manager_focus_changed), qam, NULL);

    dbus_g_proxy_add_signal(qaio->proxy, "composingChanged", G_TYPE_BOOLEAN, G_TYPE_INVALID);
    dbus_g_proxy_connect_signal(qaio->proxy, "composingChanged", G_CALLBACK(qimsys_application_manager_composing_changed), qam, NULL);

    dbus_g_proxy_add_signal(qaio->proxy, "inputLanguageChanged", G_TYPE_STRING, G_TYPE_INVALID);
    dbus_g_proxy_connect_signal(qaio->proxy, "inputLanguageChanged", G_CALLBACK(qimsys_application_manager_input_language_changed), qam, NULL);

    dbus_g_proxy_add_signal(qaio->proxy, "currentEngineChanged", G_TYPE_STRING, G_TYPE_INVALID);
    dbus_g_proxy_connect_signal(qaio->proxy, "currentEngineChanged", G_CALLBACK(qimsys_application_manager_current_engine_changed), qam, NULL);

    dbus_g_proxy_add_signal(qaio->proxy, "triggered", G_TYPE_INT, G_TYPE_INVALID);
    dbus_g_proxy_connect_signal(qaio->proxy, "triggered", G_CALLBACK(qimsys_application_manager_triggered), qam, NULL);

    dbus_g_proxy_add_signal(qaio->proxy, "settingsUpdated", G_TYPE_STRING, G_TYPE_INVALID);
    dbus_g_proxy_connect_signal(qaio->proxy, "settingsUpdated", G_CALLBACK(qimsys_application_manager_settings_updated), qam, NULL);

    qimsys_debug_out();
}

QimsysApplicationManager *qimsys_application_manager_new()
{
    return QIMSYSAPPLICATIONMANAGER(g_object_new(QIMSYSAPPLICATIONMANAGER_TYPE, NULL));
}

gboolean qimsys_application_manager_get_display_language(QimsysApplicationManager *qam, char **value)
{
    gboolean ret = TRUE;
    GError *error = NULL;

    CHECK_DBUS_ERROR(ret, !dbus_g_proxy_call(QIMSYSABSTRACTIPCOBJECT(qam)->proxy, "displayLanguage", &error, G_TYPE_INVALID, G_TYPE_STRING, value, G_TYPE_INVALID))
    return ret;
}

gboolean qimsys_application_manager_set_display_language(QimsysApplicationManager *qam, char *value)
{
    gboolean ret = TRUE;
    GError *error = NULL;

    CHECK_DBUS_ERROR (ret, !dbus_g_proxy_call(QIMSYSABSTRACTIPCOBJECT(qam)->proxy, "setDisplayLanguage", &error, G_TYPE_STRING, value, G_TYPE_INVALID, G_TYPE_INVALID))
    return ret;
}

void qimsys_application_manager_display_language_changed(DBusGProxy *proxy, char *value, gpointer user_data)
{
    g_signal_emit(QIMSYSAPPLICATIONMANAGER(user_data), qimsys_application_manager_signals[QIMSYSAPPLICATIONMANAGER_DISPLAY_LANGUAGE_CHANGED], 0, value);
}

gboolean qimsys_application_manager_get_focus(QimsysApplicationManager *qam, guint *value)
{
    gboolean ret = TRUE;
    GError *error = NULL;

    CHECK_DBUS_ERROR(ret, !dbus_g_proxy_call(QIMSYSABSTRACTIPCOBJECT(qam)->proxy, "focus", &error, G_TYPE_INVALID, G_TYPE_UINT, value, G_TYPE_INVALID))
    return ret;
}

gboolean qimsys_application_manager_set_focus(QimsysApplicationManager *qam, guint value)
{
    gboolean ret = TRUE;
    GError *error = NULL;

    CHECK_DBUS_ERROR (ret, !dbus_g_proxy_call(QIMSYSABSTRACTIPCOBJECT(qam)->proxy, "setFocus", &error, G_TYPE_UINT, value, G_TYPE_INVALID, G_TYPE_INVALID))
    return ret;
}

void qimsys_application_manager_focus_changed(DBusGProxy *proxy, guint value, gpointer user_data)
{
    g_signal_emit(QIMSYSAPPLICATIONMANAGER(user_data), qimsys_application_manager_signals[QIMSYSAPPLICATIONMANAGER_FOCUS_CHANGED], 0, value);
}

gboolean qimsys_application_manager_get_composing(QimsysApplicationManager *qam, gboolean *value)
{
    gboolean ret = TRUE;
    GError *error = NULL;

    CHECK_DBUS_ERROR(ret, !dbus_g_proxy_call(QIMSYSABSTRACTIPCOBJECT(qam)->proxy, "composing", &error, G_TYPE_INVALID, G_TYPE_BOOLEAN, value, G_TYPE_INVALID))
    return ret;
}

gboolean qimsys_application_manager_set_composing(QimsysApplicationManager *qam, gboolean value)
{
    gboolean ret = TRUE;
    GError *error = NULL;

    CHECK_DBUS_ERROR (ret, !dbus_g_proxy_call(QIMSYSABSTRACTIPCOBJECT(qam)->proxy, "setCompoting", &error, G_TYPE_BOOLEAN, value, G_TYPE_INVALID, G_TYPE_INVALID))
    return ret;
}

void qimsys_application_manager_composing_changed(DBusGProxy *proxy, gboolean value, gpointer user_data)
{
    g_signal_emit(QIMSYSAPPLICATIONMANAGER(user_data), qimsys_application_manager_signals[QIMSYSAPPLICATIONMANAGER_COMPOSING_CHANGED], 0, value);
}

gboolean qimsys_application_manager_get_input_language(QimsysApplicationManager *qam, char **value)
{
    gboolean ret = TRUE;
    GError *error = NULL;

    CHECK_DBUS_ERROR(ret, !dbus_g_proxy_call(QIMSYSABSTRACTIPCOBJECT(qam)->proxy, "inputLanguage", &error, G_TYPE_INVALID, G_TYPE_STRING, value, G_TYPE_INVALID))
    return ret;
}

gboolean qimsys_application_manager_set_input_language(QimsysApplicationManager *qam, char *value)
{
    gboolean ret = TRUE;
    GError *error = NULL;

    CHECK_DBUS_ERROR (ret, !dbus_g_proxy_call(QIMSYSABSTRACTIPCOBJECT(qam)->proxy, "setInputLanguage", &error, G_TYPE_STRING, value, G_TYPE_INVALID, G_TYPE_INVALID))
    return ret;
}

void qimsys_application_manager_input_language_changed(DBusGProxy *proxy, char *value, gpointer user_data)
{
    g_signal_emit(QIMSYSAPPLICATIONMANAGER(user_data), qimsys_application_manager_signals[QIMSYSAPPLICATIONMANAGER_INPUT_LANGUAGE_CHANGED], 0, value);
}

gboolean qimsys_application_manager_get_current_engine(QimsysApplicationManager *qam, char **value)
{
    gboolean ret = TRUE;
    GError *error = NULL;

    CHECK_DBUS_ERROR(ret, !dbus_g_proxy_call(QIMSYSABSTRACTIPCOBJECT(qam)->proxy, "currentEngine", &error, G_TYPE_INVALID, G_TYPE_STRING, value, G_TYPE_INVALID))
    return ret;
}

gboolean qimsys_application_manager_set_current_engine(QimsysApplicationManager *qam, char *value)
{
    gboolean ret = TRUE;
    GError *error = NULL;

    CHECK_DBUS_ERROR (ret, !dbus_g_proxy_call(QIMSYSABSTRACTIPCOBJECT(qam)->proxy, "setCurrentEngine", &error, G_TYPE_STRING, value, G_TYPE_INVALID, G_TYPE_INVALID))
    return ret;
}

void qimsys_application_manager_current_engine_changed(DBusGProxy *proxy, char *value, gpointer user_data)
{
    g_signal_emit(QIMSYSAPPLICATIONMANAGER(user_data), qimsys_application_manager_signals[QIMSYSAPPLICATIONMANAGER_CURRENT_ENGINE_CHANGED], 0, value);
}

gboolean qimsys_application_manager_exec(QimsysApplicationManager *qam, int value)
{
    gboolean ret = TRUE;
    GError *error = NULL;

    CHECK_DBUS_ERROR (ret, !dbus_g_proxy_call(QIMSYSABSTRACTIPCOBJECT(qam)->proxy, "exec", &error, G_TYPE_INT, value, G_TYPE_INVALID, G_TYPE_INVALID))
    return ret;
}

void qimsys_application_manager_triggered(DBusGProxy *proxy, int value, gpointer user_data)
{
    g_signal_emit(QIMSYSAPPLICATIONMANAGER(user_data), qimsys_application_manager_signals[QIMSYSAPPLICATIONMANAGER_TRIGGERED], 0, value);
}

gboolean qimsys_application_manager_settings_update(QimsysApplicationManager *qam, char *value)
{
    gboolean ret = TRUE;
    GError *error = NULL;

    CHECK_DBUS_ERROR (ret, !dbus_g_proxy_call(QIMSYSABSTRACTIPCOBJECT(qam)->proxy, "settingsUpdate", &error, G_TYPE_STRING, value, G_TYPE_INVALID, G_TYPE_INVALID))
    return ret;
}

void qimsys_application_manager_settings_updated(DBusGProxy *proxy, char *value, gpointer user_data)
{
    g_signal_emit(QIMSYSAPPLICATIONMANAGER(user_data), qimsys_application_manager_signals[QIMSYSAPPLICATIONMANAGER_SETTINGS_UPDATED], 0, value);
}
