#ifndef WIDGETSETTINGS_H
#define WIDGETSETTINGS_H

#include <QSize>
#include <QDialog>
#include "config.h"
#include "sheet.h"

namespace Ui {
    class WidgetSettings;
}

class WidgetSettings : public QDialog
{
    Q_OBJECT

public:
    explicit WidgetSettings(QWidget *parent = 0);
    ~WidgetSettings();

    QSize getSize()
    { return _size; }
    TransitionsEnum getTransition()
    { return _transition; }
    QString getTheme()
    { return _theme; }
    ActionEnum getClickAction()
    { return _clickAction; }

private:
    Ui::WidgetSettings *ui;
    QSize _size;
    TransitionsEnum _transition;
    ActionEnum _clickAction;
    QString _theme;

    void updateCustomWidgets();

private slots:
    void on_clickCombo_activated(int index);
    void on_themesCombo_activated(QString );
    void on_transitionCombo_activated(int index);
    void on_pushButton_clicked();
    void on_customSizeButton_clicked();
    void on_size1Button_clicked();
    void on_size2Button_clicked();
    void on_size3Button_clicked();
    void on_wSpinBox_editingFinished();
    void on_hSpinBox_editingFinished();
};

#endif // WIDGETSETTINGS_H
