#ifndef SHEET_H
#define SHEET_H

#include <QWidget>
#include <QResizeEvent>
#include <QPaintEvent>
#include <QRect>
#include <QPainter>
#include <QPixmap>
#include <QTimeLine>

#include "theme.h"

enum TransitionsEnum {
    Transition_None,
    Transition_Slide,
    Transition_Flip,
    Transition_Rotate
};

Q_DECLARE_METATYPE (TransitionsEnum);

class Sheet : public QWidget
{
    Q_OBJECT
public:
    Sheet(QWidget *parent = 0,
          Theme *theme = 0);
    void setTransition(TransitionsEnum tr);
    TransitionsEnum transition() const;
    void setNumber(int n);
    void flipTo(int n, bool force);
    void reloadTheme();

protected:
    void drawFrame(QPainter *p, const QRect &rect);
    QPixmap drawDigits(int n, const QRect &rect);
    void preparePixmap();
    void paintEvent(QPaintEvent *event);
    void resizeEvent(QResizeEvent*);
    void paintStatic();
    void paintSlide();
    void paintFlip();
    void paintRotate();

private:
    int _number;
    TransitionsEnum _transition;
    QPixmap _pixmap;
    QPixmap _lastPixmap;
    QTimeLine _animator;
    Theme * _theme;
};

#endif // SHEET_H
