#include "infowindow.h"
#include <QMaemo5ValueButton>
#include <QMaemo5ListPickSelector>
#include <QStandardItemModel>

int i = 0;
int h = 180, w = 760;
InfoWindow::InfoWindow(QWidget *parent) :
    QMainWindow(parent)
{
    setAttribute(Qt::WA_Maemo5StackedWindow);

    xml = new XML();



    QWidget *widget = new QWidget();
    setCentralWidget(widget);

    QVBoxLayout *vLayout = new QVBoxLayout;
    QHBoxLayout *hLabelLayout = new QHBoxLayout;
    gLayout = new QGridLayout();

    lblName = new QLabel("name");
    lblMuscle = new QLabel("muscle");
    lblSet = new QLabel("set");
    lblRest = new QLabel("rest");
    lblLast = new QLabel("last time");
    lblInfo = new QLabel("info on how to do");
    txtInfo = new QTextEdit();
    txtInfo->setReadOnly(true);

    lblInfo->setSizePolicy(QSizePolicy::Expanding,QSizePolicy::Expanding);
    vLayout->addWidget(lblName);
    vLayout->addWidget(lblMuscle);

    hLabelLayout->addWidget(lblSet);
    hLabelLayout->addWidget(lblRest);
    vLayout->addLayout(hLabelLayout);

    vLayout->addWidget(lblLast);

    gLayout->addWidget(txtInfo);
    vLayout->addLayout(gLayout);

    gButtonLayout = new QGridLayout;
    btnBack = new QPushButton("<---");
    btnForward = new QPushButton("--->");
    btnStart = new QPushButton("Start");
    gButtonLayout->addWidget(btnBack,0,0);
    gButtonLayout->addWidget(btnForward,0,2);
    gButtonLayout->addWidget(btnStart,0,1);
    vLayout->addLayout(gButtonLayout);


    //vLayout->addWidget(btnStart);

    widget->setLayout(vLayout);
    createActions();
    createMenu();

    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));

}

void InfoWindow::sendClosed()
{
    emit closed();
}

void InfoWindow::sendLandscape()
{
    emit landscape();
}

void InfoWindow::orientationChanged()
{
    QRect screenGeometry = QApplication::desktop()->screenGeometry();
    QString str;
    if (screenGeometry.width() > screenGeometry.height())
    {
        w = 760;
        h = 180;
    }
    else
    {
        w = 440;
        h = 550;
    }
    QPixmap bild(w,h);

    if(i == 1)
    {
        str = "/home/user/.qexercise/Images" + exerciseName + "1.png";
        str.replace(QString(" "), QString(""));

        bild.load(str);
    }
    else if(i == 2)
    {
        str = "/home/user/.qexercise/Images/" + exerciseName + "2.png";
        str.replace(QString(" "), QString(""));

        bild.load(str);
    }
    bild = bild.scaled(w,h,Qt::KeepAspectRatio);
    lblInfo->setAlignment(Qt::AlignCenter);
    lblInfo->setPixmap(bild);
}

void InfoWindow::showNewIngredient()
{
    niw = new NewIngredientWindow(this);
    niw->load();
    niw->show();
}

void InfoWindow::showHistory()
{
    hw = new HistoryWindow(this);
    hw->load();
    hw->show();
}

void InfoWindow::showSettings()
{
    sw = new SettingsWindow(this);
    sw->show();
}

void InfoWindow::showNewExercise()
{
    nw = new NewExerciseWindow(this);
    emit landscape();
    connect(nw,SIGNAL(closed()),this,SLOT(sendClosed()));
    nw->load();
    nw->show();
}

void InfoWindow::showNewProgram()
{
    npw = new NewProgramWindow(this);
    npw->load();
    npw->show();
}

void InfoWindow::createMenu()
{
    QMenu *menu;
    menu = menuBar()->addMenu(tr("&Menu"));
    menu->addAction(historyAction);
    menu->addAction(settingsAction);
    menu->addAction(newExerciseAction);
    menu->addAction(newProgramAction);
    menu->addAction(newIngredientAction);
}

void InfoWindow::createActions()
{
    historyAction = new QAction("History",this);
    settingsAction = new QAction("Settings",this);
    newExerciseAction = new QAction("New Exercise",this);
    newProgramAction = new QAction("New program",this);
    newIngredientAction = new QAction("New Ingredient",this);

    connect(historyAction, SIGNAL(triggered()), this, SLOT(showHistory()));
    connect(settingsAction, SIGNAL(triggered()), this, SLOT(showSettings()));
    connect(newExerciseAction, SIGNAL(triggered()), this, SLOT(showNewExercise()));
    connect(newProgramAction, SIGNAL(triggered()), this, SLOT(showNewProgram()));
    connect(newIngredientAction, SIGNAL(triggered()), this, SLOT(showNewIngredient()));

    connect(btnStart,SIGNAL(clicked()),this,SLOT(startExercise()));
    connect(btnForward, SIGNAL(clicked()), this, SLOT(forward()));
    connect(btnBack, SIGNAL(clicked()), this, SLOT(back()));
}

void InfoWindow::changeEvent(QEvent *event)
{
    if(event->type() == QEvent::ActivationChange)
        loadExercise(exerciseName);
}

void InfoWindow::loadExercise(QString name)
{
    qDebug () << "load exercise 1";
    QList <QString> list;

    QString min, sec;
    int i = 0;
    QString lastText;

    exerciseName = name;

    list = xml->openEx(exerciseName);
    lblName->setText(list.takeFirst());
    list.takeFirst();
    lblMuscle->setText(list.takeFirst());
    info = list.takeFirst();

    qDebug () << "load exercise 2";

    list = xml->loadSettings();
    if(list.isEmpty())
        return;
    qDebug () << "load exercise 3";
    list.removeLast(); //remove calories
    sec = list.takeLast(); min = list.takeLast();
    lblRest->setText(min + ":" + sec + " rest");
    lblSet->setText(list.takeLast() + " Set");
    qDebug () << "load exercise 4";
    txtInfo->setText(info);


    list = xml->getHistoryByExercise(exerciseName);

    if(list.isEmpty())
    {
        lblLast->setText("Exercise have never been done.");
        return;
    }

    while(!list.isEmpty())
    {
        weight[i] = list.takeFirst();
        reps[i] = list.takeFirst();
        status[i] = list.takeFirst();

        i++;
    }
    qDebug () << "load exercise 5";
    i = 0;
    lastText = "";
    while(weight[i] != "" && i < 9)
    {
        lastText.append(weight[i] + "x" + reps[i]);
        if(i < 8)
        {
            if(weight[i+1] != "")
                lastText.append(", ");
        }
        qDebug () << "load exercise " << lastText;
        i++;
    }
    qDebug () << "load exercise 6";
    lblLast->setText("Last time: " + lastText);

}

void InfoWindow::startExercise()
{
    QList <QString> list;
    list.append(exerciseName);

    ew = new ExerciseWindow(this);
    connect(ew,SIGNAL(closed()),this,SLOT(sendClosed()));
    connect(ew,SIGNAL(landscape()),this, SLOT(sendLandscape()));
    ew->loadExercise(list);
    ew->show();
}

void InfoWindow::forward()
{
    QString str;
    if(i == 2)
    {
        i = 0;
        gLayout->removeWidget(lblInfo);
        lblInfo->hide();
        gLayout->addWidget(txtInfo);
        txtInfo->show();
        txtInfo->setText(info);
        return;
    }

    else if(i == 1)
    {
        //if(info[2] != "")
        //{
            QPixmap bild(w,h);
            str = "/home/user/.qexercise/Images/" + exerciseName + "2.png";
            str.replace(QString(" "), QString(""));


            if(!bild.load(str))
            {
                i = 2;
                forward();
                return;
            }
            else
            {
                bild = bild.scaled(w,h,Qt::KeepAspectRatio);
                lblInfo->setAlignment(Qt::AlignCenter);
                lblInfo->setPixmap(bild);
                i++;
            }
            //}
         return;
    }

    else if(i == 0)
    {
        //if(info[1] != "")
        //{
            gLayout->removeWidget(txtInfo);
            txtInfo->hide();
            gLayout->addWidget(lblInfo);
            lblInfo->show();
            QPixmap bild(w,h);
            str = "/home/user/.qexercise/Images/" + exerciseName + "1.png";
            str.replace(QString(" "), QString(""));


            if(!bild.load(str))
            {
                i = 1;
                forward();
                return;
            }
            else
            {
                bild = bild.scaled(w,h,Qt::KeepAspectRatio);
                lblInfo->setAlignment(Qt::AlignCenter);
                lblInfo->setPixmap(bild);
                i++;
            }
        //}
         return;
    }
}

void InfoWindow::back()
{
    QString str;
    if(i == 0)
    {
        //if(info[2] != "")
        //{
            gLayout->removeWidget(txtInfo);
            txtInfo->hide();
            gLayout->addWidget(lblInfo);
            lblInfo->show();
            QPixmap bild(w,h);
            str = "/home/user/.qexercise/Images/" + exerciseName + "2.png";
            str.replace(QString(" "), QString(""));


            if(!bild.load(str))
            {
                i = 2;
                back();
                return;
            }
            else
            {
                bild = bild.scaled(w,h,Qt::KeepAspectRatio);
                lblInfo->setAlignment(Qt::AlignCenter);
                lblInfo->setPixmap(bild);
                i=2;
            }
        //}
         return;
    }
    else if(i == 1)
    {
        gLayout->removeWidget(lblInfo);
        lblInfo->hide();
        gLayout->addWidget(txtInfo);
        txtInfo->show();
        lblInfo->setAlignment(Qt::AlignLeft);
        lblInfo->setAlignment(Qt::AlignTop);
        lblInfo->setText(info);
        i--;
    }
    else if(i == 2)
    {
        //if(info[1] != "")
        //{
            QPixmap bild(w,h);
            str = "/home/user/.qexercise/Images/" + exerciseName + "1.png";
            str.replace(QString(" "), QString(""));

            if(!bild.load(str))
            {
                i = 1;
                back();
                return;
            }
            else
            {
                bild = bild.scaled(w,h,Qt::KeepAspectRatio);
                lblInfo->setAlignment(Qt::AlignCenter);
                lblInfo->setPixmap(bild);
                i--;
            }
        //}
        return;

    }
}
