#include "exercisedialog.h"

ExerciseDialog::ExerciseDialog(QWidget *parent)
{
    setAttribute(Qt::WA_Maemo5StackedWindow);
    setAttribute(Qt::WA_Maemo5PortraitOrientation);

    //setWindowFlags(this->windowFlags() | Qt::Window);
    setWindowTitle("Choose exercise");

    QHBoxLayout *hLayout = new QHBoxLayout();

    lstExercises = new QListView();
    model = new QStandardItemModel(this);
    lstExercises->setModel(model);
    hLayout->addWidget(lstExercises);

    btnStart = new QPushButton("Start");
    connect(btnStart, SIGNAL(clicked()),this,SLOT(start()));
    hLayout->addWidget(btnStart);

    resize(480,550);
    setLayout(hLayout);
}
ExerciseDialog::~ExerciseDialog()
{
}

void ExerciseDialog::load(QList <QString> exercises)
{
    while(!exercises.isEmpty())
    {
        model->appendRow(new QStandardItem(exercises.takeFirst()));
    }
    model->sort(0);
}

void ExerciseDialog::start()
{
    QString name = lstExercises->currentIndex().data().toString();
    emit exerciseName(name);

    emit close();
}

void ExerciseDialog::closeEvent(QCloseEvent *event)
{
    return event->ignore();
}
