#include "historyinfowindow.h"

HistoryInfoWindow::HistoryInfoWindow(QWidget *parent) :
    QMainWindow(parent)
{
    QString set;
    setAttribute(Qt::WA_Maemo5StackedWindow);
    setAttribute(Qt::WA_Maemo5PortraitOrientation);

    QWidget *widget = new QWidget();
    QVBoxLayout *vLayout = new QVBoxLayout();

    for(int i = 0; i < 9; i++)
    {
        set.setNum(i+1);
        lblSet[i] = new QLabel("Set " + set + ": No info.");
        vLayout->addWidget(lblSet[i]);
    }


    xml = new XML();

    widget->setLayout(vLayout);
    setCentralWidget(widget);
}

void HistoryInfoWindow::load(QString name, QString group, QString date)
{
    QList <QString> list;
    int j = 0;
    QString set;

    setWindowTitle(name);

    list = xml->getHistoryByExercise(name, date);

    if(list.isEmpty())
        return;

    while(!list.isEmpty())
    {
        set.setNum(j+1);
        if(group != "Cardio" && list.first() != "0")
            lblSet[j]->setText("Set " + set + ": " + list.takeFirst() +" " +
                                list.takeFirst() + " reps - " + list.takeFirst());
        else if(list.first() != "0")
            lblSet[j]->setText("Set " + set + ": " + list.takeFirst() + " km on " +
                                list.takeFirst() + " - " + list.takeFirst());
        else
        {
            list.removeFirst();
            list.removeFirst();
            list.removeFirst();
        }

        j++;
    }
}
