#include "dayhistory.h"

DayHistory::DayHistory(QWidget *parent) :
        QMainWindow(parent)
{
    setAttribute(Qt::WA_Maemo5StackedWindow);

    xml = new XML();

    lstExercises = new QListView();
    model = new QStandardItemModel(this);
    lstExercises->setModel(model);
    connect(lstExercises,SIGNAL(clicked(QModelIndex)),this,SLOT(showInfo(QModelIndex)));
    lstExercises->setContextMenuPolicy(Qt::CustomContextMenu);
    connect(lstExercises, SIGNAL(customContextMenuRequested(const QPoint &)),SLOT(showContextMenuForWidget(const QPoint &)));

    setCentralWidget (lstExercises);
}

void DayHistory::showInfo(QModelIndex index)
{
    QString name, group;
    int mid;

    mid = index.data().toString().indexOf("/");
    group = index.data().toString().left(mid);
    mid = index.data().toString().count() - mid - 1;
    name = index.data().toString().right(mid);


    hiw = new HistoryInfoWindow(this);
    hiw->load(name,group, currentDate);
    hiw->show();
}

void DayHistory::changeEvent(QEvent *event)
{
    if(event->type() == QEvent::ActivationChange)
    {
        load(currentDate);
    }
}

void DayHistory::load(QString date)
{
    QList <QString> tmp;
    QString name, group;

    currentDate = date;
    setWindowTitle(date);
    model->clear();
    exercises = xml->getHistoryByDate(date);

    while(!exercises.isEmpty())
    {
        tmp = exercises.takeFirst();
        name = tmp.takeFirst();
        group = tmp.takeFirst();

        model->appendRow(new QStandardItem(group + "/" + name ));
    }

}

void DayHistory::showContextMenuForWidget(const QPoint &pos)
{
    QMenu contextMenu(this);
    //QAction *editItemAction = new QAction("Edit", this);
    QAction *deleteItemAction = new QAction("Remove", this);

    //connect(editItemAction, SIGNAL(triggered()), this, SLOT(editItem()));
    connect(deleteItemAction, SIGNAL(triggered()), this, SLOT(deleteItem()));



    //contextMenu.addAction(editItemAction);
    contextMenu.addAction(deleteItemAction);
    contextMenu.exec(mapToGlobal(pos));
}

void DayHistory::deleteItem()
{
    QString name, str;
    int mid;

    str = lstExercises->currentIndex().data().toString();
    mid = str.indexOf("/");
    mid = str.count() - mid - 1;
    name = str.right(mid);


    qDebug() << "ListWindow::deleteItem 1";


    for(int i = 0; i < model->rowCount();i++)
    {
        if(model->index(i,0).data().toString() == str)
            model->removeRow(i);
    }
    qDebug() << "ListWindow::deleteItem 2";
    QMessageBox msgBox;
     msgBox.setText("Do you really want to remove " + str + " from history?");
     msgBox.setStandardButtons(QMessageBox::Ok | QMessageBox::Cancel);
     msgBox.setDefaultButton(QMessageBox::Cancel);
     int ret = msgBox.exec();
    qDebug() << "ListWindow::deleteItem 3";
     if(ret == QMessageBox::Ok)
     {

         qDebug() << "ListWindow::deleteItem 4";
         xml->removeHistory(str,currentDate);
     }
}
