#include "weightsettings.h"

WeightSettings::WeightSettings(QWidget *parent)
{
    setAttribute(Qt::WA_Maemo5StackedWindow);
    setAttribute(Qt::WA_Maemo5PortraitOrientation);
    setWindowTitle("Weight settings");

    QVBoxLayout *vLayout = new QVBoxLayout;

    modelSet = new QStandardItemModel(this);
    for (int i = 1; i < 10; i++)
        modelSet->appendRow(new QStandardItem(tr("%1").arg(i)));

    btnSet = new QMaemo5ValueButton("Set");
    btnSet->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    selectorSet = new QMaemo5ListPickSelector;
    selectorSet->setModel(modelSet);
    btnSet->setPickSelector(selectorSet);


    modelMin = new QStandardItemModel(this);
    for (int i = 0; i < 6; i++)
        modelMin->appendRow(new QStandardItem(tr("%1").arg(i)));

    btnMin = new QMaemo5ValueButton("Minutes");
    btnMin->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    selectorMin = new QMaemo5ListPickSelector;
    selectorMin->setModel(modelMin);
    btnMin->setPickSelector(selectorMin);

    modelSec = new QStandardItemModel(this);
    for (int i = 0; i < 12; i++)
        modelSec->appendRow(new QStandardItem(tr("%1").arg(i*5)));

    btnSec = new QMaemo5ValueButton("Seconds");
    btnSec->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    selectorSec = new QMaemo5ListPickSelector;
    selectorSec->setModel(modelSec);
    btnSec->setPickSelector(selectorSec);


    vLayout->addWidget(btnSet);

    vLayout->addWidget(btnMin);
    vLayout->addWidget(btnSec);

    setLayout(vLayout);

    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));
}

void WeightSettings::orientationChanged()
{
    QRect screenGeometry = QApplication::desktop()->screenGeometry();

    if (screenGeometry.width() > screenGeometry.height())
    {
        btnSet->setValueLayout(QMaemo5ValueButton::ValueBesideText);
        btnMin->setValueLayout(QMaemo5ValueButton::ValueBesideText);
        btnSec->setValueLayout(QMaemo5ValueButton::ValueBesideText);
    }
    else
    {
        btnSet->setValueLayout(QMaemo5ValueButton::ValueUnderText);
        btnMin->setValueLayout(QMaemo5ValueButton::ValueUnderText);
        btnSec->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    }


}

void WeightSettings::save()
{
    QList <QString> settings = xml->loadSettings();
    if(settings.isEmpty())
        return;

    xml->saveSettings("" + settings.takeFirst(),
                 "" + settings.takeFirst(),
                 "" + settings.takeFirst(),
                 "" + btnSet->valueText(),
                 "" + btnMin->valueText(),
                 "" + btnSec->valueText(),
                 "" + settings.takeLast());
}

void WeightSettings::load()
{
    QList<QString> settings;

    settings = xml->loadSettings();
    if(settings.isEmpty())
        return;

    for(int i = 0; i < 3; i++)
        settings.removeFirst();

    btnSet->setValueText(settings.takeFirst());
    btnMin->setValueText(settings.takeFirst());
    btnSec->setValueText(settings.takeFirst());
}

void WeightSettings::closeEvent(QCloseEvent *event)
{
    save();
}
