#include "newexercisewindow.h"
#include <QMaemo5InformationBox>
#include <QDebug>

NewExerciseWindow::NewExerciseWindow(QWidget *parent) :
    QDialog(parent)
{
    setAttribute(Qt::WA_Maemo5StackedWindow);
    setAttribute(Qt::WA_Maemo5LandscapeOrientation);
    setWindowTitle("New exercise");
    xml = new XML();

    //QWidget *widget = new QWidget();
    //setCentralWidget(widget);



    QVBoxLayout *vLayout = new QVBoxLayout();

    QHBoxLayout *txtLayout = new QHBoxLayout();

    txtName = new QLineEdit();
    txtName->setPlaceholderText("Name");
    txtMuscle = new QLineEdit();
    txtMuscle->setPlaceholderText("Muscle");
    txtHowTo = new QTextEdit("How to...");
    txtHowTo->setSizePolicy(QSizePolicy::Expanding,QSizePolicy::Expanding);
    txtLayout->addWidget(txtName);
    txtLayout->addWidget(txtMuscle);

    model = new QStandardItemModel(this);
    model->appendRow(new QStandardItem(tr("Arms")));
    model->appendRow(new QStandardItem(tr("Back")));
    model->appendRow(new QStandardItem(tr("Cardio")));
    model->appendRow(new QStandardItem(tr("Chest")));
    model->appendRow(new QStandardItem(tr("Legs")));
    model->appendRow(new QStandardItem(tr("Shoulder")));
    model->appendRow(new QStandardItem(tr("Stomach")));

    btnGroup = new QMaemo5ValueButton("Group");
    btnGroup->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    selectorGroup = new QMaemo5ListPickSelector;
    selectorGroup->setModel(model);
    btnGroup->setPickSelector(selectorGroup);
    btnGroup->setValueText("Arms");
    txtLayout->addWidget(btnGroup);

    btnPic1 = new QMaemo5ValueButton("Start image");
    connect(btnPic1,SIGNAL(clicked()),this,SLOT(savePic1()));
    btnPic2 = new QMaemo5ValueButton("End image");
    connect(btnPic2,SIGNAL(clicked()),this,SLOT(savePic2()));


    btnSave = new QPushButton("Save");

    //vLayout->addWidget(txtName);
    vLayout->addLayout(txtLayout);
    //vLayout->addWidget(txtMuscle);
    //vLayout->addWidget(btnGroup);
    vLayout->addWidget(txtHowTo);

    QHBoxLayout *picLayout = new QHBoxLayout();
    picLayout->addWidget(btnPic1);
    picLayout->addWidget(btnPic2);
    vLayout->addLayout(picLayout);

    vLayout->addWidget(btnSave);

    setLayout(vLayout);

    connect(btnSave, SIGNAL(clicked()),this, SLOT(saveExercise()));
    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));
}

void NewExerciseWindow::savePic1()
{
    pic1 = QFileDialog::getOpenFileName(this,"Choose an image","/home/user/MyDocs","PNG files (*.png)");
    btnPic1->setValueText(pic1);
}

void NewExerciseWindow::savePic2()
{
    pic2 = QFileDialog::getOpenFileName(this,"Choose an image","/home/user/MyDocs","PNG files (*.png)");
    btnPic2->setValueText(pic2);
}

void NewExerciseWindow::saveExercise()
{
    qDebug () << "save new exercise 1";
    if(txtName->text() == "")
    {
        QMaemo5InformationBox::information(this, "You must fill in name.", QMaemo5InformationBox::DefaultTimeout);
        return;
    }
    else if(txtMuscle->text() == "")
    {
        QMaemo5InformationBox::information(this, "You must fill in muscle.", QMaemo5InformationBox::DefaultTimeout);
        return;
    }
    else if(btnGroup->valueText() == "")
    {
        QMaemo5InformationBox::information(this, "You must choose a group.", QMaemo5InformationBox::DefaultTimeout);
        return;
    }
    qDebug () << "save new exercise 2";
    QString name = txtName->text();
    QString group = btnGroup->valueText();
    QString muscle = txtMuscle->text();
    QString info = txtHowTo->toPlainText();
    QString tmpName;
    QDir dir;

    if(group == "Cardio")
    {
        qDebug () << "save new exercise 3";
        xml->saveCardio(name);
    }
    else
    {
        qDebug () << "save new exercise 4";
        xml->saveEx(name,group,muscle,info);
    }
    //if saved OK
    if(pic1 != "")
    {
        tmpName = name;
        tmpName.replace(" ", "");
        tmpName.append("1.png");
        dir.rename(pic1,"/home/user/.qexercise/Images/" + name);
    }
    if(pic2 != "")
    {
        tmpName = name;
        tmpName.replace(" ", "");
        tmpName.append("2.png");
        dir.rename(pic2,"/home/user/.qexercise/Images/" + name);
    }

    QMaemo5InformationBox::information(this, "Exercise saved.",
                                                QMaemo5InformationBox::DefaultTimeout);
    emit closed();
    this->destroy();

    //this->hide();
}

#
void NewExerciseWindow::closeEvent(QCloseEvent *event)
{
    emit closed();
    event->accept();
}

void NewExerciseWindow::load()
{
    btnGroup->setFocus();
    txtName->setText("");
    txtMuscle->setText("");;
    btnGroup->setValueText("");
    txtHowTo->setText("How to...");
}


void NewExerciseWindow::load(QString name, QString group, QString muscle, QString info)
{
    txtName->setEnabled(false);
    txtName->setText(name);
    txtMuscle->setText(muscle);
    btnGroup->setValueText(group);
    txtHowTo->setText(info);
}

void NewExerciseWindow::orientationChanged()
{
    QRect screenGeometry = QApplication::desktop()->screenGeometry();

    if (screenGeometry.width() > screenGeometry.height())
    {
        btnGroup->setValueLayout(QMaemo5ValueButton::ValueBesideText);
    }
    else
    {
        btnGroup->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    }


}
