#include "weightdialog.h"
#include <QDebug>

WeightDialog::WeightDialog(QWidget *parent)
{
    setAttribute(Qt::WA_Maemo5StackedWindow);
    setAttribute(Qt::WA_Maemo5PortraitOrientation);

    //setWindowFlags(this->windowFlags() | Qt::Window);
    setWindowTitle("Save weight");

    QHBoxLayout *hLayout = new QHBoxLayout();

    lstVar = new QListView();
    model = new QStandardItemModel(this);
    lstVar->setModel(model);
    hLayout->addWidget(lstVar);



    radioEasy = new QRadioButton("Easy");
    radioOK = new QRadioButton("Perfect");
    radioHard = new QRadioButton("Hard");

    QVBoxLayout *vLayout = new QVBoxLayout();
    vLayout->addWidget(radioEasy);
    vLayout->addWidget(radioOK);
    vLayout->addWidget(radioHard);
    hLayout->addLayout(vLayout);

    btnSave = new QPushButton("Save");

    hLayout->addWidget(btnSave);

    setLayout(hLayout);
    xml = new XML();
    //load();
    connect(btnSave, SIGNAL(clicked()),this,SLOT(save()));
}

void WeightDialog::load(QString name, QString grp, QString currentReps)
{
    exName = name;
    group = grp;
    reps = currentReps;

    for (int i = 1; i < 200; i++)
        model->appendRow(new QStandardItem(tr("%1").arg(i)+ "kg"));

    setWindowTitle("Save weight");

    //ViktDialog::ui->lstKg->setCurrentItem(ViktDialog::ui->lstKg->findItems("65",Qt::MatchExactly).takeFirst());//,QItemSelectionModel::Select);
}

void WeightDialog::loadCardio(QString name, QString m, QString s)
{
    group = "Cardio";
    exName = name;
    min = m;
    sec = s;

    for (double i = 1; i < 500; i++)
        model->appendRow(new QStandardItem(tr("%1").arg(i/10) + "km"));

    setWindowTitle("Save distance");

    //ViktDialog::ui->lstKg->setCurrentItem(ViktDialog::ui->lstKg->findItems("65",Qt::MatchExactly).takeFirst());//,QItemSelectionModel::Select);
}

void WeightDialog::save()
{
    QString status;
    if(radioOK->isChecked())
        status = "perfect";
    else if(radioEasy->isChecked())
        status = "easy";
    else if(radioHard->isChecked())
        status = "hard";
    else
        status = "error";

    int l = lstVar->currentIndex().data().toString().count();
    QString weight = lstVar->currentIndex().data().toString().left(l-2);


    if(group == "Cardio")
    {
        reps = min + ":" + sec;
        xml->updateLastDistance(exName, weight, min, sec, status);
    }
    else
    {
        xml->updateLastWeight(exName, weight, status, reps);
    }
    xml->saveDoneEx(group, exName, weight, reps);
    this->hide();

}
