#include "fooddialog.h"
#include <QtDebug>
FoodDialog::FoodDialog(QWidget *parent)
{
    setAttribute(Qt::WA_Maemo5StackedWindow);
    setAttribute(Qt::WA_Maemo5PortraitOrientation);

    setWindowTitle("Add calories");

    xml = new XML();

    vLayout = new QVBoxLayout();

    modelType = new QStandardItemModel(this);
    modelType->appendRow(new QStandardItem(tr("Drink")));
    modelType->appendRow(new QStandardItem(tr("Food")));

    btnType = new QMaemo5ValueButton("Product");
    btnType->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    selectorType = new QMaemo5ListPickSelector;
    selectorType->setModel(modelType);
    btnType->setPickSelector(selectorType);

    modelName = new QStandardItemModel(this);

    btnName = new QMaemo5ValueButton("Product");
    btnName->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    selectorName = new QMaemo5ListPickSelector;
    selectorName->setModel(modelName);
    btnName->setPickSelector(selectorName);


    modelAmount = new QStandardItemModel(this);
    for (int i = 1; i < 100; i++)
        modelAmount->appendRow(new QStandardItem(tr("%1").arg(i*5)));

    btnAmount = new QMaemo5ValueButton("Amount (g)");
    btnAmount->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    selectorAmount = new QMaemo5ListPickSelector;
    selectorAmount->setModel(modelAmount);
    btnAmount->setPickSelector(selectorAmount);

    btnAdd = new QPushButton("Add");
    connect(btnAdd,SIGNAL(clicked()),this,SLOT(save()));

    vLayout->addWidget(btnType);
    vLayout->addWidget(btnName);
    vLayout->addWidget(btnAmount);
    vLayout->addWidget(btnAdd);

    setLayout(vLayout);


}

void FoodDialog::load()
{
    QList <QString> food = xml->openIngredients();
    modelName->clear();
    while(!food.isEmpty())
    {
        modelName->appendRow(new QStandardItem(food.takeFirst()));
    }
    modelName->sort(0);
}

void FoodDialog::save()
{
    int kcal = xml->getCaloriesByName(btnName->valueText());

    kcal *= btnAmount->valueText().toInt();
    kcal /= 100;
    QString tmp; tmp.setNum(kcal);
    xml->saveEatenFood(tmp);
    hide();
}
