#include "qmlutils.h"
#include <QApplication>
#include <QFile>

QmlUtils::QmlUtils(QObject *parent) :
    QObject(parent)
{
}

QString QmlUtils::durationFromSecs(int secs) {
    return Utils::durationFromSecs(secs);
}

QString QmlUtils::durationFromMSecs(int msecs) {
    return Utils::durationFromMSecs(msecs);
}

QString QmlUtils::fileSizeFromPath(const QString &filePath) {
    return Utils::fileSizeFromPath(filePath);
}

QString QmlUtils::fileSizeFromBytes(double bytes) {
    return Utils::fileSizeFromBytes(bytes);
}

QString QmlUtils::dateFromSecs(qint64 secs, bool showTime) {
    return Utils::dateFromSecs(secs, showTime);
}

QString QmlUtils::dateFromMSecs(qint64 msecs, bool showTime) {
    return Utils::dateFromMSecs(msecs, showTime);
}

qint64 QmlUtils::currentDateTime() {
    return QDateTime::currentMSecsSinceEpoch();
}

QString QmlUtils::localDateTimeFromString(const QString &dateTimeString, Qt::DateFormat format) {
    return Utils::localDateTimeFromString(dateTimeString, format);
}

QString QmlUtils::readPrivacyPolicy() {
    QString fileName = QApplication::applicationDirPath().section('/', 0, -2) + "/resources/qdl_privacy_policy.html";
    QFile aFile(fileName);
    QString policy;

    if (aFile.open(QIODevice::ReadOnly)) {
        policy = aFile.readAll();
        aFile.close();
    }

    return policy;
}
