#ifndef PACKAGEPROPERTIESDIALOG_H
#define PACKAGEPROPERTIESDIALOG_H

#include "../shared/transfer.h"
#include <QDialog>

class PackageTransferModel;
class QListView;
class ValueSelector;

class PackagePropertiesDialog : public QDialog
{
    Q_OBJECT

public:
    explicit PackagePropertiesDialog(Transfer *package, QWidget *parent = 0);
    ~PackagePropertiesDialog();

private slots:
    void onTransferCountChanged(int count);
    void onPackageDataChanged(int role);
    void setPackageCategory(const QVariant &value);
    void setPackagePriority(const QVariant &value);
    
private:
    Transfer *m_package;
    PackageTransferModel *m_model;
    QListView *m_view;
    ValueSelector *m_categorySelector;
    ValueSelector *m_prioritySelector;
    QPushButton *m_startButton;
    QPushButton *m_pauseButton;
    QPushButton *m_removeButton;
};

#endif // PACKAGEPROPERTIESDIALOG_H
