#ifndef EDITSERVICEACCOUNTDIALOG_H
#define EDITSERVICEACCOUNTDIALOG_H

#include <QDialog>

class QLineEdit;
class QLabel;
class QPushButton;

class EditServiceAccountDialog : public QDialog
{
    Q_OBJECT

public:
    explicit EditServiceAccountDialog(QWidget *parent = 0);
    ~EditServiceAccountDialog();

    void setAccount(const QString &icon, const QString &serviceName, const QString &username, const QString &password);

private slots:
    void onAccountTextChanged();
    void submitAccount();

signals:
    void addAccount(const QString &serviceName, const QString &username, const QString &password);
    
private:
    QLabel *m_iconLabel;
    QLabel *m_nameLabel;
    QLineEdit *m_userEdit;
    QLineEdit *m_passEdit;
    QPushButton *m_doneButton;
};

#endif // EDITSERVICEACCOUNTDIALOG_H
