#ifndef NEWCATEGORYDIALOG_H
#define NEWCATEGORYDIALOG_H

#include <QDialog>

class QLineEdit;

class NewCategoryDialog : public QDialog
{
    Q_OBJECT

public:
    explicit NewCategoryDialog(QWidget *parent = 0);
    ~NewCategoryDialog();

public slots:
    void setName(const QString &name);
    void setPath(const QString &path);

private slots:
    void onNameTextChanged(const QString &text);
    void showFileDialog();
    void addCategory();

signals:
    void addCategory(const QString &name, const QString &path);
    
private:
    QLineEdit *m_nameEdit;
    QLineEdit *m_pathEdit;
    QPushButton *m_browseButton;
    QPushButton *m_doneButton;
};

#endif // NEWCATEGORYDIALOG_H
