#ifndef ARCHIVESETTINGSTAB_H
#define ARCHIVESETTINGSTAB_H

#include <QWidget>

class ArchivePasswordsModel;
class QLineEdit;
class QCheckBox;
class QListView;
class QPushButton;
class QMenu;

class ArchiveSettingsTab : public QWidget
{
    Q_OBJECT

public:
    explicit ArchiveSettingsTab(QWidget *parent = 0);
    ~ArchiveSettingsTab();

public slots:
    void saveSettings();

private:
    void loadSettings();

private slots:
    void showContextMenu(const QPoint &pos);
    void onPasswordEditTextChanged(const QString &text);
    void addArchivePassword();
    void removeArchivePassword();
    
private:
    QCheckBox *m_extractCheckbox;
    QCheckBox *m_subfoldersCheckbox;
    QCheckBox *m_deleteCheckbox;
    ArchivePasswordsModel *m_model;
    QListView *m_view;
    QMenu *m_contextMenu;
    QAction *m_removePasswordAction;
    QLineEdit *m_passwordEdit;
    QPushButton *m_passwordButton;
};

#endif // ARCHIVESETTINGSTAB_H
