#ifndef CAPTCHASETTINGSTAB_H
#define CAPTCHASETTINGSTAB_H

#include <QWidget>

class DecaptchaAccountsModel;
class QTreeView;
class QPushButton;
class QLineEdit;
class QCheckBox;
class QMenu;

class CaptchaSettingsTab : public QWidget
{
    Q_OBJECT

public:
    explicit CaptchaSettingsTab(QWidget *parent = 0);
    ~CaptchaSettingsTab();

private slots:
    void showContextMenu(const QPoint &pos);
    void addAccount();
    void removeAccount();
    void editAccount();
    void onAccountEditChanged();
    void onCheckboxClicked(bool checked);

private:
    DecaptchaAccountsModel *m_model;
    QTreeView *m_view;
    QMenu *m_contextMenu;
    QAction *m_editAction;
    QAction *m_removeAction;
    QLineEdit *m_nameEdit;
    QLineEdit *m_passEdit;
    QPushButton *m_doneButton;
    QCheckBox *m_checkbox;
};

#endif // CAPTCHASETTINGSTAB_H
