#ifndef ACCOUNTSETTINGSTAB_H
#define ACCOUNTSETTINGSTAB_H

#include <QWidget>

class ServiceAccountsModel;
class QTreeView;
class QPushButton;
class QLineEdit;
class QMenu;

class AccountSettingsTab : public QWidget
{
    Q_OBJECT

public:
    explicit AccountSettingsTab(QWidget *parent = 0);
    ~AccountSettingsTab();

private slots:
    void showContextMenu(const QPoint &pos);
    void addAccount();
    void removeAccount();
    void editAccount();
    void onAccountEditChanged();

private:
    ServiceAccountsModel *m_model;
    QTreeView *m_view;
    QMenu *m_contextMenu;
    QAction *m_editAction;
    QAction *m_removeAction;
    QLineEdit *m_nameEdit;
    QLineEdit *m_passEdit;
    QPushButton *m_doneButton;
};

#endif // ACCOUNTSETTINGSTAB_H
