#include "../shared/session.h"
#include "../shared/selectionmodels.h"
#include "../shared/categoriesmodel.h"
#include "../shared/serviceaccountsmodel.h"
#include "../shared/decaptchaaccountsmodel.h"
#include "../shared/pluginsettingsmodel.h"
#include "folderlistmodel.h"
#include "qmlutils.h"
#include "maskeditem.h"
#include <QApplication>
#include <QtDeclarative>

Q_DECL_EXPORT int main(int argc, char *argv[])
{
    QScopedPointer<QApplication> app(new QApplication(argc, argv));
    QScopedPointer<QDeclarativeView> view(new QDeclarativeView);
    Session session;
    QmlUtils utils;

    qRegisterMetaType<ScreenOrientation::Orientation>("ScreenOrientation::Orientation");
    qRegisterMetaType<Transfers::Status>("Transfers::Status");
    qRegisterMetaType<Transfers::Priority>("Transfers::Priority");

    qmlRegisterType<QDeclarativeFolderListModel>("com.marxian.models",1,0,"FolderListModel");
    qmlRegisterType<ScreenOrientationModel>("com.marxian.models",1,0,"ScreenOrientationModel");
    qmlRegisterType<QMLSettingsModel>("com.marxian.models",1,0,"SettingsModel");
    qmlRegisterType<QMLAccountsModel>("com.marxian.models",1,0,"AccountsModel");
    qmlRegisterType<ConcurrentTransfersModel>("com.marxian.models",1,0,"ConcurrentTransfersModel");
    qmlRegisterType<TransferPriorityModel>("com.marxian.models",1,0,"TransferPriorityModel");
    qmlRegisterType<CategoriesModel>("com.marxian.models",1,0,"CategoriesModel");
    qmlRegisterType<ServiceAccountsModel>("com.marxian.models",1,0,"ServiceAccountsModel");
    qmlRegisterType<DecaptchaAccountsModel>("com.marxian.models",1,0,"DecaptchaAccountsModel");
    qmlRegisterType<PluginSettingsModel>("com.marxian.models",1,0,"PluginSettingsModel");
    qmlRegisterType<SelectionModel>("com.marxian.models",1,0,"SelectionModel");
    qmlRegisterType<MaskedItem>("com.marxian.items",1,0,"MaskedItem");
    qmlRegisterType<TransferItem>("com.marxian.items",1,0,"TransferItem");
    qmlRegisterUncreatableType<Session>("do_not_import_this_module",1,0,"Session","Cannot create this item in QML");
    qmlRegisterUncreatableType<UrlChecker>("do_not_import_this_module",1,0,"UrlChecker","Cannot create this item in QML");
    qmlRegisterUncreatableType<TransferModel>("do_not_import_this_module",1,0,"TransferModel","Cannot create this item in QML");
    qmlRegisterUncreatableType<PluginManager>("do_not_import_this_module",1,0,"PluginManager","Cannot create this item in QML");
    qmlRegisterUncreatableType<Database>("do_not_import_this_module",1,0,"Database","Cannot create this item in QML");
    qmlRegisterUncreatableType<Settings>("do_not_import_this_module",1,0,"Settings","Cannot create this item in QML");
    qmlRegisterUncreatableType<Transfers>("com.marxian.enums",1,0,"Transfers","Cannot create this item in QML");
    qmlRegisterUncreatableType<ScreenOrientation>("com.marxian.enums",1,0,"ScreenOrientation","Cannot create this item in QML");

    QDeclarativeContext *context = view.data()->rootContext();
    context->setContextProperty("Session", &session);
    context->setContextProperty("TransferModel", session.transferManager());
    context->setContextProperty("UrlChecker", session.urlChecker());
    context->setContextProperty("PluginManager", session.pluginManager());
    context->setContextProperty("Database", session.database());
    context->setContextProperty("Settings", session.settings());
    context->setContextProperty("Utils", &utils);

    QDir dir(app.data()->applicationDirPath());
    dir.cdUp();
    dir.cd("icons");

    context->setContextProperty("iconPath", QDir::toNativeSeparators(QString(dir.path() + "/")));

    view.data()->setSource(QUrl::fromLocalFile(QDir::toNativeSeparators(QString("%1/%2").arg(app.data()->applicationDirPath()).arg("qml/symbian/main.qml"))));
    view.data()->showFullScreen();

    return app.data()->exec();
}
