#ifndef TRANSFERCATEGORYDIALOG_H
#define TRANSFERCATEGORYDIALOG_H

#include <QDialog>

class CategoriesModel;
class QListView;
class QModelIndex;

class TransferCategoryDialog : public QDialog
{
    Q_OBJECT

public:
    explicit TransferCategoryDialog(QWidget *parent = 0);
    ~TransferCategoryDialog();

    QString currentValue() const;
    void setValue(const QString &value);

private slots:
    void onItemClicked(const QModelIndex &index);

signals:
    void valueChanged(const QString &value);
    
private:
    CategoriesModel *m_model;
    QListView *m_listView;
};

#endif // TRANSFERCATEGORYDIALOG_H
