#ifndef ARCHIVEPASSWORDSDIALOG_H
#define ARCHIVEPASSWORDSDIALOG_H

#include <QDialog>

class ArchivePasswordsModel;
class QListView;
class QLineEdit;
class QPushButton;
class QMenu;

class ArchivePasswordsDialog : public QDialog
{
    Q_OBJECT

public:
    explicit ArchivePasswordsDialog(QWidget *parent = 0);
    ~ArchivePasswordsDialog();

private slots:
    void showContextMenu(const QPoint &pos);
    void onPasswordEditTextChanged(const QString &text);
    void addArchivePassword();
    void removeArchivePassword();
    
private:
    ArchivePasswordsModel *m_model;
    QListView *m_view;
    QMenu *m_contextMenu;
    QAction *m_removePasswordAction;
    QLineEdit *m_passwordEdit;
    QPushButton *m_passwordButton;
};

#endif // ARCHIVEPASSWORDSDIALOG_H
