#ifndef DOWNLOADSETTINGSTAB_H
#define DOWNLOADSETTINGSTAB_H

#include <QWidget>

class ArchivePasswordsModel;
class QLineEdit;
class QCheckBox;
class QListView;
class QPushButton;
class QMenu;

class DownloadSettingsTab : public QWidget
{
    Q_OBJECT

public:
    explicit DownloadSettingsTab(QWidget *parent = 0);
    ~DownloadSettingsTab();

public slots:
    void saveSettings();

private:
    void loadSettings();

private slots:
    void showFileDialog();
    void showContextMenu(const QPoint &pos);
    void onPasswordEditTextChanged(const QString &text);
    void addArchivePassword();
    void removeArchivePassword();
    
private:
    QLineEdit *m_pathEdit;
    QCheckBox *m_statusCheckbox;
    QCheckBox *m_clipboardCheckbox;
    QCheckBox *m_extractCheckbox;
    QCheckBox *m_subfoldersCheckbox;
    QCheckBox *m_deleteCheckbox;
    ArchivePasswordsModel *m_model;
    QListView *m_view;
    QMenu *m_contextMenu;
    QAction *m_removePasswordAction;
    QLineEdit *m_passwordEdit;
    QPushButton *m_passwordButton;
};

#endif // DOWNLOADSETTINGSTAB_H
