import QtQuick 1.1
import com.nokia.meego 1.0
import com.marxoft.enums 1.0
import "file:///usr/lib/qt4/imports/com/nokia/meego/UIConstants.js" as UI

ListItem {
    id: root

    property int parentIndex: -1

    height: 140

    Component {
        id: topDecoration

        Item {
            z: 100
            width: 30
            height: 85
            anchors {
                left: parent.left
                leftMargin: 5
                top: parent.top
                topMargin: 55
            }

            Rectangle {
                id: indicator

                width: 30
                height: 30
                color: "transparent"
                border {
                    width: 1
                    color: UI.COLOR_INVERTED_SECONDARY_FOREGROUND
                }

                Label {
                    anchors.fill: parent
                    font.pixelSize: UI.FONT_LARGE
                    color: UI.COLOR_INVERTED_SECONDARY_FOREGROUND
                    horizontalAlignment: Text.AlignHCenter
                    verticalAlignment: Text.AlignVCenter
                    text: expanded ? "-" : "+"
                }

                MouseArea {
                    z: 100
                    anchors.fill: parent
                    onClicked: root.doubleClicked()
                }
            }

            Rectangle {
                width: 1
                anchors {
                    top: indicator.bottom
                    bottom: parent.bottom
                    left: parent.left
                    leftMargin: 15
                }
                color: UI.COLOR_INVERTED_SECONDARY_FOREGROUND
                visible: expanded ? true : false
            }
        }
    }

    Component {
        id: middleDecoration

        Item {
            z: 100
            width: 45
            height: root.height
            anchors {
                left: parent.left
                top: parent.top
            }

            Rectangle {
                width: 1
                anchors {
                    top: parent.top
                    bottom: parent.bottom
                    left: parent.left
                    leftMargin: 20
                }
                color: UI.COLOR_INVERTED_SECONDARY_FOREGROUND
            }

            Rectangle {
                width: 25
                height: 1
                anchors {
                    top: parent.verticalCenter
                    left: parent.left
                    leftMargin: 20
                }
                color: UI.COLOR_INVERTED_SECONDARY_FOREGROUND
            }
        }
    }

    Component {
        id: bottomDecoration

        Item {
            z: 100
            width: 45
            height: root.height
            anchors {
                left: parent.left
                top: parent.top
            }

            Rectangle {
                width: 1
                anchors {
                    top: parent.top
                    bottom: parent.verticalCenter
                    left: parent.left
                    leftMargin: 20
                }
                color: UI.COLOR_INVERTED_SECONDARY_FOREGROUND
            }

            Rectangle {
                width: 25
                height: 1
                anchors {
                    top: parent.verticalCenter
                    left: parent.left
                    leftMargin: 20
                }
                color: UI.COLOR_INVERTED_SECONDARY_FOREGROUND
            }
        }
    }

    Loader {
        id: loader

        z: 100
        sourceComponent: transferCount === 0 ? undefined : parentIndex === -1 ? topDecoration : index === (transferCount - 1) ? bottomDecoration : middleDecoration
    }

    Item {
        id: content

        anchors {
            fill: parent
            leftMargin: transferCount == 0 ? 5 : parentIndex == -1 ? 40 : 50
            rightMargin: 5
            topMargin: 5
            bottomMargin: 5
        }

        ServiceIcon {
            id: serviceIcon

            width: 48
            height: 48
            anchors {
                top: parent.top
                left: parent.left
            }

            iconSource: "file://" + TransferModel.data(index, parentIndex, "icon")
            smooth: true
        }

        Label {
            id: titleLabel

            anchors {
                top: parent.top
                left: serviceIcon.right
                right: parent.right
            }
            font.bold: true
            elide: Text.ElideRight
            text: TransferModel.data(index, parentIndex, "name")
        }

        ProgressBar {
            id: progressBar

            width: 150
            anchors {
                right: parent.right
                verticalCenter: parent.verticalCenter
            }

            value: progress
            minimumValue: 0
            maximumValue: 100
            indeterminate: TransferModel.data(index, parentIndex, "status") === Transfers.Connecting
        }

        Label {
            id: statusLabel

            anchors {
                left: parent.left
                right: progressLabel.visible ? progressLabel.left : parent.right
                rightMargin: progressLabel.visible ? 5 : 0
                bottom: parent.bottom
            }
            font.pixelSize: UI.FONT_SMALL
            font.family: UI.FONT_FAMILY_LIGHT
            elide: Text.ElideRight
            text: statusString
            color: TransferModel.data(index, parentIndex, "status") === Transfers.Failed ? "red" : UI.COLOR_INVERTED_FOREGROUND
        }

        Label {
            id: progressLabel

            anchors {
                right: parent.right
                bottom: parent.bottom
            }
            font.pixelSize: UI.FONT_SMALL
            font.family: UI.FONT_FAMILY_LIGHT
            visible: TransferModel.data(index, parentIndex, "status") !== Transfers.Failed
            horizontalAlignment: Text.AlignRight
            text: Utils.fileSizeFromBytes(TransferModel.data(index, parentIndex, "position")) + " " + qsTr("of") + " " + (TransferModel.data(index, parentIndex, "size") > 0 ? Utils.fileSizeFromBytes(TransferModel.data(index, parentIndex, "size")) + " (" + TransferModel.data(index, parentIndex, "progress") + "%)" : qsTr("Unknown"))
        }
    }

    onParentIndexChanged: console.log(titleLabel.text + " has parentIndex " + parentIndex)
}
