#include "networkaccessmanager.h"
#include "cookiejar.h"

NetworkAccessManager* NetworkAccessManager::m_instance = 0;
CookieJar* NetworkAccessManager::m_cookieJar = 0;

NetworkAccessManager::NetworkAccessManager() :
    QNetworkAccessManager()
{
    if (!m_instance) {
        m_instance = this;
    }

    if (!m_cookieJar) {
        m_cookieJar = new CookieJar(m_instance);
    }

    this->setCookieJar(m_cookieJar);
}

NetworkAccessManager::~NetworkAccessManager() {}

NetworkAccessManager* NetworkAccessManager::instance() {
    return !m_instance ? new NetworkAccessManager : m_instance;
}

NetworkAccessManager* NetworkAccessManager::create() {
    return new NetworkAccessManager;
}
