#ifndef PLUGINSETTINGSLINEEDIT_H
#define PLUGINSETTINGSLINEEDIT_H

#include <QLineEdit>
#include <QVariant>

class PluginSettingsLineEdit : public QLineEdit
{
    Q_OBJECT

public:
    explicit PluginSettingsLineEdit(QWidget *parent = 0);
    ~PluginSettingsLineEdit();

    inline QString key() const { return m_key; }
    inline QVariant defaultValue() const { return m_default; }

public slots:
    void setKey(const QString &key);
    void setDefaultValue(const QVariant &value);
    void load();

private slots:
    void onTextEdited(const QString &text);

private:
    QString m_key;
    QVariant m_default;
};

#endif // PLUGINSETTINGSLINEEDIT_H
