#ifndef PLUGINSETTINGSCHECKBOX_H
#define PLUGINSETTINGSCHECKBOX_H

#include <QCheckBox>
#include <QVariant>

class PluginSettingsCheckbox : public QCheckBox
{
    Q_OBJECT

public:
    explicit PluginSettingsCheckbox(QWidget *parent = 0);
    ~PluginSettingsCheckbox();

    inline QString key() const { return m_key; }
    inline QVariant defaultValue() const { return m_default; }

public slots:
    void setKey(const QString &key);
    void setDefaultValue(const QVariant &value);
    void load();

private slots:
    void onClicked(bool checked);

private:
    QString m_key;
    QVariant m_default;
};

#endif // PLUGINSETTINGSCHECKBOX_H
