#ifndef SCENE_H
#define SCENE_H
#include <QGraphicsScene>
#include <QTimer>
#include <QSettings>
#include "level.h"

QT_BEGIN_NAMESPACE
class Ball;
class QGraphicsTextItem;
QT_END_NAMESPACE

class Scene :public QGraphicsScene
{
    enum Mode {
      PLAY,
      PAUSE,
      GAME_OVER
    };
    Q_OBJECT
public:
    Scene(QObject *parent = 0);
public slots:
    void updateWorld();
    void initWorld();
    void nextWorld();
    void initLevel();
    void initScore();
    void updateScore();
    void updateBG();
    void restartWorld();

protected:
    void mousePressEvent(QGraphicsSceneMouseEvent *event);
    void mouseMoveEvent(QGraphicsSceneMouseEvent *event);
    void mouseReleaseEvent(QGraphicsSceneMouseEvent *event);


private:
    Mode mode;
    QTimer updateTime;
    QTimer goalTimer;
    QList<Level> levels;
    int level;
    int goalAlfaBG;
    int life;
    bool increaseExplosionBG;
    int numBallsExplosion;
    QGraphicsTextItem *score;
    QGraphicsLineItem *line;
    Ball *myBall;
    QPointF initMousePos;
    int gameScore;
    int bestScore;
    QSettings settingScore;
};

#endif // SCENE_H
