#include "scene.h"
#include "ball.h"
#include <QGraphicsSceneMouseEvent>
#include <QMessageBox>
#include <QDebug>

Scene::Scene(QObject *parent)
    : QGraphicsScene(parent),
      mode(PLAY),
      line(0),
      myBall(0),
      level(0),
      numBallsExplosion(0),
      goalAlfaBG(255),
      increaseExplosionBG(true),
      life(5),
      gameScore(0),
      bestScore(0),
      settingScore("EmmQt","QBoomBoom")
{

    bestScore = settingScore.value("score").toInt();
    setBackgroundBrush(QBrush(QColor(0,0,0,goalAlfaBG)));

    initLevel();
    initScore();
    initWorld();
    updateTime.setInterval(25);
    connect(&updateTime,SIGNAL(timeout()),this,SLOT(updateWorld()));
    updateTime.start();

    goalTimer.setInterval(30);
    connect(&goalTimer,SIGNAL(timeout()),this,SLOT(updateBG()));



}

void Scene::updateWorld() {
    bool noExplosion = true;
    foreach (QGraphicsItem *item , items()) {
      if (Ball::Type == item->type()) {
        Ball *ball =qgraphicsitem_cast<Ball *>(item);

        if (ball->isExplosion()) {
            noExplosion = false;
            foreach (QGraphicsItem *itemCollide , collidingItems(ball,Qt::IntersectsItemBoundingRect)) {
                if (Ball::Type == itemCollide->type()) {
                  Ball *ballCollide =qgraphicsitem_cast<Ball *>(itemCollide);
                  if (!ballCollide->isExplosion()) {
                      ballCollide->collisionDetected();
                      ++numBallsExplosion;
                      gameScore +=10;
                      if (levels.at(level).getGoal()  < numBallsExplosion)
                        gameScore += 10 * (numBallsExplosion - levels.at(level).getGoal());
                      updateScore();
                      break;
                  }
                }
            }
        }
        if (!ball->update()) {
          removeItem(ball);
        }
      }
    }
     if ( levels.at(level).getGoal()  <= numBallsExplosion) {
      if (!goalTimer.isActive())
        goalTimer.start();
     }

    if (myBall && noExplosion) {
        if ( levels.at(level).getGoal()  <= numBallsExplosion) {
          nextWorld();
        } else {
          updateTime.stop();
          if (life == 0) {
            mode = GAME_OVER;
            QMessageBox message;
            message.addButton(QMessageBox::Close);
            message.addButton(QMessageBox::Ok);
            message.setText("Try Again?");
            if (QMessageBox::Close == message.exec()) {
              exit(0);
            } else {
              restartWorld();
            }
          } else {
            restartWorld();
          }
        }
    }
}

void Scene::initWorld() {
    for (int i = 0; i < levels.at(level).getBallNumber() ; i++) {
        Ball *testBall0 = new Ball();
        addItem(testBall0);
        testBall0->setVisible(true);
    }
    updateScore();
}

void Scene::nextWorld() {
  ++level;
  if (levels.size() == level) { // Make all Level
    life = 0;
    restartWorld();
  } else {
    numBallsExplosion = 0;
    goalAlfaBG = 255;
    increaseExplosionBG = true;
    goalTimer.stop();
    setBackgroundBrush(QBrush(QColor(0,0,0,goalAlfaBG)));
    clear();
    initScore();
    updateScore();
    mode = PLAY;
    initWorld();
    myBall = 0;
  }
}

void Scene::initLevel() {
  // Level (NumLevel,Goal,NumBall)
  Level level0(1,1,10);
  levels.append(level0);
  Level level1(2,2,10);
  levels.append(level1);
  Level level2(3,3,10);
  levels.append(level2);
  Level level3(4,4,10);
  levels.append(level3);
  Level level4(5,5,10);
  levels.append(level4);
  Level level5(6,6,12);
  levels.append(level5);
  Level level6(7,7,15);
  levels.append(level6);
  Level level7(8,9,17);
  levels.append(level7);
  Level level8(9,10,19);
  levels.append(level8);
  Level level9(10,13,25);
  levels.append(level9);
  Level level10(11,16,27);
  levels.append(level10);
  Level level11(12,18,27);
  levels.append(level11);
  Level level12(13,20,27);
  levels.append(level12);
  Level level13(14,22,27);
  levels.append(level13);
  Level level14(15,25,30);
  levels.append(level14);
  Level level15(16,26,30);
  levels.append(level15);
  Level level16(17,30,30);
  levels.append(level16);
}
void Scene::initScore() {
  QGraphicsRectItem *bgBound = new QGraphicsRectItem(QRect(0,0,700,50));
  bgBound->setPos(0,320);
  bgBound->setBrush(QBrush(QColor(255,255,255,180)));
  addItem(bgBound);
  bgBound->setZValue(1);

  score = new QGraphicsTextItem();
  addItem(score);
  score->setVisible(true);
  score->setPos(20,332);
  score->setFont(QFont("Helvetica [Cronyx]", 15, QFont::Bold));
  score->setDefaultTextColor(QColor("#C35617"));
  score->setZValue(2);
}

void Scene::updateScore() {
    score->setPlainText(QString("Life:%1 Level:%2  Goal:%3/%4 Score:%5 BestScore:%6").arg(life).arg(level).arg(numBallsExplosion).arg(levels.at(level).getGoal()).arg(gameScore).arg(bestScore));
}

void Scene::updateBG() {
  if (increaseExplosionBG) {
    if (goalAlfaBG > 60) {
      goalAlfaBG-= 3;
      setBackgroundBrush(QBrush(QColor(0,0,0,goalAlfaBG)));
    } else {
      increaseExplosionBG = false;
    }
  } else {
    if (goalAlfaBG < 255) {
      goalAlfaBG+= 3;
      setBackgroundBrush(QBrush(QColor(0,0,0,goalAlfaBG)));
    } else {
      goalTimer.stop();
    }
  }
}

void Scene::restartWorld() {
  clear();
  goalAlfaBG = 255;
  increaseExplosionBG = true;
  goalTimer.stop();
  setBackgroundBrush(QBrush(QColor(0,0,0,goalAlfaBG)));
  numBallsExplosion = 0;
  initScore();
  mode = PLAY;
  if (life == 0) {
      if (gameScore > bestScore){
        bestScore = gameScore;
        settingScore.setValue("score",bestScore);
      }
    gameScore = 0;
    level = 0;
    life = 5;
  } else {
    --life;
  }
  initWorld();
  myBall = 0;
  updateTime.start();
}

void Scene::mousePressEvent(QGraphicsSceneMouseEvent *event) {
  if (!myBall) {
    line = new QGraphicsLineItem(QLine(0,0,1,1));
    line->setPos(event->scenePos());
    addItem(line);
    initMousePos = event->scenePos();
  }
}


void Scene::mouseMoveEvent(QGraphicsSceneMouseEvent *event) {
    if (!myBall && line) {
      line->setLine(QLine(line->line().p1().toPoint(), event->scenePos().toPoint() - initMousePos.toPoint()));
    }
}

void Scene::mouseReleaseEvent(QGraphicsSceneMouseEvent *event) {
    if (!myBall) {

        myBall = new Ball(line->line());
        removeItem(line);
        addItem(myBall);
        myBall->setPos(initMousePos);
        myBall->collisionDetected();
    }
}
