#ifndef BALL_H
#define BALL_H
#include <QGraphicsRectItem>
#include <QColor>

class Ball : public QGraphicsEllipseItem
{
public:

    enum Mode {
        MODE_NORMAL,
        MODE_EXPLOSION
    };
    enum AnimationState {
        STATE_EXPAND,
        STATE_WAITING,
        STATE_DECREASE
    };

    enum { Type = QGraphicsItem::UserType + 1 };
    int type() const { return Type;}

    Ball(const QLineF &directionLine = QLine(), QGraphicsItem *parent = 0);
    bool update();
    void collisionDetected();
    bool isExplosion() {
        if (MODE_EXPLOSION == mode)
            return true;
        else
            return false;
    }

private:
    void initDirection();
    void initPosition();
    void borderControl();

    QPointF direction;
    Mode mode;
    AnimationState animationState;
    int animationWaiting;
    qreal ballSize;

    QColor color;

    QMap<int,int> mapAnimationState;
    static const int LEFT;
    static const int RIGHT;
    static const int TOP;
    static const int BOTTOM;
    static const int MAX_SIZE_EXPLOTION;
    static const int TIME_MAX_EXPLOTION;

};

#endif // BALL_H
