#include "multiplication.h"
using namespace QalcuLib;
using namespace std;

Multiplication::Multiplication(const std::vector<OperandPtr> &operands,
                               const std::vector<bool> &isMultiplicative)
    :m_operands(operands),m_isMultiplicative(isMultiplicative)
{
    if (operands.size() != isMultiplicative.size())
        throw exception();// "Inconsistent vector size" );
}

double Multiplication::compute()
{
    double res = 1.0;

    vector<OperandPtr>::iterator opIt = m_operands.begin();
    vector<bool>::const_iterator multIt = m_isMultiplicative.begin();
    double buffer;

    for (;opIt != m_operands.end(); opIt++, multIt++)
    {
        buffer = (*opIt)->compute();

        if ((*multIt)) // f***ing vector specialization
        {
            res *= buffer;
        }
        else
        {
            if (buffer == 0.0)
                throw exception();// "Division by zero" );

            res /= buffer;
        }
    }

    return res;
}
