#include "function.h"
#include "math.h"

using namespace QalcuLib;
using namespace std;

Function::Function(const OperandPtr &value, const QString &function )
    :m_value(value), m_functionString(function)
{
    QString lowerFunc = function.toLower();

    if (lowerFunc == "sqrt")
        m_function = eSqrt;
    else if (lowerFunc == "ln")
        m_function = eLn;
    else if (lowerFunc == "log")
        m_function = eLog;
    else if (lowerFunc == "exp" || lowerFunc == "e")
        m_function = eExp;
    else if (lowerFunc == "cos")
        m_function = eCos;
    else if (lowerFunc == "sin")
        m_function = eSin;
    else if (lowerFunc == "tan")
        m_function = eTan;
    else
    {
        QString errorMessage = "Function " + function + " not recognized";
        throw exception();//errorMessage.toAscii());
    }

}

double Function::compute()
{
    double value = m_value->compute();

    switch (m_function)
    {
    case eSqrt:
        checkPositive(value);
        return sqrt(value);
    case eLn:
        checkDefinitePositive(value);
        return log(value);
    case eLog:
        checkDefinitePositive(value);
        return log(value)/log(10.0);
    case eExp:
        return exp(value);
    case eCos:
        return cos(value);
    case eSin:
        return sin(value);
    case eTan:
        if (cos(value) == 0.0)
            throw exception();//"Tan is infinite");
        return tan(value);

  default:
        QString errorMessage = "Function " + m_functionString + " was not found";
        throw exception();//errorMessage.toAscii());
    }
}

void Function::checkPositive(double value) const
{
    if (value < 0.0)
    {
        QString errorMessage = m_functionString + " needs a positive argument";
        throw exception();//errorMessage.toAscii());
    }
}

void Function::checkDefinitePositive(double value) const
{
    if (value <= 0.0)
    {
        QString errorMessage = m_functionString + " needs a striclty positive argument";
        throw exception();//errorMessage.toAscii());
    }
}
