#include "addition.h"
using namespace QalcuLib;
using namespace std;

Addition::Addition(const std::vector<OperandPtr> &operands, const std::vector<bool> &isAdditive)
    :m_operands(operands),m_isAdditive(isAdditive)
{
    if (operands.size() != isAdditive.size())
        throw exception();// "Inconsistent vector size" );
}

double Addition::compute()
{
    double res = 0.0;

    vector<OperandPtr>::iterator opIt = m_operands.begin();
    vector<bool>::const_iterator addIt = m_isAdditive.begin();
    double buffer;

    for (;opIt != m_operands.end(); opIt++, addIt++)
    {
        buffer = (*opIt)->compute();

        if ((*addIt)) // f***ing vector specialization
        {
            res += buffer;
        }
        else
        {
            res -= buffer;
        }
    }

    return res;
}
