#ifndef OPERAND_H
#define OPERAND_H

#include "complex.h"
#include <QSharedPointer>
#include <QStringList>
#include <map>

namespace QalcuLib
{
    class Operand
    {
    public:
        Operand();

        virtual double compute() = 0;

        virtual Complex computeComplex();
    };

    typedef QSharedPointer<Operand> OperandPtr;

    class OperandDictionary
    {
    public:
        OperandDictionary();

        OperandPtr getOperand(const QString &key);

        void addOperand(const QString &key, const OperandPtr &value);

        QStringList getMemoryKeys() const;

        QStringList getConstantKeys() const;

    private:
        std::map<QString,OperandPtr> m_ConstantDictionary;
        std::map<QString,OperandPtr> m_MemoryDictionary;
    };
    typedef QSharedPointer<OperandDictionary> OperandDictionaryPtr;
}

#endif // OPERAND_H
