#ifndef OPERATORS_FACTORY_H
#define OPERATORS_FACTORY_H

#include <QString>
#include <QSharedPointer>
#include <list>
#include "../operand.h"

namespace QalcuLib
{
    class strPower
    {
    public:
        strPower( const QString &expression );

        // if !isEmpty, call factory of first and second, new power of them
        // else, call factory.
        // no operator left, so parenthesis factory
        OperandPtr makeOperand(OperandDictionaryPtr dic);

    private:
        QString m_first;
        QString m_second;
        bool    m_isEmpty;
    };
    typedef QSharedPointer<strPower> strPowerPtr;

    class strMultiplication
    {
    public:
        //
        strMultiplication( const QString &expression);

        OperandPtr makeOperand(OperandDictionaryPtr dic);

    private:
        std::list<strPowerPtr>     m_members;
        std::list<bool>         m_isMult;
        bool                    m_isEmpty; // still at list one power object
    };
    typedef QSharedPointer<strMultiplication> strMultiplicationPtr;

    class strAddition
    {
    public:
        //
        strAddition( const QString &expression);

        OperandPtr makeOperand(OperandDictionaryPtr dic);

    private:
        std::list<strMultiplicationPtr>     m_members;
        std::list<bool>         m_isAdd;
        bool                    m_isEmpty; // still at list one mult object
    };
    typedef QSharedPointer<strAddition> strAdditionPtr;

}

#endif // OPERATORS_FACTORY_H
