/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.10-snapshot-20100108 on Wed Jan 27 00:38:42 2010
 *
 * Copyright (c) 2010 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt.
 * 
 * This file may be used under the terms of the GNU General Public
 * License versions 2.0 or 3.0 as published by the Free Software
 * Foundation and appearing in the files LICENSE.GPL2 and LICENSE.GPL3
 * included in the packaging of this file.  Alternatively you may (at
 * your option) use any later version of the GNU General Public
 * License if such license has been publicly approved by Riverbank
 * Computing Limited (or its successors, if any) and the KDE Free Qt
 * Foundation. In addition, as a special exception, Riverbank gives you
 * certain additional rights. These rights are described in the Riverbank
 * GPL Exception version 1.1, which can be found in the file
 * GPL_EXCEPTION.txt in this package.
 * 
 * Please review the following information to ensure GNU General
 * Public Licensing requirements will be met:
 * http://trolltech.com/products/qt/licenses/licensing/opensource/. If
 * you are unsure which license is appropriate for your use, please
 * review the following information:
 * http://trolltech.com/products/qt/licenses/licensing/licensingoverview
 * or contact the sales department at sales@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 43 "/home/maemo/python-qt4-4.7/sip/QtCore/qbytearray.sip"
#include <qbytearray.h>
#line 39 "sipQtCoreQByteArray.cpp"

#line 41 "/home/maemo/python-qt4-4.7/sip/QtCore/qstring.sip"
#include <qstring.h>
#line 43 "sipQtCoreQByteArray.cpp"
#line 38 "/home/maemo/python-qt4-4.7/sip/QtCore/qlist.sip"
#include <qlist.h>
#line 46 "sipQtCoreQByteArray.cpp"
#line 47 "/home/maemo/python-qt4-4.7/sip/QtCore/qbytearray.sip"
// This is needed by __hash__().
#include <qhash.h>


// Convenience function for converting a QByteArray to a Python str object.
static PyObject *QByteArrayToPyStr(QByteArray *ba)
{
    char *data = ba->data();

    if (data)
        // QByteArrays may have embedded '\0's so set the size explicitly.    
        return SIPBytes_FromStringAndSize(data, ba->size());

    return SIPBytes_FromString("");
}
#line 63 "sipQtCoreQByteArray.cpp"


PyDoc_STRVAR(doc_QByteArray_resize, "QByteArray.resize(int)");

extern "C" {static PyObject *meth_QByteArray_resize(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_resize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QByteArray, &sipCpp, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->resize(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_resize, doc_QByteArray_resize);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_fill, "QByteArray.fill(str, int size=-1) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_fill(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_fill(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        char a0;
        int a1 = -1;
        QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            NULL,
            sipName_size,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bc|i", &sipSelf, sipType_QByteArray, &sipCpp, &a0, &a1))
        {
            QByteArray *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->fill(a0,a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromType(sipRes,sipType_QByteArray,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_fill, doc_QByteArray_fill);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_clear, "QByteArray.clear()");

extern "C" {static PyObject *meth_QByteArray_clear(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_clear(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->clear();
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_clear, doc_QByteArray_clear);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_indexOf, "QByteArray.indexOf(QByteArray, int from=0) -> int\n"
    "QByteArray.indexOf(QString, int from=0) -> int");

extern "C" {static PyObject *meth_QByteArray_indexOf(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_indexOf(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const QByteArray * a0;
        int a0State = 0;
        int a1 = 0;
        QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            NULL,
            sipName_from,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|i", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QByteArray, &a0, &a0State, &a1))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->indexOf(*a0,a1);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QByteArray *>(a0),sipType_QByteArray,a0State);

            return SIPLong_FromLong(sipRes);
        }
    }

    {
        const QString * a0;
        int a0State = 0;
        int a1 = 0;
        QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            NULL,
            sipName_from,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|i", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QString,&a0, &a0State, &a1))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->indexOf(*a0,a1);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QString *>(a0),sipType_QString,a0State);

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_indexOf, doc_QByteArray_indexOf);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_lastIndexOf, "QByteArray.lastIndexOf(QByteArray, int from=-1) -> int\n"
    "QByteArray.lastIndexOf(QString, int from=-1) -> int");

extern "C" {static PyObject *meth_QByteArray_lastIndexOf(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_lastIndexOf(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const QByteArray * a0;
        int a0State = 0;
        int a1 = -1;
        QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            NULL,
            sipName_from,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|i", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QByteArray, &a0, &a0State, &a1))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->lastIndexOf(*a0,a1);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QByteArray *>(a0),sipType_QByteArray,a0State);

            return SIPLong_FromLong(sipRes);
        }
    }

    {
        const QString * a0;
        int a0State = 0;
        int a1 = -1;
        QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            NULL,
            sipName_from,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|i", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QString,&a0, &a0State, &a1))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->lastIndexOf(*a0,a1);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QString *>(a0),sipType_QString,a0State);

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_lastIndexOf, doc_QByteArray_lastIndexOf);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_count, "QByteArray.count(QByteArray) -> int\n"
    "QByteArray.count() -> int");

extern "C" {static PyObject *meth_QByteArray_count(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_count(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const QByteArray * a0;
        int a0State = 0;
        QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QByteArray, &a0, &a0State))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->count(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QByteArray *>(a0),sipType_QByteArray,a0State);

            return SIPLong_FromLong(sipRes);
        }
    }

    {
        QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->count();
            Py_END_ALLOW_THREADS

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_count, doc_QByteArray_count);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_left, "QByteArray.left(int) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_left(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_left(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QByteArray, &sipCpp, &a0))
        {
            QByteArray *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QByteArray(sipCpp->left(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QByteArray,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_left, doc_QByteArray_left);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_right, "QByteArray.right(int) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_right(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_right(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QByteArray, &sipCpp, &a0))
        {
            QByteArray *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QByteArray(sipCpp->right(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QByteArray,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_right, doc_QByteArray_right);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_mid, "QByteArray.mid(int, int length=-1) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_mid(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_mid(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        int a1 = -1;
        QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            NULL,
            sipName_length,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi|i", &sipSelf, sipType_QByteArray, &sipCpp, &a0, &a1))
        {
            QByteArray *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QByteArray(sipCpp->mid(a0,a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QByteArray,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_mid, doc_QByteArray_mid);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_startsWith, "QByteArray.startsWith(QByteArray) -> bool");

extern "C" {static PyObject *meth_QByteArray_startsWith(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_startsWith(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const QByteArray * a0;
        int a0State = 0;
        QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QByteArray, &a0, &a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->startsWith(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QByteArray *>(a0),sipType_QByteArray,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_startsWith, doc_QByteArray_startsWith);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_endsWith, "QByteArray.endsWith(QByteArray) -> bool");

extern "C" {static PyObject *meth_QByteArray_endsWith(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_endsWith(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const QByteArray * a0;
        int a0State = 0;
        QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QByteArray, &a0, &a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->endsWith(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QByteArray *>(a0),sipType_QByteArray,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_endsWith, doc_QByteArray_endsWith);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_truncate, "QByteArray.truncate(int)");

extern "C" {static PyObject *meth_QByteArray_truncate(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_truncate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QByteArray, &sipCpp, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->truncate(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_truncate, doc_QByteArray_truncate);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_chop, "QByteArray.chop(int)");

extern "C" {static PyObject *meth_QByteArray_chop(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_chop(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QByteArray, &sipCpp, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->chop(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_chop, doc_QByteArray_chop);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_toLower, "QByteArray.toLower() -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_toLower(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toLower(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            QByteArray *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QByteArray(sipCpp->toLower());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QByteArray,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toLower, doc_QByteArray_toLower);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_toUpper, "QByteArray.toUpper() -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_toUpper(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toUpper(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            QByteArray *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QByteArray(sipCpp->toUpper());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QByteArray,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toUpper, doc_QByteArray_toUpper);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_trimmed, "QByteArray.trimmed() -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_trimmed(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_trimmed(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            QByteArray *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QByteArray(sipCpp->trimmed());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QByteArray,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_trimmed, doc_QByteArray_trimmed);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_simplified, "QByteArray.simplified() -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_simplified(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_simplified(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            QByteArray *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QByteArray(sipCpp->simplified());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QByteArray,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_simplified, doc_QByteArray_simplified);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_leftJustified, "QByteArray.leftJustified(int, str fill=' ', bool truncate=False) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_leftJustified(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_leftJustified(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        char a1 = ' ';
        bool a2 = 0;
        QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            NULL,
            sipName_fill,
            sipName_truncate,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi|cb", &sipSelf, sipType_QByteArray, &sipCpp, &a0, &a1, &a2))
        {
            QByteArray *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QByteArray(sipCpp->leftJustified(a0,a1,a2));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QByteArray,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_leftJustified, doc_QByteArray_leftJustified);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_rightJustified, "QByteArray.rightJustified(int, str fill=' ', bool truncate=False) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_rightJustified(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_rightJustified(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        char a1 = ' ';
        bool a2 = 0;
        QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            NULL,
            sipName_fill,
            sipName_truncate,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi|cb", &sipSelf, sipType_QByteArray, &sipCpp, &a0, &a1, &a2))
        {
            QByteArray *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QByteArray(sipCpp->rightJustified(a0,a1,a2));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QByteArray,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_rightJustified, doc_QByteArray_rightJustified);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_prepend, "QByteArray.prepend(QByteArray) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_prepend(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_prepend(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const QByteArray * a0;
        int a0State = 0;
        QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QByteArray, &a0, &a0State))
        {
            QByteArray *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->prepend(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QByteArray *>(a0),sipType_QByteArray,a0State);

            return sipConvertFromType(sipRes,sipType_QByteArray,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_prepend, doc_QByteArray_prepend);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_append, "QByteArray.append(QByteArray) -> QByteArray\n"
    "QByteArray.append(QString) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_append(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_append(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const QByteArray * a0;
        int a0State = 0;
        QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QByteArray, &a0, &a0State))
        {
            QByteArray *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->append(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QByteArray *>(a0),sipType_QByteArray,a0State);

            return sipConvertFromType(sipRes,sipType_QByteArray,NULL);
        }
    }

    {
        const QString * a0;
        int a0State = 0;
        QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QString,&a0, &a0State))
        {
            QByteArray *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->append(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QString *>(a0),sipType_QString,a0State);

            return sipConvertFromType(sipRes,sipType_QByteArray,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_append, doc_QByteArray_append);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_insert, "QByteArray.insert(int, QByteArray) -> QByteArray\n"
    "QByteArray.insert(int, QString) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_insert(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_insert(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        const QByteArray * a1;
        int a1State = 0;
        QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BiJ1", &sipSelf, sipType_QByteArray, &sipCpp, &a0, sipType_QByteArray, &a1, &a1State))
        {
            QByteArray *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->insert(a0,*a1);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QByteArray *>(a1),sipType_QByteArray,a1State);

            return sipConvertFromType(sipRes,sipType_QByteArray,NULL);
        }
    }

    {
        int a0;
        const QString * a1;
        int a1State = 0;
        QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BiJ1", &sipSelf, sipType_QByteArray, &sipCpp, &a0, sipType_QString,&a1, &a1State))
        {
            QByteArray *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->insert(a0,*a1);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QString *>(a1),sipType_QString,a1State);

            return sipConvertFromType(sipRes,sipType_QByteArray,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_insert, doc_QByteArray_insert);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_remove, "QByteArray.remove(int, int) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_remove(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_remove(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        int a1;
        QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bii", &sipSelf, sipType_QByteArray, &sipCpp, &a0, &a1))
        {
            QByteArray *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->remove(a0,a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromType(sipRes,sipType_QByteArray,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_remove, doc_QByteArray_remove);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_replace, "QByteArray.replace(int, int, QByteArray) -> QByteArray\n"
    "QByteArray.replace(QByteArray, QByteArray) -> QByteArray\n"
    "QByteArray.replace(QString, QByteArray) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_replace(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_replace(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        int a1;
        const QByteArray * a2;
        int a2State = 0;
        QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BiiJ1", &sipSelf, sipType_QByteArray, &sipCpp, &a0, &a1, sipType_QByteArray, &a2, &a2State))
        {
            QByteArray *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->replace(a0,a1,*a2);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QByteArray *>(a2),sipType_QByteArray,a2State);

            return sipConvertFromType(sipRes,sipType_QByteArray,NULL);
        }
    }

    {
        const QByteArray * a0;
        int a0State = 0;
        const QByteArray * a1;
        int a1State = 0;
        QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1J1", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QByteArray, &a0, &a0State, sipType_QByteArray, &a1, &a1State))
        {
            QByteArray *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->replace(*a0,*a1);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QByteArray *>(a0),sipType_QByteArray,a0State);
            sipReleaseType(const_cast<QByteArray *>(a1),sipType_QByteArray,a1State);

            return sipConvertFromType(sipRes,sipType_QByteArray,NULL);
        }
    }

    {
        const QString * a0;
        int a0State = 0;
        const QByteArray * a1;
        int a1State = 0;
        QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1J1", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QString,&a0, &a0State, sipType_QByteArray, &a1, &a1State))
        {
            QByteArray *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->replace(*a0,*a1);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QString *>(a0),sipType_QString,a0State);
            sipReleaseType(const_cast<QByteArray *>(a1),sipType_QByteArray,a1State);

            return sipConvertFromType(sipRes,sipType_QByteArray,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_replace, doc_QByteArray_replace);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_split, "QByteArray.split(str) -> list-of-QByteArray");

extern "C" {static PyObject *meth_QByteArray_split(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_split(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        char a0;
        QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bc", &sipSelf, sipType_QByteArray, &sipCpp, &a0))
        {
            QList<QByteArray> *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QList<QByteArray>(sipCpp->split(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QList_0100QByteArray,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_split, doc_QByteArray_split);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_toShort, "QByteArray.toShort(int base=10) -> (int, bool)");

extern "C" {static PyObject *meth_QByteArray_toShort(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toShort(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool a0;
        int a1 = 10;
        QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            sipName_ok,
            sipName_base,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|i", &sipSelf, sipType_QByteArray, &sipCpp, &a1))
        {
            short sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->toShort(&a0,a1);
            Py_END_ALLOW_THREADS

            return sipBuildResult(0,"(hb)",sipRes,a0);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toShort, doc_QByteArray_toShort);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_toUShort, "QByteArray.toUShort(int base=10) -> (int, bool)");

extern "C" {static PyObject *meth_QByteArray_toUShort(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toUShort(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool a0;
        int a1 = 10;
        QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            sipName_ok,
            sipName_base,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|i", &sipSelf, sipType_QByteArray, &sipCpp, &a1))
        {
            ushort sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->toUShort(&a0,a1);
            Py_END_ALLOW_THREADS

            return sipBuildResult(0,"(tb)",sipRes,a0);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toUShort, doc_QByteArray_toUShort);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_toInt, "QByteArray.toInt(int base=10) -> (int, bool)");

extern "C" {static PyObject *meth_QByteArray_toInt(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toInt(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool a0;
        int a1 = 10;
        QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            sipName_ok,
            sipName_base,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|i", &sipSelf, sipType_QByteArray, &sipCpp, &a1))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->toInt(&a0,a1);
            Py_END_ALLOW_THREADS

            return sipBuildResult(0,"(ib)",sipRes,a0);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toInt, doc_QByteArray_toInt);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_toUInt, "QByteArray.toUInt(int base=10) -> (int, bool)");

extern "C" {static PyObject *meth_QByteArray_toUInt(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toUInt(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool a0;
        int a1 = 10;
        QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            sipName_ok,
            sipName_base,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|i", &sipSelf, sipType_QByteArray, &sipCpp, &a1))
        {
            uint sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->toUInt(&a0,a1);
            Py_END_ALLOW_THREADS

            return sipBuildResult(0,"(ub)",sipRes,a0);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toUInt, doc_QByteArray_toUInt);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_toLong, "QByteArray.toLong(int base=10) -> (int, bool)");

extern "C" {static PyObject *meth_QByteArray_toLong(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toLong(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool a0;
        int a1 = 10;
        QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            sipName_ok,
            sipName_base,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|i", &sipSelf, sipType_QByteArray, &sipCpp, &a1))
        {
            long sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->toLong(&a0,a1);
            Py_END_ALLOW_THREADS

            return sipBuildResult(0,"(lb)",sipRes,a0);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toLong, doc_QByteArray_toLong);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_toULong, "QByteArray.toULong(int base=10) -> (int, bool)");

extern "C" {static PyObject *meth_QByteArray_toULong(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toULong(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool a0;
        int a1 = 10;
        QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            sipName_ok,
            sipName_base,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|i", &sipSelf, sipType_QByteArray, &sipCpp, &a1))
        {
            ulong sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->toULong(&a0,a1);
            Py_END_ALLOW_THREADS

            return sipBuildResult(0,"(mb)",sipRes,a0);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toULong, doc_QByteArray_toULong);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_toLongLong, "QByteArray.toLongLong(int base=10) -> (int, bool)");

extern "C" {static PyObject *meth_QByteArray_toLongLong(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toLongLong(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool a0;
        int a1 = 10;
        QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            sipName_ok,
            sipName_base,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|i", &sipSelf, sipType_QByteArray, &sipCpp, &a1))
        {
            qlonglong sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->toLongLong(&a0,a1);
            Py_END_ALLOW_THREADS

            return sipBuildResult(0,"(nb)",sipRes,a0);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toLongLong, doc_QByteArray_toLongLong);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_toULongLong, "QByteArray.toULongLong(int base=10) -> (int, bool)");

extern "C" {static PyObject *meth_QByteArray_toULongLong(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toULongLong(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool a0;
        int a1 = 10;
        QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            sipName_ok,
            sipName_base,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|i", &sipSelf, sipType_QByteArray, &sipCpp, &a1))
        {
            qulonglong sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->toULongLong(&a0,a1);
            Py_END_ALLOW_THREADS

            return sipBuildResult(0,"(ob)",sipRes,a0);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toULongLong, doc_QByteArray_toULongLong);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_toFloat, "QByteArray.toFloat() -> (float, bool)");

extern "C" {static PyObject *meth_QByteArray_toFloat(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toFloat(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool a0;
        QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            sipName_ok,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            float sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->toFloat(&a0);
            Py_END_ALLOW_THREADS

            return sipBuildResult(0,"(fb)",sipRes,a0);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toFloat, doc_QByteArray_toFloat);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_toDouble, "QByteArray.toDouble() -> (float, bool)");

extern "C" {static PyObject *meth_QByteArray_toDouble(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toDouble(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool a0;
        QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            sipName_ok,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            double sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->toDouble(&a0);
            Py_END_ALLOW_THREADS

            return sipBuildResult(0,"(db)",sipRes,a0);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toDouble, doc_QByteArray_toDouble);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_toBase64, "QByteArray.toBase64() -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_toBase64(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toBase64(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            QByteArray *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QByteArray(sipCpp->toBase64());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QByteArray,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toBase64, doc_QByteArray_toBase64);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_setNum, "QByteArray.setNum(int, int base=10) -> QByteArray\n"
    "QByteArray.setNum(float, str format='g', int precision=6) -> QByteArray\n"
    "QByteArray.setNum(int, int base=10) -> QByteArray\n"
    "QByteArray.setNum(int, int base=10) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_setNum(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_setNum(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        int a1 = 10;
        QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            NULL,
            sipName_base,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BXi|i", &sipSelf, sipType_QByteArray, &sipCpp, &a0, &a1))
        {
            QByteArray *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->setNum(a0,a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromType(sipRes,sipType_QByteArray,NULL);
        }
    }

    {
        double a0;
        char a1 = 'g';
        int a2 = 6;
        QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            NULL,
            sipName_format,
            sipName_precision,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BXd|ci", &sipSelf, sipType_QByteArray, &sipCpp, &a0, &a1, &a2))
        {
            QByteArray *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->setNum(a0,a1,a2);
            Py_END_ALLOW_THREADS

            return sipConvertFromType(sipRes,sipType_QByteArray,NULL);
        }
    }

    {
        qlonglong a0;
        int a1 = 10;
        QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            NULL,
            sipName_base,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bn|i", &sipSelf, sipType_QByteArray, &sipCpp, &a0, &a1))
        {
            QByteArray *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->setNum(a0,a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromType(sipRes,sipType_QByteArray,NULL);
        }
    }

    {
        qulonglong a0;
        int a1 = 10;
        QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            NULL,
            sipName_base,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bo|i", &sipSelf, sipType_QByteArray, &sipCpp, &a0, &a1))
        {
            QByteArray *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->setNum(a0,a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromType(sipRes,sipType_QByteArray,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_setNum, doc_QByteArray_setNum);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_number, "QByteArray.number(int, int base=10) -> QByteArray\n"
    "QByteArray.number(float, str format='g', int precision=6) -> QByteArray\n"
    "QByteArray.number(int, int base=10) -> QByteArray\n"
    "QByteArray.number(int, int base=10) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_number(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_number(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        int a1 = 10;

        static const char *sipKwdList[] = {
            NULL,
            sipName_base,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Xi|i", &a0, &a1))
        {
            QByteArray *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QByteArray(QByteArray::number(a0,a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QByteArray,NULL);
        }
    }

    {
        double a0;
        char a1 = 'g';
        int a2 = 6;

        static const char *sipKwdList[] = {
            NULL,
            sipName_format,
            sipName_precision,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Xd|ci", &a0, &a1, &a2))
        {
            QByteArray *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QByteArray(QByteArray::number(a0,a1,a2));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QByteArray,NULL);
        }
    }

    {
        qlonglong a0;
        int a1 = 10;

        static const char *sipKwdList[] = {
            NULL,
            sipName_base,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "n|i", &a0, &a1))
        {
            QByteArray *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QByteArray(QByteArray::number(a0,a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QByteArray,NULL);
        }
    }

    {
        qulonglong a0;
        int a1 = 10;

        static const char *sipKwdList[] = {
            NULL,
            sipName_base,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "o|i", &a0, &a1))
        {
            QByteArray *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QByteArray(QByteArray::number(a0,a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QByteArray,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_number, doc_QByteArray_number);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_fromBase64, "QByteArray.fromBase64(QByteArray) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_fromBase64(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_fromBase64(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const QByteArray * a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArgs, "J1", sipType_QByteArray, &a0, &a0State))
        {
            QByteArray *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QByteArray(QByteArray::fromBase64(*a0));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QByteArray *>(a0),sipType_QByteArray,a0State);

            return sipConvertFromNewType(sipRes,sipType_QByteArray,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_fromBase64, doc_QByteArray_fromBase64);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_fromRawData, "QByteArray.fromRawData(str) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_fromRawData(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_fromRawData(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const char * a0;
        SIP_SSIZE_T a1;

        if (sipParseArgs(&sipParseErr, sipArgs, "k", &a0, &a1))
        {
            QByteArray *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QByteArray(QByteArray::fromRawData(a0,(int)a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QByteArray,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_fromRawData, doc_QByteArray_fromRawData);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_fromHex, "QByteArray.fromHex(QByteArray) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_fromHex(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_fromHex(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const QByteArray * a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArgs, "J1", sipType_QByteArray, &a0, &a0State))
        {
            QByteArray *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QByteArray(QByteArray::fromHex(*a0));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QByteArray *>(a0),sipType_QByteArray,a0State);

            return sipConvertFromNewType(sipRes,sipType_QByteArray,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_fromHex, doc_QByteArray_fromHex);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_length, "QByteArray.length() -> int");

extern "C" {static PyObject *meth_QByteArray_length(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_length(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->length();
            Py_END_ALLOW_THREADS

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_length, doc_QByteArray_length);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_isNull, "QByteArray.isNull() -> bool");

extern "C" {static PyObject *meth_QByteArray_isNull(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_isNull(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isNull();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_isNull, doc_QByteArray_isNull);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_size, "QByteArray.size() -> int");

extern "C" {static PyObject *meth_QByteArray_size(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_size(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->size();
            Py_END_ALLOW_THREADS

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_size, doc_QByteArray_size);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_at, "QByteArray.at(int) -> str");

extern "C" {static PyObject *meth_QByteArray_at(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_at(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QByteArray, &sipCpp, &a0))
        {
            char sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->at(a0);
            Py_END_ALLOW_THREADS

            return SIPBytes_FromStringAndSize(&sipRes,1);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_at, doc_QByteArray_at);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_isEmpty, "QByteArray.isEmpty() -> bool");

extern "C" {static PyObject *meth_QByteArray_isEmpty(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_isEmpty(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isEmpty();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_isEmpty, doc_QByteArray_isEmpty);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_data, "QByteArray.data() -> str");

extern "C" {static PyObject *meth_QByteArray_data(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_data(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            PyObject * sipRes = 0;
            int sipIsErr = 0;

#line 359 "/home/maemo/python-qt4-4.7/sip/QtCore/qbytearray.sip"
        // QByteArrays may contain embedded '\0's so set the size explicitly.
        
        char *res = sipCpp->data();
        int len = sipCpp->size();
        
        if (res)
        {
            if ((sipRes = SIPBytes_FromStringAndSize(res, len)) == NULL)
                sipIsErr = 1;
        }
        else
        {
            Py_INCREF(Py_None);
            sipRes = Py_None;
        }
#line 1929 "sipQtCoreQByteArray.cpp"

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_data, doc_QByteArray_data);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_capacity, "QByteArray.capacity() -> int");

extern "C" {static PyObject *meth_QByteArray_capacity(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_capacity(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->capacity();
            Py_END_ALLOW_THREADS

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_capacity, doc_QByteArray_capacity);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_reserve, "QByteArray.reserve(int)");

extern "C" {static PyObject *meth_QByteArray_reserve(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_reserve(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QByteArray, &sipCpp, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->reserve(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_reserve, doc_QByteArray_reserve);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_squeeze, "QByteArray.squeeze()");

extern "C" {static PyObject *meth_QByteArray_squeeze(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_squeeze(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->squeeze();
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_squeeze, doc_QByteArray_squeeze);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_push_back, "QByteArray.push_back(QByteArray)");

extern "C" {static PyObject *meth_QByteArray_push_back(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_push_back(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const QByteArray * a0;
        int a0State = 0;
        QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QByteArray, &a0, &a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->push_back(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QByteArray *>(a0),sipType_QByteArray,a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_push_back, doc_QByteArray_push_back);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_push_front, "QByteArray.push_front(QByteArray)");

extern "C" {static PyObject *meth_QByteArray_push_front(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_push_front(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const QByteArray * a0;
        int a0State = 0;
        QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QByteArray, &a0, &a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->push_front(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QByteArray *>(a0),sipType_QByteArray,a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_push_front, doc_QByteArray_push_front);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_contains, "QByteArray.contains(QByteArray) -> bool");

extern "C" {static PyObject *meth_QByteArray_contains(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_contains(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const QByteArray * a0;
        int a0State = 0;
        QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QByteArray, &a0, &a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->contains(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QByteArray *>(a0),sipType_QByteArray,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_contains, doc_QByteArray_contains);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_toHex, "QByteArray.toHex() -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_toHex(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toHex(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            QByteArray *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QByteArray(sipCpp->toHex());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QByteArray,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toHex, doc_QByteArray_toHex);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_toPercentEncoding, "QByteArray.toPercentEncoding(QByteArray exclude=QByteArray(), QByteArray include=QByteArray(), str percent='%') -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_toPercentEncoding(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toPercentEncoding(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const QByteArray& a0def = QByteArray();
        const QByteArray * a0 = &a0def;
        int a0State = 0;
        const QByteArray& a1def = QByteArray();
        const QByteArray * a1 = &a1def;
        int a1State = 0;
        char a2 = '%';
        QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            sipName_exclude,
            sipName_include,
            sipName_percent,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|J1J1c", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QByteArray, &a0, &a0State, sipType_QByteArray, &a1, &a1State, &a2))
        {
            QByteArray *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QByteArray(sipCpp->toPercentEncoding(*a0,*a1,a2));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QByteArray *>(a0),sipType_QByteArray,a0State);
            sipReleaseType(const_cast<QByteArray *>(a1),sipType_QByteArray,a1State);

            return sipConvertFromNewType(sipRes,sipType_QByteArray,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toPercentEncoding, doc_QByteArray_toPercentEncoding);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_fromPercentEncoding, "QByteArray.fromPercentEncoding(QByteArray, str percent='%') -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_fromPercentEncoding(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_fromPercentEncoding(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const QByteArray * a0;
        int a0State = 0;
        char a1 = '%';

        static const char *sipKwdList[] = {
            NULL,
            sipName_percent,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1|c", sipType_QByteArray, &a0, &a0State, &a1))
        {
            QByteArray *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QByteArray(QByteArray::fromPercentEncoding(*a0,a1));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QByteArray *>(a0),sipType_QByteArray,a0State);

            return sipConvertFromNewType(sipRes,sipType_QByteArray,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_fromPercentEncoding, doc_QByteArray_fromPercentEncoding);

    return NULL;
}


PyDoc_STRVAR(doc_QByteArray_repeated, "QByteArray.repeated(int) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_repeated(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_repeated(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QByteArray, &sipCpp, &a0))
        {
            QByteArray *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QByteArray(sipCpp->repeated(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QByteArray,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_repeated, doc_QByteArray_repeated);

    return NULL;
}


extern "C" {static PyObject *slot_QByteArray___add__(PyObject *sipArg0,PyObject *sipArg1);}
static PyObject *slot_QByteArray___add__(PyObject *sipArg0,PyObject *sipArg1)
{
    PyObject *sipParseErr = NULL;

    {
        const QByteArray * a0;
        int a0State = 0;
        const QString * a1;
        int a1State = 0;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J1J1", sipType_QByteArray, &a0, &a0State, sipType_QString,&a1, &a1State))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString((*a0 + *a1));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QByteArray *>(a0),sipType_QByteArray,a0State);
            sipReleaseType(const_cast<QString *>(a1),sipType_QString,a1State);

            return sipConvertFromNewType(sipRes,sipType_QString,NULL);
        }
    }

    {
        const QByteArray * a0;
        int a0State = 0;
        const QByteArray * a1;
        int a1State = 0;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J1J1", sipType_QByteArray, &a0, &a0State, sipType_QByteArray, &a1, &a1State))
        {
            QByteArray *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QByteArray((*a0 + *a1));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QByteArray *>(a0),sipType_QByteArray,a0State);
            sipReleaseType(const_cast<QByteArray *>(a1),sipType_QByteArray,a1State);

            return sipConvertFromNewType(sipRes,sipType_QByteArray,NULL);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,add_slot,NULL,sipArg0,sipArg1);
}


extern "C" {static PyObject *slot_QByteArray___imul__(PyObject *sipSelf,int a0);}
static PyObject *slot_QByteArray___imul__(PyObject *sipSelf,int a0)
{
    QByteArray *sipCpp = reinterpret_cast<QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QByteArray));

    if (!sipCpp)
        return 0;


    {
        {
#line 348 "/home/maemo/python-qt4-4.7/sip/QtCore/qbytearray.sip"
        QByteArray orig(*sipCpp);
        
        sipCpp->clear();
        
        while (a0-- > 0)
            *sipCpp += orig;
#line 2342 "sipQtCoreQByteArray.cpp"

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }
}


extern "C" {static PyObject *slot_QByteArray___mul__(PyObject *sipSelf,int a0);}
static PyObject *slot_QByteArray___mul__(PyObject *sipSelf,int a0)
{
    QByteArray *sipCpp = reinterpret_cast<QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QByteArray));

    if (!sipCpp)
        return 0;


    {
        {
            QByteArray *sipRes = 0;

#line 340 "/home/maemo/python-qt4-4.7/sip/QtCore/qbytearray.sip"
        sipRes = new QByteArray();
        
        while (a0-- > 0)
            *sipRes += *sipCpp;
#line 2369 "sipQtCoreQByteArray.cpp"

            return sipConvertFromNewType(sipRes,sipType_QByteArray,NULL);
        }
    }
}


extern "C" {static PyObject *slot_QByteArray___repr__(PyObject *sipSelf);}
static PyObject *slot_QByteArray___repr__(PyObject *sipSelf)
{
    QByteArray *sipCpp = reinterpret_cast<QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QByteArray));

    if (!sipCpp)
        return 0;


    {
        {
            PyObject * sipRes = 0;

#line 322 "/home/maemo/python-qt4-4.7/sip/QtCore/qbytearray.sip"
        PyObject *str = QByteArrayToPyStr(sipCpp);
        
        if (str)
        {
        #if PY_MAJOR_VERSION >= 3
            sipRes = PyUnicode_FromFormat("PyQt4.QtCore.QByteArray(%R)", str);
        #else
            sipRes = PyString_FromString("PyQt4.QtCore.QByteArray(");
            PyString_ConcatAndDel(&sipRes, PyObject_Repr(str));
            PyString_ConcatAndDel(&sipRes, PyString_FromString(")"));
        #endif
        
            Py_DECREF(str);
        }
#line 2405 "sipQtCoreQByteArray.cpp"

            return sipRes;
        }
    }
}


extern "C" {static PyObject *slot_QByteArray___str__(PyObject *sipSelf);}
static PyObject *slot_QByteArray___str__(PyObject *sipSelf)
{
    QByteArray *sipCpp = reinterpret_cast<QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QByteArray));

    if (!sipCpp)
        return 0;


    {
        {
            PyObject * sipRes = 0;

#line 307 "/home/maemo/python-qt4-4.7/sip/QtCore/qbytearray.sip"
        sipRes = QByteArrayToPyStr(sipCpp);
        
        #if PY_MAJOR_VERSION >= 3
        PyObject *repr = PyObject_Repr(sipRes);
        
        if (repr)
        {
            Py_DECREF(sipRes);
            sipRes = repr;
        }
        #endif
#line 2438 "sipQtCoreQByteArray.cpp"

            return sipRes;
        }
    }
}


extern "C" {static long slot_QByteArray___hash__(PyObject *sipSelf);}
static long slot_QByteArray___hash__(PyObject *sipSelf)
{
    QByteArray *sipCpp = reinterpret_cast<QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QByteArray));

    if (!sipCpp)
        return 0;


    {
        {
            long sipRes = 0;

#line 302 "/home/maemo/python-qt4-4.7/sip/QtCore/qbytearray.sip"
        sipRes = qHash(*sipCpp);
#line 2461 "sipQtCoreQByteArray.cpp"

            return sipRes;
        }
    }
}


extern "C" {static int slot_QByteArray___contains__(PyObject *sipSelf,PyObject *sipArg);}
static int slot_QByteArray___contains__(PyObject *sipSelf,PyObject *sipArg)
{
    QByteArray *sipCpp = reinterpret_cast<QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QByteArray));

    if (!sipCpp)
        return -1;

    PyObject *sipParseErr = NULL;

    {
        const QByteArray * a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QByteArray, &a0, &a0State))
        {
            int sipRes = 0;

#line 296 "/home/maemo/python-qt4-4.7/sip/QtCore/qbytearray.sip"
        // It looks like you can't assign QBool to int.
        sipRes = bool(sipCpp->contains(*a0));
#line 2490 "sipQtCoreQByteArray.cpp"
            sipReleaseType(const_cast<QByteArray *>(a0),sipType_QByteArray,a0State);

            return sipRes;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName___contains__, NULL);

    return -1;
}


extern "C" {static int slot_QByteArray___len__(PyObject *sipSelf);}
static int slot_QByteArray___len__(PyObject *sipSelf)
{
    QByteArray *sipCpp = reinterpret_cast<QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QByteArray));

    if (!sipCpp)
        return -1;


    {
        {
            int sipRes = 0;

#line 291 "/home/maemo/python-qt4-4.7/sip/QtCore/qbytearray.sip"
        sipRes = sipCpp->length();
#line 2519 "sipQtCoreQByteArray.cpp"

            return sipRes;
        }
    }
}


extern "C" {static PyObject *slot_QByteArray___getitem__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QByteArray___getitem__(PyObject *sipSelf,PyObject *sipArg)
{
    QByteArray *sipCpp = reinterpret_cast<QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QByteArray));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        int a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1i", &a0))
        {
            char sipRes = 0;
            int sipIsErr = 0;

#line 261 "/home/maemo/python-qt4-4.7/sip/QtCore/qbytearray.sip"
        SIP_SSIZE_T idx = sipConvertFromSequenceIndex(a0, sipCpp->count());
        
        if (idx < 0)
            sipIsErr = 1;
        else
            sipRes = sipCpp->operator[]((int)idx);
#line 2552 "sipQtCoreQByteArray.cpp"

            if (sipIsErr)
                return 0;

            return SIPBytes_FromStringAndSize(&sipRes,1);
        }
    }

    {
        PyObject * a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1T", &PySlice_Type, &a0))
        {
            QByteArray *sipRes = 0;
            int sipIsErr = 0;

#line 271 "/home/maemo/python-qt4-4.7/sip/QtCore/qbytearray.sip"
        SIP_SSIZE_T len, start, stop, step, slicelength, i;
        
        len = sipCpp->length();
        
        if (PySlice_GetIndicesEx((PySliceObject *)a0, len, &start, &stop, &step, &slicelength) < 0)
            sipIsErr = 1;
        else
        {
            sipRes = new QByteArray();
        
            for (i = 0; i < slicelength; ++i)
            {
                sipRes -> append(sipCpp->at(start));
                start += step;
            }
        }
#line 2586 "sipQtCoreQByteArray.cpp"

            if (sipIsErr)
                return 0;

            return sipConvertFromNewType(sipRes,sipType_QByteArray,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QByteArray, sipName___getitem__, NULL);

    return 0;
}


extern "C" {static PyObject *slot_QByteArray___ge__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QByteArray___ge__(PyObject *sipSelf,PyObject *sipArg)
{
    QByteArray *sipCpp = reinterpret_cast<QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QByteArray));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const QByteArray * a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QByteArray, &a0, &a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = operator>=((*sipCpp), *a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QByteArray *>(a0),sipType_QByteArray,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const QString * a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QString,&a0, &a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QByteArray::operator>=(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QString *>(a0),sipType_QString,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,ge_slot,sipType_QByteArray,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QByteArray___le__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QByteArray___le__(PyObject *sipSelf,PyObject *sipArg)
{
    QByteArray *sipCpp = reinterpret_cast<QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QByteArray));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const QByteArray * a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QByteArray, &a0, &a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = operator<=((*sipCpp), *a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QByteArray *>(a0),sipType_QByteArray,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const QString * a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QString,&a0, &a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QByteArray::operator<=(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QString *>(a0),sipType_QString,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,le_slot,sipType_QByteArray,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QByteArray___gt__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QByteArray___gt__(PyObject *sipSelf,PyObject *sipArg)
{
    QByteArray *sipCpp = reinterpret_cast<QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QByteArray));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const QByteArray * a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QByteArray, &a0, &a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = operator>((*sipCpp), *a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QByteArray *>(a0),sipType_QByteArray,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const QString * a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QString,&a0, &a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QByteArray::operator>(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QString *>(a0),sipType_QString,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,gt_slot,sipType_QByteArray,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QByteArray___lt__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QByteArray___lt__(PyObject *sipSelf,PyObject *sipArg)
{
    QByteArray *sipCpp = reinterpret_cast<QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QByteArray));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const QByteArray * a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QByteArray, &a0, &a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = operator<((*sipCpp), *a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QByteArray *>(a0),sipType_QByteArray,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const QString * a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QString,&a0, &a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QByteArray::operator<(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QString *>(a0),sipType_QString,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,lt_slot,sipType_QByteArray,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QByteArray___ne__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QByteArray___ne__(PyObject *sipSelf,PyObject *sipArg)
{
    QByteArray *sipCpp = reinterpret_cast<QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QByteArray));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const QByteArray * a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QByteArray, &a0, &a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = operator!=((*sipCpp), *a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QByteArray *>(a0),sipType_QByteArray,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const QString * a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QString,&a0, &a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QByteArray::operator!=(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QString *>(a0),sipType_QString,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,ne_slot,sipType_QByteArray,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QByteArray___eq__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QByteArray___eq__(PyObject *sipSelf,PyObject *sipArg)
{
    QByteArray *sipCpp = reinterpret_cast<QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QByteArray));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const QByteArray * a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QByteArray, &a0, &a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = operator==((*sipCpp), *a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QByteArray *>(a0),sipType_QByteArray,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const QString * a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QString,&a0, &a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QByteArray::operator==(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QString *>(a0),sipType_QString,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,eq_slot,sipType_QByteArray,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QByteArray___iadd__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QByteArray___iadd__(PyObject *sipSelf,PyObject *sipArg)
{
    QByteArray *sipCpp = reinterpret_cast<QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QByteArray));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const QByteArray * a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QByteArray, &a0, &a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->QByteArray::operator+=(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QByteArray *>(a0),sipType_QByteArray,a0State);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    {
        const QString * a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QString,&a0, &a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->QByteArray::operator+=(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QString *>(a0),sipType_QString,a0State);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    /* Raise an exception if the argument couldn't be parsed. */
    sipBadOperatorArg(sipSelf,sipArg,iconcat_slot);

    return NULL;
}


/* Cast a pointer to a type somewhere in its superclass hierarchy. */
extern "C" {static void *cast_QByteArray(void *, const sipTypeDef *);}
static void *cast_QByteArray(void *ptr, const sipTypeDef *targetType)
{
    if (targetType == sipType_QByteArray)
        return ptr;

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_QByteArray(void *, int);}
static void release_QByteArray(void *sipCppV,int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast<QByteArray *>(sipCppV);

    Py_END_ALLOW_THREADS
}


#if PY_MAJOR_VERSION >= 3
extern "C" {static int getbuffer_QByteArray(PyObject *, void *, Py_buffer *, int);}
static int getbuffer_QByteArray(PyObject *sipSelf, void *sipCppV, Py_buffer *sipBuffer, int sipFlags)
{
    QByteArray *sipCpp = reinterpret_cast<QByteArray *>(sipCppV);
    int sipRes;

#line 146 "/home/maemo/python-qt4-4.7/sip/QtCore/qbytearray.sip"
    sipRes = PyBuffer_FillInfo(sipBuffer, sipSelf, sipCpp->data(), sipCpp->size(), 0, sipFlags);
#line 2971 "sipQtCoreQByteArray.cpp"

    return sipRes;
}
#endif


#if PY_MAJOR_VERSION < 3
extern "C" {static SIP_SSIZE_T getreadbuffer_QByteArray(PyObject *, void *, SIP_SSIZE_T, void **);}
static SIP_SSIZE_T getreadbuffer_QByteArray(PyObject *, void *sipCppV, SIP_SSIZE_T sipSegment, void **sipPtrPtr)
{
    QByteArray *sipCpp = reinterpret_cast<QByteArray *>(sipCppV);
    SIP_SSIZE_T sipRes;

#line 150 "/home/maemo/python-qt4-4.7/sip/QtCore/qbytearray.sip"
    if (sipSegment != 0)
    {
        PyErr_SetString(PyExc_SystemError, "accessing non-existent QByteArray segment");
        sipRes = -1;
    }
    else
    {
        *sipPtrPtr = (void *)sipCpp->data();
        sipRes = sipCpp->size();
    }
#line 2996 "sipQtCoreQByteArray.cpp"

    return sipRes;
}
#endif


#if PY_MAJOR_VERSION < 3
extern "C" {static SIP_SSIZE_T getsegcount_QByteArray(PyObject *, void *, SIP_SSIZE_T *);}
static SIP_SSIZE_T getsegcount_QByteArray(PyObject *, void *sipCppV, SIP_SSIZE_T *sipLenPtr)
{
    QByteArray *sipCpp = reinterpret_cast<QByteArray *>(sipCppV);
    SIP_SSIZE_T sipRes;

#line 163 "/home/maemo/python-qt4-4.7/sip/QtCore/qbytearray.sip"
    if (sipLenPtr)
        *sipLenPtr = sipCpp->size();
    
    sipRes = 1;
#line 3015 "sipQtCoreQByteArray.cpp"

    return sipRes;
}
#endif


#if PY_MAJOR_VERSION < 3
extern "C" {static SIP_SSIZE_T getcharbuffer_QByteArray(PyObject *, void *, SIP_SSIZE_T, void **);}
static SIP_SSIZE_T getcharbuffer_QByteArray(PyObject *, void *sipCppV, SIP_SSIZE_T sipSegment, void **sipPtrPtr)
{
    QByteArray *sipCpp = reinterpret_cast<QByteArray *>(sipCppV);
    SIP_SSIZE_T sipRes;

#line 170 "/home/maemo/python-qt4-4.7/sip/QtCore/qbytearray.sip"
    if (sipSegment != 0)
    {
        PyErr_SetString(PyExc_SystemError, "accessing non-existent QByteArray segment");
        sipRes = -1;
    }
    else
    {
        *sipPtrPtr = (void *)sipCpp->data();
        sipRes = sipCpp->size();
    }
#line 3040 "sipQtCoreQByteArray.cpp"

    return sipRes;
}
#endif


extern "C" {static PyObject *pickle_QByteArray(void *);}
static PyObject *pickle_QByteArray(void *sipCppV)
{
    QByteArray *sipCpp = reinterpret_cast<QByteArray *>(sipCppV);
    PyObject *sipRes;

#line 183 "/home/maemo/python-qt4-4.7/sip/QtCore/qbytearray.sip"
    sipRes = Py_BuildValue((char *)"(s#)", sipCpp->data(), sipCpp->size());
#line 3055 "sipQtCoreQByteArray.cpp"

    return sipRes;
}


extern "C" {static void assign_QByteArray(void *, SIP_SSIZE_T, const void *);}
static void assign_QByteArray(void *sipDst, SIP_SSIZE_T sipDstIdx, const void *sipSrc)
{
    reinterpret_cast<QByteArray *>(sipDst)[sipDstIdx] = *reinterpret_cast<const QByteArray *>(sipSrc);
}


extern "C" {static void *array_QByteArray(SIP_SSIZE_T);}
static void *array_QByteArray(SIP_SSIZE_T sipNrElem)
{
    return new QByteArray[sipNrElem];
}


extern "C" {static void *copy_QByteArray(const void *, SIP_SSIZE_T);}
static void *copy_QByteArray(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new QByteArray(reinterpret_cast<const QByteArray *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QByteArray(sipSimpleWrapper *);}
static void dealloc_QByteArray(sipSimpleWrapper *sipSelf)
{
    if (sipIsPyOwned(sipSelf))
    {
        release_QByteArray(sipSelf->u.cppPtr,0);
    }
}


extern "C" {static void *init_QByteArray(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_QByteArray(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    QByteArray *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QByteArray();
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        int a0;
        char a1;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "ic", &a0, &a1))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QByteArray(a0,a1);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        const QByteArray * a0;
        int a0State = 0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J1", sipType_QByteArray, &a0, &a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QByteArray(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QByteArray *>(a0),sipType_QByteArray,a0State);

            return sipCpp;
        }
    }

    return NULL;
}


extern "C" {static int convertTo_QByteArray(PyObject *, void **, int *, PyObject *);}
static int convertTo_QByteArray(PyObject *sipPy,void **sipCppPtrV,int *sipIsErr,PyObject *sipTransferObj)
{
    QByteArray **sipCppPtr = reinterpret_cast<QByteArray **>(sipCppPtrV);

#line 65 "/home/maemo/python-qt4-4.7/sip/QtCore/qbytearray.sip"
// We have to be very careful about what we allow to be converted to a
// QByteArray and to a QString as we need to take into account the v1 and v2
// APIs and Python v2.x and v3.x.
//
// QSvgRenderer() is a good example of what needs to work "naturally".  This
// has a ctor that takes a QString argument that is the name of the SVG file.
// It has another ctor that takes a QByteArray argument that is the SVG data.
//
// In Python v2.x we want a str object to be interpreted as the name of the
// file (as that is the historical behaviour).  This has the following
// implications.
//
// - The QString version of the ctor must appear before the QByteArray version
//   in the .sip file.  This rule should be applied wherever a similar
//   situation arises.
// - A QString must not automatically convert a QByteArray.
// - QByteArray must also exist in the v2 API.
//
// In Python v3.x we want a bytes object to be used wherever a QByteArray is
// expected.  This means that a QString must not automatically convert a bytes
// object.
//
// Qt uses QByteArray to represent binary data and also '\0' terminated C
// strings.  If we only allowed a bytes object to be automatically converted to
// a QByteArray then we would force such strings to be either explicitly
// specified as bytes (ie. have a leading 'b') or wrapped in a call to the
// QByteArray ctor - neither of which is very Pythonic.  We therefore allow a
// Latin-1 encoded str object to be automatcially converted to a QByteArray.
// For consistency we also allow a Python v2.x unicode object to be similarly
// converted.

if (sipIsErr == NULL)
    return (
#if PY_VERSION_HEX >= 0x02060000
            PyByteArray_Check(sipPy) ||
#endif
            PyUnicode_Check(sipPy) || SIPBytes_Check(sipPy) ||
            sipCanConvertToType(sipPy, sipType_QByteArray, SIP_NO_CONVERTORS));

#if PY_VERSION_HEX >= 0x02060000
if (PyByteArray_Check(sipPy))
{
    *sipCppPtr = new QByteArray(PyByteArray_AS_STRING(sipPy),
            PyByteArray_GET_SIZE(sipPy));

    return sipGetState(sipTransferObj);
}
#endif

if (PyUnicode_Check(sipPy))
{
    const char *bytes = sipString_AsLatin1String(&sipPy);

    if (!sipPy)
    {
        *sipIsErr = 1;
        return 0;
    }

    *sipCppPtr = new QByteArray(bytes);

    Py_DECREF(sipPy);

    return sipGetState(sipTransferObj);
}

if (SIPBytes_Check(sipPy))
{
    *sipCppPtr = new QByteArray(SIPBytes_AS_STRING(sipPy),
            SIPBytes_GET_SIZE(sipPy));

    return sipGetState(sipTransferObj);
}

*sipCppPtr = reinterpret_cast<QByteArray *>(sipConvertToType(sipPy,
        sipType_QByteArray, sipTransferObj, SIP_NO_CONVERTORS, 0, sipIsErr));

return 0;
#line 3225 "sipQtCoreQByteArray.cpp"
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QByteArray[] = {
    {(void *)slot_QByteArray___add__, add_slot},
    {(void *)slot_QByteArray___imul__, irepeat_slot},
    {(void *)slot_QByteArray___mul__, repeat_slot},
    {(void *)slot_QByteArray___repr__, repr_slot},
    {(void *)slot_QByteArray___str__, str_slot},
    {(void *)slot_QByteArray___hash__, hash_slot},
    {(void *)slot_QByteArray___contains__, contains_slot},
    {(void *)slot_QByteArray___len__, len_slot},
    {(void *)slot_QByteArray___getitem__, getitem_slot},
    {(void *)slot_QByteArray___ge__, ge_slot},
    {(void *)slot_QByteArray___le__, le_slot},
    {(void *)slot_QByteArray___gt__, gt_slot},
    {(void *)slot_QByteArray___lt__, lt_slot},
    {(void *)slot_QByteArray___ne__, ne_slot},
    {(void *)slot_QByteArray___eq__, eq_slot},
    {(void *)slot_QByteArray___iadd__, iconcat_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QByteArray[] = {
    {SIP_MLNAME_CAST(sipName_append), meth_QByteArray_append, METH_VARARGS, SIP_MLDOC_CAST(doc_QByteArray_append)},
    {SIP_MLNAME_CAST(sipName_at), meth_QByteArray_at, METH_VARARGS, SIP_MLDOC_CAST(doc_QByteArray_at)},
    {SIP_MLNAME_CAST(sipName_capacity), meth_QByteArray_capacity, METH_VARARGS, SIP_MLDOC_CAST(doc_QByteArray_capacity)},
    {SIP_MLNAME_CAST(sipName_chop), meth_QByteArray_chop, METH_VARARGS, SIP_MLDOC_CAST(doc_QByteArray_chop)},
    {SIP_MLNAME_CAST(sipName_clear), meth_QByteArray_clear, METH_VARARGS, SIP_MLDOC_CAST(doc_QByteArray_clear)},
    {SIP_MLNAME_CAST(sipName_contains), meth_QByteArray_contains, METH_VARARGS, SIP_MLDOC_CAST(doc_QByteArray_contains)},
    {SIP_MLNAME_CAST(sipName_count), meth_QByteArray_count, METH_VARARGS, SIP_MLDOC_CAST(doc_QByteArray_count)},
    {SIP_MLNAME_CAST(sipName_data), meth_QByteArray_data, METH_VARARGS, SIP_MLDOC_CAST(doc_QByteArray_data)},
    {SIP_MLNAME_CAST(sipName_endsWith), meth_QByteArray_endsWith, METH_VARARGS, SIP_MLDOC_CAST(doc_QByteArray_endsWith)},
    {SIP_MLNAME_CAST(sipName_fill), (PyCFunction)meth_QByteArray_fill, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_QByteArray_fill)},
    {SIP_MLNAME_CAST(sipName_fromBase64), meth_QByteArray_fromBase64, METH_VARARGS, SIP_MLDOC_CAST(doc_QByteArray_fromBase64)},
    {SIP_MLNAME_CAST(sipName_fromHex), meth_QByteArray_fromHex, METH_VARARGS, SIP_MLDOC_CAST(doc_QByteArray_fromHex)},
    {SIP_MLNAME_CAST(sipName_fromPercentEncoding), (PyCFunction)meth_QByteArray_fromPercentEncoding, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_QByteArray_fromPercentEncoding)},
    {SIP_MLNAME_CAST(sipName_fromRawData), meth_QByteArray_fromRawData, METH_VARARGS, SIP_MLDOC_CAST(doc_QByteArray_fromRawData)},
    {SIP_MLNAME_CAST(sipName_indexOf), (PyCFunction)meth_QByteArray_indexOf, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_QByteArray_indexOf)},
    {SIP_MLNAME_CAST(sipName_insert), meth_QByteArray_insert, METH_VARARGS, SIP_MLDOC_CAST(doc_QByteArray_insert)},
    {SIP_MLNAME_CAST(sipName_isEmpty), meth_QByteArray_isEmpty, METH_VARARGS, SIP_MLDOC_CAST(doc_QByteArray_isEmpty)},
    {SIP_MLNAME_CAST(sipName_isNull), meth_QByteArray_isNull, METH_VARARGS, SIP_MLDOC_CAST(doc_QByteArray_isNull)},
    {SIP_MLNAME_CAST(sipName_lastIndexOf), (PyCFunction)meth_QByteArray_lastIndexOf, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_QByteArray_lastIndexOf)},
    {SIP_MLNAME_CAST(sipName_left), meth_QByteArray_left, METH_VARARGS, SIP_MLDOC_CAST(doc_QByteArray_left)},
    {SIP_MLNAME_CAST(sipName_leftJustified), (PyCFunction)meth_QByteArray_leftJustified, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_QByteArray_leftJustified)},
    {SIP_MLNAME_CAST(sipName_length), meth_QByteArray_length, METH_VARARGS, SIP_MLDOC_CAST(doc_QByteArray_length)},
    {SIP_MLNAME_CAST(sipName_mid), (PyCFunction)meth_QByteArray_mid, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_QByteArray_mid)},
    {SIP_MLNAME_CAST(sipName_number), (PyCFunction)meth_QByteArray_number, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_QByteArray_number)},
    {SIP_MLNAME_CAST(sipName_prepend), meth_QByteArray_prepend, METH_VARARGS, SIP_MLDOC_CAST(doc_QByteArray_prepend)},
    {SIP_MLNAME_CAST(sipName_push_back), meth_QByteArray_push_back, METH_VARARGS, SIP_MLDOC_CAST(doc_QByteArray_push_back)},
    {SIP_MLNAME_CAST(sipName_push_front), meth_QByteArray_push_front, METH_VARARGS, SIP_MLDOC_CAST(doc_QByteArray_push_front)},
    {SIP_MLNAME_CAST(sipName_remove), meth_QByteArray_remove, METH_VARARGS, SIP_MLDOC_CAST(doc_QByteArray_remove)},
    {SIP_MLNAME_CAST(sipName_repeated), meth_QByteArray_repeated, METH_VARARGS, SIP_MLDOC_CAST(doc_QByteArray_repeated)},
    {SIP_MLNAME_CAST(sipName_replace), meth_QByteArray_replace, METH_VARARGS, SIP_MLDOC_CAST(doc_QByteArray_replace)},
    {SIP_MLNAME_CAST(sipName_reserve), meth_QByteArray_reserve, METH_VARARGS, SIP_MLDOC_CAST(doc_QByteArray_reserve)},
    {SIP_MLNAME_CAST(sipName_resize), meth_QByteArray_resize, METH_VARARGS, SIP_MLDOC_CAST(doc_QByteArray_resize)},
    {SIP_MLNAME_CAST(sipName_right), meth_QByteArray_right, METH_VARARGS, SIP_MLDOC_CAST(doc_QByteArray_right)},
    {SIP_MLNAME_CAST(sipName_rightJustified), (PyCFunction)meth_QByteArray_rightJustified, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_QByteArray_rightJustified)},
    {SIP_MLNAME_CAST(sipName_setNum), (PyCFunction)meth_QByteArray_setNum, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_QByteArray_setNum)},
    {SIP_MLNAME_CAST(sipName_simplified), meth_QByteArray_simplified, METH_VARARGS, SIP_MLDOC_CAST(doc_QByteArray_simplified)},
    {SIP_MLNAME_CAST(sipName_size), meth_QByteArray_size, METH_VARARGS, SIP_MLDOC_CAST(doc_QByteArray_size)},
    {SIP_MLNAME_CAST(sipName_split), meth_QByteArray_split, METH_VARARGS, SIP_MLDOC_CAST(doc_QByteArray_split)},
    {SIP_MLNAME_CAST(sipName_squeeze), meth_QByteArray_squeeze, METH_VARARGS, SIP_MLDOC_CAST(doc_QByteArray_squeeze)},
    {SIP_MLNAME_CAST(sipName_startsWith), meth_QByteArray_startsWith, METH_VARARGS, SIP_MLDOC_CAST(doc_QByteArray_startsWith)},
    {SIP_MLNAME_CAST(sipName_toBase64), meth_QByteArray_toBase64, METH_VARARGS, SIP_MLDOC_CAST(doc_QByteArray_toBase64)},
    {SIP_MLNAME_CAST(sipName_toDouble), (PyCFunction)meth_QByteArray_toDouble, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_QByteArray_toDouble)},
    {SIP_MLNAME_CAST(sipName_toFloat), (PyCFunction)meth_QByteArray_toFloat, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_QByteArray_toFloat)},
    {SIP_MLNAME_CAST(sipName_toHex), meth_QByteArray_toHex, METH_VARARGS, SIP_MLDOC_CAST(doc_QByteArray_toHex)},
    {SIP_MLNAME_CAST(sipName_toInt), (PyCFunction)meth_QByteArray_toInt, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_QByteArray_toInt)},
    {SIP_MLNAME_CAST(sipName_toLong), (PyCFunction)meth_QByteArray_toLong, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_QByteArray_toLong)},
    {SIP_MLNAME_CAST(sipName_toLongLong), (PyCFunction)meth_QByteArray_toLongLong, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_QByteArray_toLongLong)},
    {SIP_MLNAME_CAST(sipName_toLower), meth_QByteArray_toLower, METH_VARARGS, SIP_MLDOC_CAST(doc_QByteArray_toLower)},
    {SIP_MLNAME_CAST(sipName_toPercentEncoding), (PyCFunction)meth_QByteArray_toPercentEncoding, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_QByteArray_toPercentEncoding)},
    {SIP_MLNAME_CAST(sipName_toShort), (PyCFunction)meth_QByteArray_toShort, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_QByteArray_toShort)},
    {SIP_MLNAME_CAST(sipName_toUInt), (PyCFunction)meth_QByteArray_toUInt, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_QByteArray_toUInt)},
    {SIP_MLNAME_CAST(sipName_toULong), (PyCFunction)meth_QByteArray_toULong, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_QByteArray_toULong)},
    {SIP_MLNAME_CAST(sipName_toULongLong), (PyCFunction)meth_QByteArray_toULongLong, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_QByteArray_toULongLong)},
    {SIP_MLNAME_CAST(sipName_toUShort), (PyCFunction)meth_QByteArray_toUShort, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_QByteArray_toUShort)},
    {SIP_MLNAME_CAST(sipName_toUpper), meth_QByteArray_toUpper, METH_VARARGS, SIP_MLDOC_CAST(doc_QByteArray_toUpper)},
    {SIP_MLNAME_CAST(sipName_trimmed), meth_QByteArray_trimmed, METH_VARARGS, SIP_MLDOC_CAST(doc_QByteArray_trimmed)},
    {SIP_MLNAME_CAST(sipName_truncate), meth_QByteArray_truncate, METH_VARARGS, SIP_MLDOC_CAST(doc_QByteArray_truncate)}
};

PyDoc_STRVAR(doc_QByteArray, "\1QByteArray()\n"
    "QByteArray(int, str)\n"
    "QByteArray(QByteArray)");


pyqt4ClassTypeDef sipTypeDef_QtCore_QByteArray = {
{
    {
        -1,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_QByteArray,
        {0}
    },
    {
        sipNameNr_QByteArray,
        {0, 0, 1},
        57, methods_QByteArray,
        0, 0,
        0, 0,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_QByteArray,
    sipNameNr_PyQt4_QtCore_pyqtWrapperType,
    sipNameNr_sip_simplewrapper,
    0,
    slots_QByteArray,
    init_QByteArray,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    getbuffer_QByteArray,
    0,
#else
    getreadbuffer_QByteArray,
    0,
    getsegcount_QByteArray,
    getcharbuffer_QByteArray,
#endif
    dealloc_QByteArray,
    assign_QByteArray,
    array_QByteArray,
    copy_QByteArray,
    release_QByteArray,
    cast_QByteArray,
    convertTo_QByteArray,
    0,
    pickle_QByteArray
},
    0,
    0,
    0
};
