/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.7.7 on Tue Nov  3 22:16:49 2009
 *
 * Copyright (c) 2008 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt.
 * 
 * This file may be used under the terms of the GNU General Public
 * License versions 2.0 or 3.0 as published by the Free Software
 * Foundation and appearing in the files LICENSE.GPL2 and LICENSE.GPL3
 * included in the packaging of this file.  Alternatively you may (at
 * your option) use any later version of the GNU General Public
 * License if such license has been publicly approved by Riverbank
 * Computing Limited (or its successors, if any) and the KDE Free Qt
 * Foundation. In addition, as a special exception, Riverbank gives you
 * certain additional rights. These rights are described in the Riverbank
 * GPL Exception version 1.1, which can be found in the file
 * GPL_EXCEPTION.txt in this package.
 * 
 * Please review the following information to ensure GNU General
 * Public Licensing requirements will be met:
 * http://trolltech.com/products/qt/licenses/licensing/opensource/. If
 * you are unsure which license is appropriate for your use, please
 * review the following information:
 * http://trolltech.com/products/qt/licenses/licensing/licensingoverview
 * or contact the sales department at sales@riverbankcomputing.com.
 * 
 * This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
 * INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE. Trolltech reserves all rights not expressly
 * granted herein.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 42 "sip/QtCore/qobjectdefs.sip"
#include <qobjectdefs.h>
#line 44 "sipQtCoreQMetaObject.cpp"

#line 66 "sip/QtCore/qobject.sip"
#include <qobject.h>
#line 48 "sipQtCoreQMetaObject.cpp"
#line 45 "sip/QtCore/qnamespace.sip"
#include <qnamespace.h>
#line 51 "sipQtCoreQMetaObject.cpp"
#line 298 "sip/QtCore/qobjectdefs.sip"
#include <qobjectdefs.h>
#line 54 "sipQtCoreQMetaObject.cpp"
#line 281 "sip/QtCore/qobjectdefs.sip"
#include <qobjectdefs.h>
#line 57 "sipQtCoreQMetaObject.cpp"
#line 59 "sip/QtCore/qbytearray.sip"
#include <qbytearray.h>
#line 60 "sipQtCoreQMetaObject.cpp"
#line 131 "sip/QtCore/qmetaobject.sip"
#include <qmetaobject.h>
#line 63 "sipQtCoreQMetaObject.cpp"
#line 98 "sip/QtCore/qmetaobject.sip"
#include <qmetaobject.h>
#line 66 "sipQtCoreQMetaObject.cpp"
#line 76 "sip/QtCore/qmetaobject.sip"
#include <qmetaobject.h>
#line 69 "sipQtCoreQMetaObject.cpp"
#line 42 "sip/QtCore/qmetaobject.sip"
#include <qmetaobject.h>
#line 72 "sipQtCoreQMetaObject.cpp"
#line 46 "sip/QtCore/qobjectdefs.sip"
// Raise an exception when QMetaObject::invokeMethod() returns false.
static void qtcore_invokeMethod_exception()
{
    PyErr_SetString(PyExc_RuntimeError, "QMetaObject.invokeMethod() call failed");
}
#line 79 "sipQtCoreQMetaObject.cpp"


extern "C" {static PyObject *meth_QMetaObject_className(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_className(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QMetaObject *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QMetaObject,&sipCpp))
        {
            const char *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->className();
            Py_END_ALLOW_THREADS

            if (sipRes == NULL)
            {
                Py_INCREF(Py_None);
                return Py_None;
            }

            return PyString_FromString(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QMetaObject,sipNm_QtCore_className);

    return NULL;
}


extern "C" {static PyObject *meth_QMetaObject_superClass(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_superClass(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QMetaObject *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QMetaObject,&sipCpp))
        {
            const QMetaObject *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->superClass();
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(const_cast<QMetaObject *>(sipRes),sipClass_QMetaObject,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QMetaObject,sipNm_QtCore_superClass);

    return NULL;
}


extern "C" {static PyObject *meth_QMetaObject_userProperty(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_userProperty(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QMetaObject *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QMetaObject,&sipCpp))
        {
            QMetaProperty *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QMetaProperty(sipCpp->userProperty());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QMetaProperty,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QMetaObject,sipNm_QtCore_userProperty);

    return NULL;
}


extern "C" {static PyObject *meth_QMetaObject_methodOffset(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_methodOffset(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QMetaObject *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QMetaObject,&sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->methodOffset();
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QMetaObject,sipNm_QtCore_methodOffset);

    return NULL;
}


extern "C" {static PyObject *meth_QMetaObject_enumeratorOffset(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_enumeratorOffset(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QMetaObject *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QMetaObject,&sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->enumeratorOffset();
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QMetaObject,sipNm_QtCore_enumeratorOffset);

    return NULL;
}


extern "C" {static PyObject *meth_QMetaObject_propertyOffset(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_propertyOffset(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QMetaObject *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QMetaObject,&sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->propertyOffset();
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QMetaObject,sipNm_QtCore_propertyOffset);

    return NULL;
}


extern "C" {static PyObject *meth_QMetaObject_classInfoOffset(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_classInfoOffset(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QMetaObject *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QMetaObject,&sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->classInfoOffset();
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QMetaObject,sipNm_QtCore_classInfoOffset);

    return NULL;
}


extern "C" {static PyObject *meth_QMetaObject_methodCount(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_methodCount(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QMetaObject *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QMetaObject,&sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->methodCount();
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QMetaObject,sipNm_QtCore_methodCount);

    return NULL;
}


extern "C" {static PyObject *meth_QMetaObject_enumeratorCount(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_enumeratorCount(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QMetaObject *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QMetaObject,&sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->enumeratorCount();
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QMetaObject,sipNm_QtCore_enumeratorCount);

    return NULL;
}


extern "C" {static PyObject *meth_QMetaObject_propertyCount(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_propertyCount(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QMetaObject *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QMetaObject,&sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->propertyCount();
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QMetaObject,sipNm_QtCore_propertyCount);

    return NULL;
}


extern "C" {static PyObject *meth_QMetaObject_classInfoCount(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_classInfoCount(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QMetaObject *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QMetaObject,&sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->classInfoCount();
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QMetaObject,sipNm_QtCore_classInfoCount);

    return NULL;
}


extern "C" {static PyObject *meth_QMetaObject_indexOfMethod(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_indexOfMethod(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const char * a0;
        QMetaObject *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bs",&sipSelf,sipClass_QMetaObject,&sipCpp,&a0))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->indexOfMethod(a0);
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QMetaObject,sipNm_QtCore_indexOfMethod);

    return NULL;
}


extern "C" {static PyObject *meth_QMetaObject_indexOfSignal(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_indexOfSignal(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const char * a0;
        QMetaObject *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bs",&sipSelf,sipClass_QMetaObject,&sipCpp,&a0))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->indexOfSignal(a0);
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QMetaObject,sipNm_QtCore_indexOfSignal);

    return NULL;
}


extern "C" {static PyObject *meth_QMetaObject_indexOfSlot(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_indexOfSlot(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const char * a0;
        QMetaObject *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bs",&sipSelf,sipClass_QMetaObject,&sipCpp,&a0))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->indexOfSlot(a0);
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QMetaObject,sipNm_QtCore_indexOfSlot);

    return NULL;
}


extern "C" {static PyObject *meth_QMetaObject_indexOfEnumerator(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_indexOfEnumerator(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const char * a0;
        QMetaObject *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bs",&sipSelf,sipClass_QMetaObject,&sipCpp,&a0))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->indexOfEnumerator(a0);
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QMetaObject,sipNm_QtCore_indexOfEnumerator);

    return NULL;
}


extern "C" {static PyObject *meth_QMetaObject_indexOfProperty(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_indexOfProperty(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const char * a0;
        QMetaObject *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bs",&sipSelf,sipClass_QMetaObject,&sipCpp,&a0))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->indexOfProperty(a0);
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QMetaObject,sipNm_QtCore_indexOfProperty);

    return NULL;
}


extern "C" {static PyObject *meth_QMetaObject_indexOfClassInfo(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_indexOfClassInfo(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const char * a0;
        QMetaObject *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bs",&sipSelf,sipClass_QMetaObject,&sipCpp,&a0))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->indexOfClassInfo(a0);
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QMetaObject,sipNm_QtCore_indexOfClassInfo);

    return NULL;
}


extern "C" {static PyObject *meth_QMetaObject_method(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_method(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        QMetaObject *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bi",&sipSelf,sipClass_QMetaObject,&sipCpp,&a0))
        {
            QMetaMethod *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QMetaMethod(sipCpp->method(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QMetaMethod,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QMetaObject,sipNm_QtCore_method);

    return NULL;
}


extern "C" {static PyObject *meth_QMetaObject_enumerator(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_enumerator(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        QMetaObject *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bi",&sipSelf,sipClass_QMetaObject,&sipCpp,&a0))
        {
            QMetaEnum *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QMetaEnum(sipCpp->enumerator(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QMetaEnum,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QMetaObject,sipNm_QtCore_enumerator);

    return NULL;
}


extern "C" {static PyObject *meth_QMetaObject_property(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_property(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        QMetaObject *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bi",&sipSelf,sipClass_QMetaObject,&sipCpp,&a0))
        {
            QMetaProperty *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QMetaProperty(sipCpp->property(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QMetaProperty,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QMetaObject,sipNm_QtCore_property);

    return NULL;
}


extern "C" {static PyObject *meth_QMetaObject_classInfo(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_classInfo(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        QMetaObject *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bi",&sipSelf,sipClass_QMetaObject,&sipCpp,&a0))
        {
            QMetaClassInfo *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QMetaClassInfo(sipCpp->classInfo(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QMetaClassInfo,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QMetaObject,sipNm_QtCore_classInfo);

    return NULL;
}


extern "C" {static PyObject *meth_QMetaObject_checkConnectArgs(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_checkConnectArgs(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const char * a0;
        const char * a1;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"ss",&a0,&a1))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = QMetaObject::checkConnectArgs(a0,a1);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QMetaObject,sipNm_QtCore_checkConnectArgs);

    return NULL;
}


extern "C" {static PyObject *meth_QMetaObject_connectSlotsByName(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_connectSlotsByName(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QObject * a0;
        PyObject *a0Wrapper;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"JH",sipClass_QObject,&a0,&a0Wrapper))
        {
#line 79 "sip/QtCore/qobjectdefs.sip"
        // Get the class attributes.
        PyObject *dir = PyObject_Dir((PyObject *)a0Wrapper->ob_type);
        
        if (dir)
        {
            PyObject *slot_obj = 0;
        
            for (SIP_SSIZE_T li = 0; li < PyList_GET_SIZE(dir); ++li)
            {
                PyObject *name_obj = PyList_GET_ITEM(dir, li);
                const char *name = PyString_AsString(name_obj);
        
                if (!name)
                    continue;
        
                // Get the slot object.
                Py_XDECREF(slot_obj);
                slot_obj = PyObject_GetAttr(a0Wrapper, name_obj);
        
                if (!slot_obj)
                    continue;
        
                // Ignore it if it is not a callable.
                if (!PyCallable_Check(slot_obj))
                    continue;
        
                // Use the signature attribute instead of the name if there is one.
                PyObject *sigattr = PyObject_GetAttr(slot_obj, qtcore_signature_attr);
                QByteArray slot_nm, args;
        
                if (sigattr)
                {
                    QByteArray &sn = reinterpret_cast<qtcore_SignatureArgs *>(PyCObject_AsVoidPtr(sigattr))->first;
        
                    // Find (and sanity check) the arguments.
                    int oparen = sn.indexOf('(');
                    int cparen = sn.lastIndexOf(')');
        
                    if (oparen >= 0 && cparen >= 0)
                    {
                        slot_nm = sn.left(oparen);
                        args = sn.mid(oparen + 1, cparen - (oparen + 1));
                    }
        
                    Py_DECREF(sigattr);
                }
                else
                {
                    PyErr_Clear();
                    slot_nm = name;
                }
        
                // Ignore if it's not an autoconnect slot.
                if (!slot_nm.startsWith("on_"))
                    continue;
        
                // Extract the names of the emitting object and the signal.
                int i;
        
                i = slot_nm.lastIndexOf('_');
        
                if (i - 3 < 1 || i + 1 >= slot_nm.size())
                    continue;
        
                QByteArray ename = slot_nm.mid(3, i - 3);
                QByteArray sname = slot_nm.mid(i + 1);
        
                // Find the emitting object and get its meta-object.
        #if defined(QT_NO_MEMBER_TEMPLATES)
                QObject *eobj = qFindChild<QObject *>(a0, ename);
        #else
                QObject *eobj = a0->findChild<QObject *>(ename);
        #endif
        
                if (!eobj)
                    continue;
        
                const QMetaObject *mo = eobj->metaObject();
        
                // Got through the methods looking for a matching signal.
                PyObject *epyobj = 0;
        
                for (int m = 0; m < mo->methodCount(); ++m)
                {
                    QMetaMethod mm = mo->method(m);
        
                    if (mm.methodType() != QMetaMethod::Signal)
                        continue;
        
                    // Get the signal name without arguments.
                    QByteArray sig(mm.signature());
                    int argstart = sig.indexOf('(');
                    QByteArray signoargs = sig.left(argstart);
        
                    if (signoargs != sname)
                        continue;
        
                    ++argstart;
        
                    // If we have slot arguments then they must match as well.
                    if (!args.isNull() && sig.mid(argstart, sig.lastIndexOf(')') - argstart) != args)
                        continue;
        
                    // Add the type character.
                    sig.prepend('2');
        
                    // Get the wrapper now we know it is needed.
                    if (!epyobj)
                    {
                        epyobj = sipConvertFromInstance(eobj, sipClass_QObject, 0);
        
                        if (!epyobj)
                            break;
                    }
        
                    // Connect the signal.
                    sipConnectRx(epyobj, sig, slot_obj, 0, 0);
                }
        
                Py_XDECREF(epyobj);
            }
        
            Py_XDECREF(slot_obj);
            Py_DECREF(dir);
        }
#line 830 "sipQtCoreQMetaObject.cpp"

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QMetaObject,sipNm_QtCore_connectSlotsByName);

    return NULL;
}


extern "C" {static PyObject *meth_QMetaObject_normalizedSignature(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_normalizedSignature(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const char * a0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"s",&a0))
        {
            QByteArray *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QByteArray(QMetaObject::normalizedSignature(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QByteArray,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QMetaObject,sipNm_QtCore_normalizedSignature);

    return NULL;
}


extern "C" {static PyObject *meth_QMetaObject_normalizedType(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_normalizedType(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const char * a0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"s",&a0))
        {
            QByteArray *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QByteArray(QMetaObject::normalizedType(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QByteArray,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QMetaObject,sipNm_QtCore_normalizedType);

    return NULL;
}


extern "C" {static PyObject *meth_QMetaObject_invokeMethod(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_invokeMethod(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QObject * a0;
        const char * a1;
        Qt::ConnectionType a2;
        QGenericReturnArgument * a3;
        PyObject *a3Wrapper;
        QGenericArgument a4def = QGenericArgument(0,0);
        QGenericArgument * a4 = &a4def;
        QGenericArgument a5def = QGenericArgument(0,0);
        QGenericArgument * a5 = &a5def;
        QGenericArgument a6def = QGenericArgument(0,0);
        QGenericArgument * a6 = &a6def;
        QGenericArgument a7def = QGenericArgument(0,0);
        QGenericArgument * a7 = &a7def;
        QGenericArgument a8def = QGenericArgument(0,0);
        QGenericArgument * a8 = &a8def;
        QGenericArgument a9def = QGenericArgument(0,0);
        QGenericArgument * a9 = &a9def;
        QGenericArgument a10def = QGenericArgument(0,0);
        QGenericArgument * a10 = &a10def;
        QGenericArgument a11def = QGenericArgument(0,0);
        QGenericArgument * a11 = &a11def;
        QGenericArgument a12def = QGenericArgument(0,0);
        QGenericArgument * a12 = &a12def;
        QGenericArgument a13def = QGenericArgument(0,0);
        QGenericArgument * a13 = &a13def;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"J@sEJI|JAJAJAJAJAJAJAJAJAJA",sipClass_QObject,&a0,&a1,sipEnum_Qt_ConnectionType,&a2,sipClass_QGenericReturnArgument,&a3,&a3Wrapper,sipClass_QGenericArgument,&a4,sipClass_QGenericArgument,&a5,sipClass_QGenericArgument,&a6,sipClass_QGenericArgument,&a7,sipClass_QGenericArgument,&a8,sipClass_QGenericArgument,&a9,sipClass_QGenericArgument,&a10,sipClass_QGenericArgument,&a11,sipClass_QGenericArgument,&a12,sipClass_QGenericArgument,&a13))
        {
            PyObject * sipRes = 0;

#line 212 "sip/QtCore/qobjectdefs.sip"
        // Raise an exception if the call failed.
        bool ok;
        
        Py_BEGIN_ALLOW_THREADS
        ok = QMetaObject::invokeMethod(a0,a1,a2,*a3,*a4,*a5,*a6,*a7,*a8,*a9,*a10,*a11,*a12,*a13);
        Py_END_ALLOW_THREADS
        
        if (ok)
            sipRes = qtcore_ReturnValue(a3Wrapper);
        else
            qtcore_invokeMethod_exception();
#line 946 "sipQtCoreQMetaObject.cpp"

            return sipRes;
        }
    }

    {
        QObject * a0;
        const char * a1;
        QGenericReturnArgument * a2;
        PyObject *a2Wrapper;
        QGenericArgument a3def = QGenericArgument(0,0);
        QGenericArgument * a3 = &a3def;
        QGenericArgument a4def = QGenericArgument(0,0);
        QGenericArgument * a4 = &a4def;
        QGenericArgument a5def = QGenericArgument(0,0);
        QGenericArgument * a5 = &a5def;
        QGenericArgument a6def = QGenericArgument(0,0);
        QGenericArgument * a6 = &a6def;
        QGenericArgument a7def = QGenericArgument(0,0);
        QGenericArgument * a7 = &a7def;
        QGenericArgument a8def = QGenericArgument(0,0);
        QGenericArgument * a8 = &a8def;
        QGenericArgument a9def = QGenericArgument(0,0);
        QGenericArgument * a9 = &a9def;
        QGenericArgument a10def = QGenericArgument(0,0);
        QGenericArgument * a10 = &a10def;
        QGenericArgument a11def = QGenericArgument(0,0);
        QGenericArgument * a11 = &a11def;
        QGenericArgument a12def = QGenericArgument(0,0);
        QGenericArgument * a12 = &a12def;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"J@sJI|JAJAJAJAJAJAJAJAJAJA",sipClass_QObject,&a0,&a1,sipClass_QGenericReturnArgument,&a2,&a2Wrapper,sipClass_QGenericArgument,&a3,sipClass_QGenericArgument,&a4,sipClass_QGenericArgument,&a5,sipClass_QGenericArgument,&a6,sipClass_QGenericArgument,&a7,sipClass_QGenericArgument,&a8,sipClass_QGenericArgument,&a9,sipClass_QGenericArgument,&a10,sipClass_QGenericArgument,&a11,sipClass_QGenericArgument,&a12))
        {
            PyObject * sipRes = 0;

#line 227 "sip/QtCore/qobjectdefs.sip"
        // Raise an exception if the call failed.
        bool ok;
        
        Py_BEGIN_ALLOW_THREADS
        ok = QMetaObject::invokeMethod(a0,a1,*a2,*a3,*a4,*a5,*a6,*a7,*a8,*a9,*a10,*a11,*a12);
        Py_END_ALLOW_THREADS
        
        if (ok)
            sipRes = qtcore_ReturnValue(a2Wrapper);
        else
            qtcore_invokeMethod_exception();
#line 994 "sipQtCoreQMetaObject.cpp"

            return sipRes;
        }
    }

    {
        QObject * a0;
        const char * a1;
        Qt::ConnectionType a2;
        QGenericArgument a3def = QGenericArgument(0,0);
        QGenericArgument * a3 = &a3def;
        QGenericArgument a4def = QGenericArgument(0,0);
        QGenericArgument * a4 = &a4def;
        QGenericArgument a5def = QGenericArgument(0,0);
        QGenericArgument * a5 = &a5def;
        QGenericArgument a6def = QGenericArgument(0,0);
        QGenericArgument * a6 = &a6def;
        QGenericArgument a7def = QGenericArgument(0,0);
        QGenericArgument * a7 = &a7def;
        QGenericArgument a8def = QGenericArgument(0,0);
        QGenericArgument * a8 = &a8def;
        QGenericArgument a9def = QGenericArgument(0,0);
        QGenericArgument * a9 = &a9def;
        QGenericArgument a10def = QGenericArgument(0,0);
        QGenericArgument * a10 = &a10def;
        QGenericArgument a11def = QGenericArgument(0,0);
        QGenericArgument * a11 = &a11def;
        QGenericArgument a12def = QGenericArgument(0,0);
        QGenericArgument * a12 = &a12def;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"J@sE|JAJAJAJAJAJAJAJAJAJA",sipClass_QObject,&a0,&a1,sipEnum_Qt_ConnectionType,&a2,sipClass_QGenericArgument,&a3,sipClass_QGenericArgument,&a4,sipClass_QGenericArgument,&a5,sipClass_QGenericArgument,&a6,sipClass_QGenericArgument,&a7,sipClass_QGenericArgument,&a8,sipClass_QGenericArgument,&a9,sipClass_QGenericArgument,&a10,sipClass_QGenericArgument,&a11,sipClass_QGenericArgument,&a12))
        {
            PyObject * sipRes = 0;

#line 242 "sip/QtCore/qobjectdefs.sip"
        // Raise an exception if the call failed.
        bool ok;
        
        Py_BEGIN_ALLOW_THREADS
        ok = QMetaObject::invokeMethod(a0,a1,a2,*a3,*a4,*a5,*a6,*a7,*a8,*a9,*a10,*a11,*a12);
        Py_END_ALLOW_THREADS
        
        if (ok)
        {
            Py_INCREF(Py_None);
            sipRes = Py_None;
        }
        else
            qtcore_invokeMethod_exception();
#line 1044 "sipQtCoreQMetaObject.cpp"

            return sipRes;
        }
    }

    {
        QObject * a0;
        const char * a1;
        QGenericArgument a2def = QGenericArgument(0,0);
        QGenericArgument * a2 = &a2def;
        QGenericArgument a3def = QGenericArgument(0,0);
        QGenericArgument * a3 = &a3def;
        QGenericArgument a4def = QGenericArgument(0,0);
        QGenericArgument * a4 = &a4def;
        QGenericArgument a5def = QGenericArgument(0,0);
        QGenericArgument * a5 = &a5def;
        QGenericArgument a6def = QGenericArgument(0,0);
        QGenericArgument * a6 = &a6def;
        QGenericArgument a7def = QGenericArgument(0,0);
        QGenericArgument * a7 = &a7def;
        QGenericArgument a8def = QGenericArgument(0,0);
        QGenericArgument * a8 = &a8def;
        QGenericArgument a9def = QGenericArgument(0,0);
        QGenericArgument * a9 = &a9def;
        QGenericArgument a10def = QGenericArgument(0,0);
        QGenericArgument * a10 = &a10def;
        QGenericArgument a11def = QGenericArgument(0,0);
        QGenericArgument * a11 = &a11def;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"J@s|JAJAJAJAJAJAJAJAJAJA",sipClass_QObject,&a0,&a1,sipClass_QGenericArgument,&a2,sipClass_QGenericArgument,&a3,sipClass_QGenericArgument,&a4,sipClass_QGenericArgument,&a5,sipClass_QGenericArgument,&a6,sipClass_QGenericArgument,&a7,sipClass_QGenericArgument,&a8,sipClass_QGenericArgument,&a9,sipClass_QGenericArgument,&a10,sipClass_QGenericArgument,&a11))
        {
            PyObject * sipRes = 0;

#line 260 "sip/QtCore/qobjectdefs.sip"
        // Raise an exception if the call failed.
        bool ok;
        
        Py_BEGIN_ALLOW_THREADS
        ok = QMetaObject::invokeMethod(a0,a1,*a2,*a3,*a4,*a5,*a6,*a7,*a8,*a9,*a10,*a11);
        Py_END_ALLOW_THREADS
        
        if (ok)
        {
            Py_INCREF(Py_None);
            sipRes = Py_None;
        }
        else
            qtcore_invokeMethod_exception();
#line 1093 "sipQtCoreQMetaObject.cpp"

            return sipRes;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QMetaObject,sipNm_QtCore_invokeMethod);

    return NULL;
}


/* Cast a pointer to a type somewhere in its superclass hierarchy. */
extern "C" {static void *cast_QMetaObject(void *, sipWrapperType *);}
static void *cast_QMetaObject(void *ptr,sipWrapperType *targetClass)
{
    if (targetClass == sipClass_QMetaObject)
        return ptr;

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_QMetaObject(void *, int);}
static void release_QMetaObject(void *sipCppV,int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast<QMetaObject *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_QMetaObject(void *, const void*);}
static void assign_QMetaObject(void *sipDst, const void *sipSrc)
{
    *reinterpret_cast<QMetaObject *>(sipDst) = *reinterpret_cast<const QMetaObject *>(sipSrc);
}


extern "C" {static void dealloc_QMetaObject(sipWrapper *);}
static void dealloc_QMetaObject(sipWrapper *sipSelf)
{
    if (sipIsPyOwned(sipSelf))
    {
        release_QMetaObject(sipSelf->u.cppPtr,0);
    }
}


extern "C" {static void *init_QMetaObject(sipWrapper *, PyObject *, sipWrapper **, int *);}
static void *init_QMetaObject(sipWrapper *,PyObject *sipArgs,sipWrapper **,int *sipArgsParsed)
{
    QMetaObject *sipCpp = 0;

    if (!sipCpp)
    {
        if (sipParseArgs(sipArgsParsed,sipArgs,""))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QMetaObject();
            Py_END_ALLOW_THREADS
        }
    }

    if (!sipCpp)
    {
        const QMetaObject * a0;

        if (sipParseArgs(sipArgsParsed,sipArgs,"JA",sipClass_QMetaObject,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QMetaObject(*a0);
            Py_END_ALLOW_THREADS
        }
    }

    return sipCpp;
}


extern "C" {static void *forceConvertTo_QMetaObject(PyObject *, int *);}
static void *forceConvertTo_QMetaObject(PyObject *valobj,int *iserrp)
{
    if (*iserrp || valobj == NULL)
        return NULL;

    if (valobj == Py_None || sipIsSubClassInstance(valobj,sipClass_QMetaObject))
        return sipConvertToCpp(valobj,sipClass_QMetaObject,iserrp);

    sipBadClass(sipNm_QtCore_QMetaObject);

    *iserrp = 1;

    return NULL;
}


static PyMethodDef methods_QMetaObject[] = {
    {sipNm_QtCore_checkConnectArgs, meth_QMetaObject_checkConnectArgs, METH_VARARGS, NULL},
    {sipNm_QtCore_classInfo, meth_QMetaObject_classInfo, METH_VARARGS, NULL},
    {sipNm_QtCore_classInfoCount, meth_QMetaObject_classInfoCount, METH_VARARGS, NULL},
    {sipNm_QtCore_classInfoOffset, meth_QMetaObject_classInfoOffset, METH_VARARGS, NULL},
    {sipNm_QtCore_className, meth_QMetaObject_className, METH_VARARGS, NULL},
    {sipNm_QtCore_connectSlotsByName, meth_QMetaObject_connectSlotsByName, METH_VARARGS, NULL},
    {sipNm_QtCore_enumerator, meth_QMetaObject_enumerator, METH_VARARGS, NULL},
    {sipNm_QtCore_enumeratorCount, meth_QMetaObject_enumeratorCount, METH_VARARGS, NULL},
    {sipNm_QtCore_enumeratorOffset, meth_QMetaObject_enumeratorOffset, METH_VARARGS, NULL},
    {sipNm_QtCore_indexOfClassInfo, meth_QMetaObject_indexOfClassInfo, METH_VARARGS, NULL},
    {sipNm_QtCore_indexOfEnumerator, meth_QMetaObject_indexOfEnumerator, METH_VARARGS, NULL},
    {sipNm_QtCore_indexOfMethod, meth_QMetaObject_indexOfMethod, METH_VARARGS, NULL},
    {sipNm_QtCore_indexOfProperty, meth_QMetaObject_indexOfProperty, METH_VARARGS, NULL},
    {sipNm_QtCore_indexOfSignal, meth_QMetaObject_indexOfSignal, METH_VARARGS, NULL},
    {sipNm_QtCore_indexOfSlot, meth_QMetaObject_indexOfSlot, METH_VARARGS, NULL},
    {sipNm_QtCore_invokeMethod, meth_QMetaObject_invokeMethod, METH_VARARGS, NULL},
    {sipNm_QtCore_method, meth_QMetaObject_method, METH_VARARGS, NULL},
    {sipNm_QtCore_methodCount, meth_QMetaObject_methodCount, METH_VARARGS, NULL},
    {sipNm_QtCore_methodOffset, meth_QMetaObject_methodOffset, METH_VARARGS, NULL},
    {sipNm_QtCore_normalizedSignature, meth_QMetaObject_normalizedSignature, METH_VARARGS, NULL},
    {sipNm_QtCore_normalizedType, meth_QMetaObject_normalizedType, METH_VARARGS, NULL},
    {sipNm_QtCore_property, meth_QMetaObject_property, METH_VARARGS, NULL},
    {sipNm_QtCore_propertyCount, meth_QMetaObject_propertyCount, METH_VARARGS, NULL},
    {sipNm_QtCore_propertyOffset, meth_QMetaObject_propertyOffset, METH_VARARGS, NULL},
    {sipNm_QtCore_superClass, meth_QMetaObject_superClass, METH_VARARGS, NULL},
    {sipNm_QtCore_userProperty, meth_QMetaObject_userProperty, METH_VARARGS, NULL}
};


sipTypeDef sipType_QtCore_QMetaObject = {
    0,
    0,
    "QtCore.QMetaObject",
    0,
    {0, 0, 1},
    0,
    0,
    26, methods_QMetaObject,
    0, 0,
    0,
    init_QMetaObject,
    0,
    0,
    0,
    0,
    0,
    0,
    dealloc_QMetaObject,
    cast_QMetaObject,
    release_QMetaObject,
    forceConvertTo_QMetaObject,
    0,
    0,
    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    0,
    0,
    assign_QMetaObject,
    0
};
