/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.7.7 on Tue Nov  3 22:16:49 2009
 *
 * Copyright (c) 2008 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt.
 * 
 * This file may be used under the terms of the GNU General Public
 * License versions 2.0 or 3.0 as published by the Free Software
 * Foundation and appearing in the files LICENSE.GPL2 and LICENSE.GPL3
 * included in the packaging of this file.  Alternatively you may (at
 * your option) use any later version of the GNU General Public
 * License if such license has been publicly approved by Riverbank
 * Computing Limited (or its successors, if any) and the KDE Free Qt
 * Foundation. In addition, as a special exception, Riverbank gives you
 * certain additional rights. These rights are described in the Riverbank
 * GPL Exception version 1.1, which can be found in the file
 * GPL_EXCEPTION.txt in this package.
 * 
 * Please review the following information to ensure GNU General
 * Public Licensing requirements will be met:
 * http://trolltech.com/products/qt/licenses/licensing/opensource/. If
 * you are unsure which license is appropriate for your use, please
 * review the following information:
 * http://trolltech.com/products/qt/licenses/licensing/licensingoverview
 * or contact the sales department at sales@riverbankcomputing.com.
 * 
 * This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
 * INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE. Trolltech reserves all rights not expressly
 * granted herein.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 46 "sip/QtCore/qdatetime.sip"
#include <qdatetime.h>
#line 44 "sipQtCoreQDate.cpp"

#line 46 "sip/QtCore/qstring.sip"
#include <qstring.h>
#line 48 "sipQtCoreQDate.cpp"
#line 45 "sip/QtCore/qnamespace.sip"
#include <qnamespace.h>
#line 51 "sipQtCoreQDate.cpp"
#line 50 "sip/QtCore/qdatetime.sip"
#if PY_VERSION_HEX >= 0x02040000
#include <datetime.h>
#endif
#line 56 "sipQtCoreQDate.cpp"


extern "C" {static PyObject *meth_QDate_toPyDate(PyObject *, PyObject *);}
static PyObject *meth_QDate_toPyDate(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QDate *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QDate,&sipCpp))
        {
            PyObject * sipRes = 0;

#line 102 "sip/QtCore/qdatetime.sip"
        if (!PyDateTimeAPI)
            PyDateTime_IMPORT;
        
        // Convert to a Python date object.
        sipRes = PyDate_FromDate(sipCpp->year(), sipCpp->month(), sipCpp->day());
#line 77 "sipQtCoreQDate.cpp"

            return sipRes;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDate,sipNm_QtCore_toPyDate);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_isNull(PyObject *, PyObject *);}
static PyObject *meth_QDate_isNull(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QDate *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QDate,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isNull();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDate,sipNm_QtCore_isNull);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_isValid(PyObject *, PyObject *);}
static PyObject *meth_QDate_isValid(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QDate *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QDate,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isValid();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    {
        int a0;
        int a1;
        int a2;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"iii",&a0,&a1,&a2))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = QDate::isValid(a0,a1,a2);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDate,sipNm_QtCore_isValid);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_year(PyObject *, PyObject *);}
static PyObject *meth_QDate_year(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QDate *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QDate,&sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->year();
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDate,sipNm_QtCore_year);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_month(PyObject *, PyObject *);}
static PyObject *meth_QDate_month(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QDate *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QDate,&sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->month();
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDate,sipNm_QtCore_month);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_day(PyObject *, PyObject *);}
static PyObject *meth_QDate_day(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QDate *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QDate,&sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->day();
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDate,sipNm_QtCore_day);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_dayOfWeek(PyObject *, PyObject *);}
static PyObject *meth_QDate_dayOfWeek(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QDate *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QDate,&sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->dayOfWeek();
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDate,sipNm_QtCore_dayOfWeek);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_dayOfYear(PyObject *, PyObject *);}
static PyObject *meth_QDate_dayOfYear(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QDate *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QDate,&sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->dayOfYear();
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDate,sipNm_QtCore_dayOfYear);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_daysInMonth(PyObject *, PyObject *);}
static PyObject *meth_QDate_daysInMonth(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QDate *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QDate,&sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->daysInMonth();
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDate,sipNm_QtCore_daysInMonth);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_daysInYear(PyObject *, PyObject *);}
static PyObject *meth_QDate_daysInYear(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QDate *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QDate,&sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->daysInYear();
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDate,sipNm_QtCore_daysInYear);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_weekNumber(PyObject *, PyObject *);}
static PyObject *meth_QDate_weekNumber(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        QDate *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QDate,&sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->weekNumber(&a0);
            Py_END_ALLOW_THREADS

            return sipBuildResult(0,"(ii)",sipRes,a0);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDate,sipNm_QtCore_weekNumber);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_shortMonthName(PyObject *, PyObject *);}
static PyObject *meth_QDate_shortMonthName(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"i",&a0))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(QDate::shortMonthName(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDate,sipNm_QtCore_shortMonthName);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_shortDayName(PyObject *, PyObject *);}
static PyObject *meth_QDate_shortDayName(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"i",&a0))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(QDate::shortDayName(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDate,sipNm_QtCore_shortDayName);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_longMonthName(PyObject *, PyObject *);}
static PyObject *meth_QDate_longMonthName(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"i",&a0))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(QDate::longMonthName(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDate,sipNm_QtCore_longMonthName);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_longDayName(PyObject *, PyObject *);}
static PyObject *meth_QDate_longDayName(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"i",&a0))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(QDate::longDayName(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDate,sipNm_QtCore_longDayName);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_toString(PyObject *, PyObject *);}
static PyObject *meth_QDate_toString(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        Qt::DateFormat a0 = Qt::TextDate;
        QDate *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B|E",&sipSelf,sipClass_QDate,&sipCpp,sipEnum_Qt_DateFormat,&a0))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->toString(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    {
        const QString * a0;
        int a0State = 0;
        QDate *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJ1",&sipSelf,sipClass_QDate,&sipCpp,sipClass_QString,&a0,&a0State))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->toString(*a0));
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDate,sipNm_QtCore_toString);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_setYMD(PyObject *, PyObject *);}
static PyObject *meth_QDate_setYMD(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        int a1;
        int a2;
        QDate *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Biii",&sipSelf,sipClass_QDate,&sipCpp,&a0,&a1,&a2))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->setYMD(a0,a1,a2);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDate,sipNm_QtCore_setYMD);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_addDays(PyObject *, PyObject *);}
static PyObject *meth_QDate_addDays(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        QDate *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bi",&sipSelf,sipClass_QDate,&sipCpp,&a0))
        {
            QDate *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDate(sipCpp->addDays(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QDate,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDate,sipNm_QtCore_addDays);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_addMonths(PyObject *, PyObject *);}
static PyObject *meth_QDate_addMonths(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        QDate *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bi",&sipSelf,sipClass_QDate,&sipCpp,&a0))
        {
            QDate *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDate(sipCpp->addMonths(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QDate,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDate,sipNm_QtCore_addMonths);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_addYears(PyObject *, PyObject *);}
static PyObject *meth_QDate_addYears(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        QDate *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bi",&sipSelf,sipClass_QDate,&sipCpp,&a0))
        {
            QDate *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDate(sipCpp->addYears(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QDate,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDate,sipNm_QtCore_addYears);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_daysTo(PyObject *, PyObject *);}
static PyObject *meth_QDate_daysTo(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QDate * a0;
        int a0State = 0;
        QDate *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJ1",&sipSelf,sipClass_QDate,&sipCpp,sipClass_QDate,&a0,&a0State))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->daysTo(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QDate *>(a0),sipClass_QDate,a0State);

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDate,sipNm_QtCore_daysTo);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_currentDate(PyObject *, PyObject *);}
static PyObject *meth_QDate_currentDate(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        if (sipParseArgs(&sipArgsParsed,sipArgs,""))
        {
            QDate *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDate(QDate::currentDate());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QDate,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDate,sipNm_QtCore_currentDate);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_fromString(PyObject *, PyObject *);}
static PyObject *meth_QDate_fromString(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QString * a0;
        int a0State = 0;
        Qt::DateFormat a1 = Qt::TextDate;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"J1|E",sipClass_QString,&a0,&a0State,sipEnum_Qt_DateFormat,&a1))
        {
            QDate *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDate(QDate::fromString(*a0,a1));
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            return sipConvertFromNewInstance(sipRes,sipClass_QDate,NULL);
        }
    }

    {
        const QString * a0;
        int a0State = 0;
        const QString * a1;
        int a1State = 0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"J1J1",sipClass_QString,&a0,&a0State,sipClass_QString,&a1,&a1State))
        {
            QDate *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDate(QDate::fromString(*a0,*a1));
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);
            sipReleaseInstance(const_cast<QString *>(a1),sipClass_QString,a1State);

            return sipConvertFromNewInstance(sipRes,sipClass_QDate,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDate,sipNm_QtCore_fromString);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_isLeapYear(PyObject *, PyObject *);}
static PyObject *meth_QDate_isLeapYear(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"i",&a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = QDate::isLeapYear(a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDate,sipNm_QtCore_isLeapYear);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_gregorianToJulian(PyObject *, PyObject *);}
static PyObject *meth_QDate_gregorianToJulian(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        int a1;
        int a2;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"iii",&a0,&a1,&a2))
        {
            unsigned sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = QDate::gregorianToJulian(a0,a1,a2);
            Py_END_ALLOW_THREADS

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDate,sipNm_QtCore_gregorianToJulian);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_julianToGregorian(PyObject *, PyObject *);}
static PyObject *meth_QDate_julianToGregorian(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        unsigned a0;
        int a1;
        int a2;
        int a3;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"u",&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            QDate::julianToGregorian(a0,a1,a2,a3);
            Py_END_ALLOW_THREADS

            return sipBuildResult(0,"(iii)",a1,a2,a3);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDate,sipNm_QtCore_julianToGregorian);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_fromJulianDay(PyObject *, PyObject *);}
static PyObject *meth_QDate_fromJulianDay(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"i",&a0))
        {
            QDate *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDate(QDate::fromJulianDay(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QDate,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDate,sipNm_QtCore_fromJulianDay);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_toJulianDay(PyObject *, PyObject *);}
static PyObject *meth_QDate_toJulianDay(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QDate *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QDate,&sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->toJulianDay();
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDate,sipNm_QtCore_toJulianDay);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_setDate(PyObject *, PyObject *);}
static PyObject *meth_QDate_setDate(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        int a1;
        int a2;
        QDate *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Biii",&sipSelf,sipClass_QDate,&sipCpp,&a0,&a1,&a2))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->setDate(a0,a1,a2);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDate,sipNm_QtCore_setDate);

    return NULL;
}


extern "C" {static PyObject *slot_QDate___ge__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QDate___ge__(PyObject *sipSelf,PyObject *sipArg)
{
    QDate *sipCpp = reinterpret_cast<QDate *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QDate));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QDate * a0;
        int a0State = 0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1J1",sipClass_QDate,&a0,&a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QDate::operator>=(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QDate *>(a0),sipClass_QDate,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,ge_slot,sipClass_QDate,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QDate___gt__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QDate___gt__(PyObject *sipSelf,PyObject *sipArg)
{
    QDate *sipCpp = reinterpret_cast<QDate *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QDate));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QDate * a0;
        int a0State = 0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1J1",sipClass_QDate,&a0,&a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QDate::operator>(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QDate *>(a0),sipClass_QDate,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,gt_slot,sipClass_QDate,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QDate___le__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QDate___le__(PyObject *sipSelf,PyObject *sipArg)
{
    QDate *sipCpp = reinterpret_cast<QDate *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QDate));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QDate * a0;
        int a0State = 0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1J1",sipClass_QDate,&a0,&a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QDate::operator<=(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QDate *>(a0),sipClass_QDate,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,le_slot,sipClass_QDate,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QDate___lt__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QDate___lt__(PyObject *sipSelf,PyObject *sipArg)
{
    QDate *sipCpp = reinterpret_cast<QDate *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QDate));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QDate * a0;
        int a0State = 0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1J1",sipClass_QDate,&a0,&a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QDate::operator<(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QDate *>(a0),sipClass_QDate,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,lt_slot,sipClass_QDate,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QDate___ne__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QDate___ne__(PyObject *sipSelf,PyObject *sipArg)
{
    QDate *sipCpp = reinterpret_cast<QDate *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QDate));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QDate * a0;
        int a0State = 0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1J1",sipClass_QDate,&a0,&a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QDate::operator!=(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QDate *>(a0),sipClass_QDate,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,ne_slot,sipClass_QDate,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QDate___eq__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QDate___eq__(PyObject *sipSelf,PyObject *sipArg)
{
    QDate *sipCpp = reinterpret_cast<QDate *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QDate));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QDate * a0;
        int a0State = 0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1J1",sipClass_QDate,&a0,&a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QDate::operator==(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QDate *>(a0),sipClass_QDate,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,eq_slot,sipClass_QDate,sipSelf,sipArg);
}


extern "C" {static int slot_QDate___nonzero__(PyObject *sipSelf);}
static int slot_QDate___nonzero__(PyObject *sipSelf)
{
    QDate *sipCpp = reinterpret_cast<QDate *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QDate));

    if (!sipCpp)
        return -1;


    {
        {
            int sipRes = 0;

#line 113 "sip/QtCore/qdatetime.sip"
        sipRes = !sipCpp->isNull();
#line 1130 "sipQtCoreQDate.cpp"

            return sipRes;
        }
    }
}


extern "C" {static PyObject *slot_QDate___repr__(PyObject *sipSelf);}
static PyObject *slot_QDate___repr__(PyObject *sipSelf)
{
    QDate *sipCpp = reinterpret_cast<QDate *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QDate));

    if (!sipCpp)
        return 0;


    {
        {
            PyObject * sipRes = 0;

#line 95 "sip/QtCore/qdatetime.sip"
        sipRes = PyString_FromFormat("PyQt4.QtCore.QDate(%i, %i, %i)", sipCpp->year(),
                sipCpp->month(), sipCpp->day());
#line 1154 "sipQtCoreQDate.cpp"

            return sipRes;
        }
    }
}


/* Cast a pointer to a type somewhere in its superclass hierarchy. */
extern "C" {static void *cast_QDate(void *, sipWrapperType *);}
static void *cast_QDate(void *ptr,sipWrapperType *targetClass)
{
    if (targetClass == sipClass_QDate)
        return ptr;

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_QDate(void *, int);}
static void release_QDate(void *sipCppV,int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast<QDate *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static PyObject *pickle_QDate(void *);}
static PyObject *pickle_QDate(void *sipCppV)
{
    QDate *sipCpp = reinterpret_cast<QDate *>(sipCppV);
    PyObject *sipRes;

#line 87 "sip/QtCore/qdatetime.sip"
    sipRes = Py_BuildValue((char *)"iii", sipCpp->year(), sipCpp->month(), sipCpp->day());
#line 1193 "sipQtCoreQDate.cpp"

    return sipRes;
}


extern "C" {static void assign_QDate(void *, const void*);}
static void assign_QDate(void *sipDst, const void *sipSrc)
{
    *reinterpret_cast<QDate *>(sipDst) = *reinterpret_cast<const QDate *>(sipSrc);
}


extern "C" {static void dealloc_QDate(sipWrapper *);}
static void dealloc_QDate(sipWrapper *sipSelf)
{
    if (sipIsPyOwned(sipSelf))
    {
        release_QDate(sipSelf->u.cppPtr,0);
    }
}


extern "C" {static void *init_QDate(sipWrapper *, PyObject *, sipWrapper **, int *);}
static void *init_QDate(sipWrapper *,PyObject *sipArgs,sipWrapper **,int *sipArgsParsed)
{
    QDate *sipCpp = 0;

    if (!sipCpp)
    {
        if (sipParseArgs(sipArgsParsed,sipArgs,""))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QDate();
            Py_END_ALLOW_THREADS
        }
    }

    if (!sipCpp)
    {
        int a0;
        int a1;
        int a2;

        if (sipParseArgs(sipArgsParsed,sipArgs,"iii",&a0,&a1,&a2))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QDate(a0,a1,a2);
            Py_END_ALLOW_THREADS
        }
    }

    if (!sipCpp)
    {
        const QDate * a0;
        int a0State = 0;

        if (sipParseArgs(sipArgsParsed,sipArgs,"J1",sipClass_QDate,&a0,&a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QDate(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QDate *>(a0),sipClass_QDate,a0State);
        }
    }

    return sipCpp;
}


extern "C" {static int convertTo_QDate(PyObject *, void **, int *, PyObject *);}
static int convertTo_QDate(PyObject *sipPy,void **sipCppPtrV,int *sipIsErr,PyObject *sipTransferObj)
{
    QDate **sipCppPtr = reinterpret_cast<QDate **>(sipCppPtrV);

#line 56 "sip/QtCore/qdatetime.sip"
#if PY_VERSION_HEX >= 0x02040000
    if (!PyDateTimeAPI)
        PyDateTime_IMPORT;
#endif

// Allow a Python date object whenever a QDate is expected.

if (sipIsErr == NULL)
    return (
#if PY_VERSION_HEX >= 0x02040000
            PyDate_Check(sipPy) ||
#endif
            sipCanConvertToInstance(sipPy, sipClass_QDate, SIP_NO_CONVERTORS));

#if PY_VERSION_HEX >= 0x02040000
if (PyDate_Check(sipPy))
{
    *sipCppPtr = new QDate(PyDateTime_GET_YEAR(sipPy),
                           PyDateTime_GET_MONTH(sipPy),
                           PyDateTime_GET_DAY(sipPy));

    return sipGetState(sipTransferObj);
}
#endif

*sipCppPtr = reinterpret_cast<QDate *>(sipConvertToInstance(sipPy, sipClass_QDate, sipTransferObj, SIP_NO_CONVERTORS, 0, sipIsErr));

return 0;
#line 1298 "sipQtCoreQDate.cpp"
}


extern "C" {static void *forceConvertTo_QDate(PyObject *, int *);}
static void *forceConvertTo_QDate(PyObject *valobj,int *iserrp)
{
    if (*iserrp || valobj == NULL)
        return NULL;

    if (convertTo_QDate(valobj,NULL,NULL,NULL))
    {
        void *val;

        /*
         * Note that we throw away the flag that says if the value
         * has just been created on the heap or not.
         */
        convertTo_QDate(valobj,&val,iserrp,NULL);

        return val;
    }

    sipBadClass(sipNm_QtCore_QDate);

    *iserrp = 1;

    return NULL;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QDate[] = {
    {(void *)slot_QDate___ge__, ge_slot},
    {(void *)slot_QDate___gt__, gt_slot},
    {(void *)slot_QDate___le__, le_slot},
    {(void *)slot_QDate___lt__, lt_slot},
    {(void *)slot_QDate___ne__, ne_slot},
    {(void *)slot_QDate___eq__, eq_slot},
    {(void *)slot_QDate___nonzero__, nonzero_slot},
    {(void *)slot_QDate___repr__, repr_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QDate[] = {
    {sipNm_QtCore_addDays, meth_QDate_addDays, METH_VARARGS, NULL},
    {sipNm_QtCore_addMonths, meth_QDate_addMonths, METH_VARARGS, NULL},
    {sipNm_QtCore_addYears, meth_QDate_addYears, METH_VARARGS, NULL},
    {sipNm_QtCore_currentDate, meth_QDate_currentDate, METH_VARARGS, NULL},
    {sipNm_QtCore_day, meth_QDate_day, METH_VARARGS, NULL},
    {sipNm_QtCore_dayOfWeek, meth_QDate_dayOfWeek, METH_VARARGS, NULL},
    {sipNm_QtCore_dayOfYear, meth_QDate_dayOfYear, METH_VARARGS, NULL},
    {sipNm_QtCore_daysInMonth, meth_QDate_daysInMonth, METH_VARARGS, NULL},
    {sipNm_QtCore_daysInYear, meth_QDate_daysInYear, METH_VARARGS, NULL},
    {sipNm_QtCore_daysTo, meth_QDate_daysTo, METH_VARARGS, NULL},
    {sipNm_QtCore_fromJulianDay, meth_QDate_fromJulianDay, METH_VARARGS, NULL},
    {sipNm_QtCore_fromString, meth_QDate_fromString, METH_VARARGS, NULL},
    {sipNm_QtCore_gregorianToJulian, meth_QDate_gregorianToJulian, METH_VARARGS, NULL},
    {sipNm_QtCore_isLeapYear, meth_QDate_isLeapYear, METH_VARARGS, NULL},
    {sipNm_QtCore_isNull, meth_QDate_isNull, METH_VARARGS, NULL},
    {sipNm_QtCore_isValid, meth_QDate_isValid, METH_VARARGS, NULL},
    {sipNm_QtCore_julianToGregorian, meth_QDate_julianToGregorian, METH_VARARGS, NULL},
    {sipNm_QtCore_longDayName, meth_QDate_longDayName, METH_VARARGS, NULL},
    {sipNm_QtCore_longMonthName, meth_QDate_longMonthName, METH_VARARGS, NULL},
    {sipNm_QtCore_month, meth_QDate_month, METH_VARARGS, NULL},
    {sipNm_QtCore_setDate, meth_QDate_setDate, METH_VARARGS, NULL},
    {sipNm_QtCore_setYMD, meth_QDate_setYMD, METH_VARARGS, NULL},
    {sipNm_QtCore_shortDayName, meth_QDate_shortDayName, METH_VARARGS, NULL},
    {sipNm_QtCore_shortMonthName, meth_QDate_shortMonthName, METH_VARARGS, NULL},
    {sipNm_QtCore_toJulianDay, meth_QDate_toJulianDay, METH_VARARGS, NULL},
    {sipNm_QtCore_toPyDate, meth_QDate_toPyDate, METH_VARARGS, NULL},
    {sipNm_QtCore_toString, meth_QDate_toString, METH_VARARGS, NULL},
    {sipNm_QtCore_weekNumber, meth_QDate_weekNumber, METH_VARARGS, NULL},
    {sipNm_QtCore_year, meth_QDate_year, METH_VARARGS, NULL}
};


sipTypeDef sipType_QtCore_QDate = {
    0,
    0,
    "QtCore.QDate",
    0,
    {0, 0, 1},
    0,
    slots_QDate,
    29, methods_QDate,
    0, 0,
    0,
    init_QDate,
    0,
    0,
    0,
    0,
    0,
    0,
    dealloc_QDate,
    cast_QDate,
    release_QDate,
    forceConvertTo_QDate,
    convertTo_QDate,
    0,
    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    0,
    pickle_QDate,
    assign_QDate,
    0
};
