/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.7.7 on Fri Oct 30 22:46:27 2009
 *
 * Copyright (c) 2008 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt.
 * 
 * This file may be used under the terms of the GNU General Public
 * License versions 2.0 or 3.0 as published by the Free Software
 * Foundation and appearing in the files LICENSE.GPL2 and LICENSE.GPL3
 * included in the packaging of this file.  Alternatively you may (at
 * your option) use any later version of the GNU General Public
 * License if such license has been publicly approved by Riverbank
 * Computing Limited (or its successors, if any) and the KDE Free Qt
 * Foundation. In addition, as a special exception, Riverbank gives you
 * certain additional rights. These rights are described in the Riverbank
 * GPL Exception version 1.1, which can be found in the file
 * GPL_EXCEPTION.txt in this package.
 * 
 * Please review the following information to ensure GNU General
 * Public Licensing requirements will be met:
 * http://trolltech.com/products/qt/licenses/licensing/opensource/. If
 * you are unsure which license is appropriate for your use, please
 * review the following information:
 * http://trolltech.com/products/qt/licenses/licensing/licensingoverview
 * or contact the sales department at sales@riverbankcomputing.com.
 * 
 * This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
 * INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE. Trolltech reserves all rights not expressly
 * granted herein.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 46 "sip/QtCore/qstringlist.sip"
#include <qstringlist.h>
#line 44 "sipQtCoreQStringList.cpp"

#line 46 "sip/QtCore/qstring.sip"
#include <qstring.h>
#line 48 "sipQtCoreQStringList.cpp"
#line 46 "sip/QtCore/qregexp.sip"
#include <qregexp.h>
#line 51 "sipQtCoreQStringList.cpp"
#line 45 "sip/QtCore/qnamespace.sip"
#include <qnamespace.h>
#line 54 "sipQtCoreQStringList.cpp"


extern "C" {static PyObject *meth_QStringList_sort(PyObject *, PyObject *);}
static PyObject *meth_QStringList_sort(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QStringList *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QStringList,&sipCpp))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->sort();
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QStringList,sipNm_QtCore_sort);

    return NULL;
}


extern "C" {static PyObject *meth_QStringList_join(PyObject *, PyObject *);}
static PyObject *meth_QStringList_join(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QString * a0;
        int a0State = 0;
        QStringList *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJ1",&sipSelf,sipClass_QStringList,&sipCpp,sipClass_QString,&a0,&a0State))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->join(*a0));
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QStringList,sipNm_QtCore_join);

    return NULL;
}


extern "C" {static PyObject *meth_QStringList_filter(PyObject *, PyObject *);}
static PyObject *meth_QStringList_filter(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QString * a0;
        int a0State = 0;
        Qt::CaseSensitivity a1 = Qt::CaseSensitive;
        QStringList *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJ1|E",&sipSelf,sipClass_QStringList,&sipCpp,sipClass_QString,&a0,&a0State,sipEnum_Qt_CaseSensitivity,&a1))
        {
            QStringList *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QStringList(sipCpp->filter(*a0,a1));
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            return sipConvertFromNewInstance(sipRes,sipClass_QStringList,NULL);
        }
    }

    {
        const QRegExp * a0;
        QStringList *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QStringList,&sipCpp,sipClass_QRegExp,&a0))
        {
            QStringList *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QStringList(sipCpp->filter(*a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QStringList,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QStringList,sipNm_QtCore_filter);

    return NULL;
}


extern "C" {static PyObject *meth_QStringList_contains(PyObject *, PyObject *);}
static PyObject *meth_QStringList_contains(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QString * a0;
        int a0State = 0;
        Qt::CaseSensitivity a1 = Qt::CaseSensitive;
        QStringList *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJ1|E",&sipSelf,sipClass_QStringList,&sipCpp,sipClass_QString,&a0,&a0State,sipEnum_Qt_CaseSensitivity,&a1))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->contains(*a0,a1);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QStringList,sipNm_QtCore_contains);

    return NULL;
}


extern "C" {static PyObject *meth_QStringList_replaceInStrings(PyObject *, PyObject *);}
static PyObject *meth_QStringList_replaceInStrings(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QString * a0;
        int a0State = 0;
        const QString * a1;
        int a1State = 0;
        Qt::CaseSensitivity a2 = Qt::CaseSensitive;
        QStringList *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJ1J1|E",&sipSelf,sipClass_QStringList,&sipCpp,sipClass_QString,&a0,&a0State,sipClass_QString,&a1,&a1State,sipEnum_Qt_CaseSensitivity,&a2))
        {
            QStringList *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->replaceInStrings(*a0,*a1,a2);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);
            sipReleaseInstance(const_cast<QString *>(a1),sipClass_QString,a1State);

            return sipConvertFromInstance(sipRes,sipClass_QStringList,NULL);
        }
    }

    {
        const QRegExp * a0;
        const QString * a1;
        int a1State = 0;
        QStringList *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJAJ1",&sipSelf,sipClass_QStringList,&sipCpp,sipClass_QRegExp,&a0,sipClass_QString,&a1,&a1State))
        {
            QStringList *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->replaceInStrings(*a0,*a1);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a1),sipClass_QString,a1State);

            return sipConvertFromInstance(sipRes,sipClass_QStringList,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QStringList,sipNm_QtCore_replaceInStrings);

    return NULL;
}


extern "C" {static PyObject *meth_QStringList_indexOf(PyObject *, PyObject *);}
static PyObject *meth_QStringList_indexOf(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QString * a0;
        int a0State = 0;
        int a1 = 0;
        QStringList *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJ1|i",&sipSelf,sipClass_QStringList,&sipCpp,sipClass_QString,&a0,&a0State,&a1))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->indexOf(*a0,a1);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            return PyInt_FromLong(sipRes);
        }
    }

    {
        const QRegExp * a0;
        int a1 = 0;
        QStringList *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA|i",&sipSelf,sipClass_QStringList,&sipCpp,sipClass_QRegExp,&a0,&a1))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->indexOf(*a0,a1);
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QStringList,sipNm_QtCore_indexOf);

    return NULL;
}


extern "C" {static PyObject *meth_QStringList_lastIndexOf(PyObject *, PyObject *);}
static PyObject *meth_QStringList_lastIndexOf(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QString * a0;
        int a0State = 0;
        int a1 = -1;
        QStringList *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJ1|i",&sipSelf,sipClass_QStringList,&sipCpp,sipClass_QString,&a0,&a0State,&a1))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->lastIndexOf(*a0,a1);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            return PyInt_FromLong(sipRes);
        }
    }

    {
        const QRegExp * a0;
        int a1 = -1;
        QStringList *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA|i",&sipSelf,sipClass_QStringList,&sipCpp,sipClass_QRegExp,&a0,&a1))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->lastIndexOf(*a0,a1);
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QStringList,sipNm_QtCore_lastIndexOf);

    return NULL;
}


extern "C" {static PyObject *meth_QStringList_clear(PyObject *, PyObject *);}
static PyObject *meth_QStringList_clear(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QStringList *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QStringList,&sipCpp))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->clear();
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QStringList,sipNm_QtCore_clear);

    return NULL;
}


extern "C" {static PyObject *meth_QStringList_isEmpty(PyObject *, PyObject *);}
static PyObject *meth_QStringList_isEmpty(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QStringList *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QStringList,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isEmpty();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QStringList,sipNm_QtCore_isEmpty);

    return NULL;
}


extern "C" {static PyObject *meth_QStringList_append(PyObject *, PyObject *);}
static PyObject *meth_QStringList_append(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QString * a0;
        int a0State = 0;
        QStringList *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJ1",&sipSelf,sipClass_QStringList,&sipCpp,sipClass_QString,&a0,&a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->append(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QStringList,sipNm_QtCore_append);

    return NULL;
}


extern "C" {static PyObject *meth_QStringList_prepend(PyObject *, PyObject *);}
static PyObject *meth_QStringList_prepend(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QString * a0;
        int a0State = 0;
        QStringList *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJ1",&sipSelf,sipClass_QStringList,&sipCpp,sipClass_QString,&a0,&a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->prepend(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QStringList,sipNm_QtCore_prepend);

    return NULL;
}


extern "C" {static PyObject *meth_QStringList_insert(PyObject *, PyObject *);}
static PyObject *meth_QStringList_insert(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        const QString * a1;
        int a1State = 0;
        QStringList *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BiJ1",&sipSelf,sipClass_QStringList,&sipCpp,&a0,sipClass_QString,&a1,&a1State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->insert(a0,*a1);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a1),sipClass_QString,a1State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QStringList,sipNm_QtCore_insert);

    return NULL;
}


extern "C" {static PyObject *meth_QStringList_replace(PyObject *, PyObject *);}
static PyObject *meth_QStringList_replace(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        const QString * a1;
        int a1State = 0;
        QStringList *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BiJ1",&sipSelf,sipClass_QStringList,&sipCpp,&a0,sipClass_QString,&a1,&a1State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->replace(a0,*a1);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a1),sipClass_QString,a1State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QStringList,sipNm_QtCore_replace);

    return NULL;
}


extern "C" {static PyObject *meth_QStringList_removeAt(PyObject *, PyObject *);}
static PyObject *meth_QStringList_removeAt(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        QStringList *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bi",&sipSelf,sipClass_QStringList,&sipCpp,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->removeAt(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QStringList,sipNm_QtCore_removeAt);

    return NULL;
}


extern "C" {static PyObject *meth_QStringList_removeAll(PyObject *, PyObject *);}
static PyObject *meth_QStringList_removeAll(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QString * a0;
        int a0State = 0;
        QStringList *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJ1",&sipSelf,sipClass_QStringList,&sipCpp,sipClass_QString,&a0,&a0State))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->removeAll(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QStringList,sipNm_QtCore_removeAll);

    return NULL;
}


extern "C" {static PyObject *meth_QStringList_takeAt(PyObject *, PyObject *);}
static PyObject *meth_QStringList_takeAt(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        QStringList *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bi",&sipSelf,sipClass_QStringList,&sipCpp,&a0))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->takeAt(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QStringList,sipNm_QtCore_takeAt);

    return NULL;
}


extern "C" {static PyObject *meth_QStringList_takeFirst(PyObject *, PyObject *);}
static PyObject *meth_QStringList_takeFirst(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QStringList *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QStringList,&sipCpp))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->takeFirst());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QStringList,sipNm_QtCore_takeFirst);

    return NULL;
}


extern "C" {static PyObject *meth_QStringList_takeLast(PyObject *, PyObject *);}
static PyObject *meth_QStringList_takeLast(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QStringList *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QStringList,&sipCpp))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->takeLast());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QStringList,sipNm_QtCore_takeLast);

    return NULL;
}


extern "C" {static PyObject *meth_QStringList_move(PyObject *, PyObject *);}
static PyObject *meth_QStringList_move(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        int a1;
        QStringList *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bii",&sipSelf,sipClass_QStringList,&sipCpp,&a0,&a1))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->move(a0,a1);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QStringList,sipNm_QtCore_move);

    return NULL;
}


extern "C" {static PyObject *meth_QStringList_swap(PyObject *, PyObject *);}
static PyObject *meth_QStringList_swap(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        int a1;
        QStringList *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bii",&sipSelf,sipClass_QStringList,&sipCpp,&a0,&a1))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->swap(a0,a1);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QStringList,sipNm_QtCore_swap);

    return NULL;
}


extern "C" {static PyObject *meth_QStringList_count(PyObject *, PyObject *);}
static PyObject *meth_QStringList_count(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QString * a0;
        int a0State = 0;
        QStringList *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJ1",&sipSelf,sipClass_QStringList,&sipCpp,sipClass_QString,&a0,&a0State))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->count(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            return PyInt_FromLong(sipRes);
        }
    }

    {
        QStringList *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QStringList,&sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->count();
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QStringList,sipNm_QtCore_count);

    return NULL;
}


extern "C" {static PyObject *meth_QStringList_first(PyObject *, PyObject *);}
static PyObject *meth_QStringList_first(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QStringList *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QStringList,&sipCpp))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->first();
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QStringList,sipNm_QtCore_first);

    return NULL;
}


extern "C" {static PyObject *meth_QStringList_last(PyObject *, PyObject *);}
static PyObject *meth_QStringList_last(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QStringList *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QStringList,&sipCpp))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->last();
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QStringList,sipNm_QtCore_last);

    return NULL;
}


extern "C" {static PyObject *meth_QStringList_mid(PyObject *, PyObject *);}
static PyObject *meth_QStringList_mid(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        int a1 = -1;
        QStringList *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bi|i",&sipSelf,sipClass_QStringList,&sipCpp,&a0,&a1))
        {
            QStringList *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QStringList(sipCpp->mid(a0,a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QStringList,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QStringList,sipNm_QtCore_mid);

    return NULL;
}


extern "C" {static PyObject *slot_QStringList___iadd__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QStringList___iadd__(PyObject *sipSelf,PyObject *sipArg)
{
    QStringList *sipCpp = reinterpret_cast<QStringList *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QStringList));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QStringList * a0;
        int a0State = 0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1J1",sipClass_QStringList,&a0,&a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->QStringList::operator+=(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QStringList *>(a0),sipClass_QStringList,a0State);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    {
        const QString * a0;
        int a0State = 0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1J1",sipClass_QString,&a0,&a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->QStringList::operator+=(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    /* Raise an exception if the argument couldn't be parsed. */
    sipBadOperatorArg(sipSelf,sipArg,iconcat_slot);

    return NULL;
}


extern "C" {static PyObject *slot_QStringList___ne__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QStringList___ne__(PyObject *sipSelf,PyObject *sipArg)
{
    QStringList *sipCpp = reinterpret_cast<QStringList *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QStringList));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QStringList * a0;
        int a0State = 0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1J1",sipClass_QStringList,&a0,&a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QStringList::operator!=(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QStringList *>(a0),sipClass_QStringList,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,ne_slot,sipClass_QStringList,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QStringList___eq__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QStringList___eq__(PyObject *sipSelf,PyObject *sipArg)
{
    QStringList *sipCpp = reinterpret_cast<QStringList *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QStringList));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QStringList * a0;
        int a0State = 0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1J1",sipClass_QStringList,&a0,&a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QStringList::operator==(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QStringList *>(a0),sipClass_QStringList,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,eq_slot,sipClass_QStringList,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QStringList___imul__(PyObject *sipSelf,int a0);}
static PyObject *slot_QStringList___imul__(PyObject *sipSelf,int a0)
{
    QStringList *sipCpp = reinterpret_cast<QStringList *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QStringList));

    if (!sipCpp)
        return 0;


    {
        {
#line 247 "sip/QtCore/qstringlist.sip"
        QStringList orig(*sipCpp);
        
        sipCpp->clear();
        
        while (a0-- > 0)
            *sipCpp += orig;
#line 980 "sipQtCoreQStringList.cpp"

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }
}


extern "C" {static PyObject *slot_QStringList___mul__(PyObject *sipSelf,int a0);}
static PyObject *slot_QStringList___mul__(PyObject *sipSelf,int a0)
{
    QStringList *sipCpp = reinterpret_cast<QStringList *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QStringList));

    if (!sipCpp)
        return 0;


    {
        {
            QStringList *sipRes = 0;

#line 239 "sip/QtCore/qstringlist.sip"
        sipRes = new QStringList();
        
        while (a0-- > 0)
            *sipRes += *sipCpp;
#line 1007 "sipQtCoreQStringList.cpp"

            return sipConvertFromNewInstance(sipRes,sipClass_QStringList,NULL);
        }
    }
}


extern "C" {static PyObject *slot_QStringList___add__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QStringList___add__(PyObject *sipSelf,PyObject *sipArg)
{
    QStringList *sipCpp = reinterpret_cast<QStringList *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QStringList));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QStringList * a0;
        int a0State = 0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1J1",sipClass_QStringList,&a0,&a0State))
        {
            QStringList *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QStringList(sipCpp->QStringList::operator+(*a0));
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QStringList *>(a0),sipClass_QStringList,a0State);

            return sipConvertFromNewInstance(sipRes,sipClass_QStringList,NULL);
        }
    }

    /* Raise an exception if the argument couldn't be parsed. */
    sipBadOperatorArg(sipSelf,sipArg,concat_slot);

    return NULL;
}


extern "C" {static int slot_QStringList___contains__(PyObject *sipSelf,PyObject *sipArg);}
static int slot_QStringList___contains__(PyObject *sipSelf,PyObject *sipArg)
{
    QStringList *sipCpp = reinterpret_cast<QStringList *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QStringList));

    if (!sipCpp)
        return -1;

    int sipArgsParsed = 0;

    {
        const QString * a0;
        int a0State = 0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1J1",sipClass_QString,&a0,&a0State))
        {
            int sipRes = 0;

#line 232 "sip/QtCore/qstringlist.sip"
        // It looks like you can't assign QBool to int.
        sipRes = bool(sipCpp->contains(*a0));
#line 1071 "sipQtCoreQStringList.cpp"

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            return sipRes;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QStringList,sipNm_QtCore___contains__);

    return -1;
}


extern "C" {static PyObject *slot_QStringList___getitem__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QStringList___getitem__(PyObject *sipSelf,PyObject *sipArg)
{
    QStringList *sipCpp = reinterpret_cast<QStringList *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QStringList));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        int a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1i",&a0))
        {
            QString *sipRes = 0;
            int sipIsErr = 0;

#line 200 "sip/QtCore/qstringlist.sip"
        int len;
        
        len = sipCpp->count();
        
        if ((a0 = (int)sipConvertFromSequenceIndex(a0, len)) < 0)
            sipIsErr = 1;
        else
            sipRes = new QString((*sipCpp)[a0]);
#line 1113 "sipQtCoreQStringList.cpp"

            if (sipIsErr)
                return 0;

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    {
        PyObject * a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1T",&PySlice_Type,&a0))
        {
            QStringList *sipRes = 0;
            int sipIsErr = 0;

#line 212 "sip/QtCore/qstringlist.sip"
        SIP_SSIZE_T len, start, stop, step, slicelength, i;
        
        len = sipCpp->count();
        
        if (PySlice_GetIndicesEx((PySliceObject *)a0, len, &start, &stop, &step, &slicelength) < 0)
            sipIsErr = 1;
        else
        {
            sipRes = new QStringList();
        
            for (i = 0; i < slicelength; ++i)
            {
                (*sipRes) += (*sipCpp)[start];
                start += step;
            }
        }
#line 1147 "sipQtCoreQStringList.cpp"

            if (sipIsErr)
                return 0;

            return sipConvertFromNewInstance(sipRes,sipClass_QStringList,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QStringList,sipNm_QtCore___getitem__);

    return 0;
}


extern "C" {static int slot_QStringList___delitem__(PyObject *sipSelf,PyObject *sipArg);}
static int slot_QStringList___delitem__(PyObject *sipSelf,PyObject *sipArg)
{
    QStringList *sipCpp = reinterpret_cast<QStringList *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QStringList));

    if (!sipCpp)
        return -1;

    int sipArgsParsed = 0;

    {
        int a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1i",&a0))
        {
            int sipIsErr = 0;

#line 172 "sip/QtCore/qstringlist.sip"
        int len;
        
        len = sipCpp->count();
        
        if ((a0 = (int)sipConvertFromSequenceIndex(a0, len)) < 0)
            sipIsErr = 1;
        else
            sipCpp->removeAt(a0);
#line 1189 "sipQtCoreQStringList.cpp"

            if (sipIsErr)
                return -1;

            return 0;
        }
    }

    {
        PyObject * a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1T",&PySlice_Type,&a0))
        {
            int sipIsErr = 0;

#line 184 "sip/QtCore/qstringlist.sip"
        SIP_SSIZE_T len, start, stop, step, slicelength, i;
        
        len = sipCpp->count();
        
        if (PySlice_GetIndicesEx((PySliceObject *)a0, len, &start, &stop, &step, &slicelength) < 0)
            sipIsErr = 1;
        else
            for (i = 0; i < slicelength; ++i)
            {
                sipCpp->removeAt(start);
                start += step - 1;
            }
#line 1218 "sipQtCoreQStringList.cpp"

            if (sipIsErr)
                return -1;

            return 0;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QStringList,sipNm_QtCore___delitem__);

    return -1;
}


extern "C" {static int slot_QStringList___setitem__(PyObject *sipSelf,PyObject *sipArgs);}
static int slot_QStringList___setitem__(PyObject *sipSelf,PyObject *sipArgs)
{
    QStringList *sipCpp = reinterpret_cast<QStringList *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QStringList));

    if (!sipCpp)
        return -1;

    int sipArgsParsed = 0;

    {
        int a0;
        const QString * a1;
        int a1State = 0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"iJ1",&a0,sipClass_QString,&a1,&a1State))
        {
            int sipIsErr = 0;

#line 129 "sip/QtCore/qstringlist.sip"
        int len;
        
        len = sipCpp->count();
        
        if ((a0 = (int)sipConvertFromSequenceIndex(a0, len)) < 0)
            sipIsErr = 1;
        else
            (*sipCpp)[a0] = *a1;
#line 1262 "sipQtCoreQStringList.cpp"

            sipReleaseInstance(const_cast<QString *>(a1),sipClass_QString,a1State);

            if (sipIsErr)
                return -1;

            return 0;
        }
    }

    {
        PyObject * a0;
        const QStringList * a1;
        int a1State = 0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"TJ1",&PySlice_Type,&a0,sipClass_QStringList,&a1,&a1State))
        {
            int sipIsErr = 0;

#line 141 "sip/QtCore/qstringlist.sip"
        SIP_SSIZE_T len, start, stop, step, slicelength, i;
        
        len = sipCpp->count();
        
        if (PySlice_GetIndicesEx((PySliceObject *)a0, len, &start, &stop, &step, &slicelength) < 0)
            sipIsErr = 1;
        else
        {
            int vlen = a1->count();
        
            if (vlen != slicelength)
            {
                sipBadLengthForSlice(vlen, slicelength);
                sipIsErr = 1;
            }
            else
            {
                QStringList::const_iterator it = a1->begin();
        
                for (i = 0; i < slicelength; ++i)
                {
                    (*sipCpp)[start] = *it;
                    start += step;
                    ++it;
                }
            }
        }
#line 1310 "sipQtCoreQStringList.cpp"

            sipReleaseInstance(const_cast<QStringList *>(a1),sipClass_QStringList,a1State);

            if (sipIsErr)
                return -1;

            return 0;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QStringList,sipNm_QtCore___setitem__);

    return -1;
}


extern "C" {static int slot_QStringList___len__(PyObject *sipSelf);}
static int slot_QStringList___len__(PyObject *sipSelf)
{
    QStringList *sipCpp = reinterpret_cast<QStringList *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QStringList));

    if (!sipCpp)
        return -1;


    {
        {
            int sipRes = 0;

#line 124 "sip/QtCore/qstringlist.sip"
        sipRes = sipCpp->count();
#line 1343 "sipQtCoreQStringList.cpp"

            return sipRes;
        }
    }
}


extern "C" {static PyObject *slot_QStringList___lshift__(PyObject *sipArg0,PyObject *sipArg1);}
static PyObject *slot_QStringList___lshift__(PyObject *sipArg0,PyObject *sipArg1)
{
    int sipArgsParsed = 0;

    {
        QStringList * a0;
        int a0State = 0;
        const QString * a1;
        int a1State = 0;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"J1J1",sipClass_QStringList,&a0,&a0State,sipClass_QString,&a1,&a1State))
        {
            QStringList *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 << *a1);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(a0,sipClass_QStringList,a0State);
            sipReleaseInstance(const_cast<QString *>(a1),sipClass_QString,a1State);

            return sipConvertFromInstance(sipRes,sipClass_QStringList,NULL);
        }
    }

    {
        QStringList * a0;
        int a0State = 0;
        const QStringList * a1;
        int a1State = 0;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"J1J1",sipClass_QStringList,&a0,&a0State,sipClass_QStringList,&a1,&a1State))
        {
            QStringList *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 << *a1);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(a0,sipClass_QStringList,a0State);
            sipReleaseInstance(const_cast<QStringList *>(a1),sipClass_QStringList,a1State);

            return sipConvertFromInstance(sipRes,sipClass_QStringList,NULL);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,lshift_slot,NULL,sipArg0,sipArg1);
}


/* Cast a pointer to a type somewhere in its superclass hierarchy. */
extern "C" {static void *cast_QStringList(void *, sipWrapperType *);}
static void *cast_QStringList(void *ptr,sipWrapperType *targetClass)
{
    if (targetClass == sipClass_QStringList)
        return ptr;

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_QStringList(void *, int);}
static void release_QStringList(void *sipCppV,int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast<QStringList *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_QStringList(void *, const void*);}
static void assign_QStringList(void *sipDst, const void *sipSrc)
{
    *reinterpret_cast<QStringList *>(sipDst) = *reinterpret_cast<const QStringList *>(sipSrc);
}


extern "C" {static void dealloc_QStringList(sipWrapper *);}
static void dealloc_QStringList(sipWrapper *sipSelf)
{
    if (sipIsPyOwned(sipSelf))
    {
        release_QStringList(sipSelf->u.cppPtr,0);
    }
}


extern "C" {static void *init_QStringList(sipWrapper *, PyObject *, sipWrapper **, int *);}
static void *init_QStringList(sipWrapper *,PyObject *sipArgs,sipWrapper **,int *sipArgsParsed)
{
    QStringList *sipCpp = 0;

    if (!sipCpp)
    {
        if (sipParseArgs(sipArgsParsed,sipArgs,""))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QStringList();
            Py_END_ALLOW_THREADS
        }
    }

    if (!sipCpp)
    {
        const QString * a0;
        int a0State = 0;

        if (sipParseArgs(sipArgsParsed,sipArgs,"J1",sipClass_QString,&a0,&a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QStringList(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);
        }
    }

    if (!sipCpp)
    {
        const QStringList * a0;
        int a0State = 0;

        if (sipParseArgs(sipArgsParsed,sipArgs,"J1",sipClass_QStringList,&a0,&a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QStringList(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QStringList *>(a0),sipClass_QStringList,a0State);
        }
    }

    return sipCpp;
}


extern "C" {static int convertTo_QStringList(PyObject *, void **, int *, PyObject *);}
static int convertTo_QStringList(PyObject *sipPy,void **sipCppPtrV,int *sipIsErr,PyObject *sipTransferObj)
{
    QStringList **sipCppPtr = reinterpret_cast<QStringList **>(sipCppPtrV);

#line 50 "sip/QtCore/qstringlist.sip"
// Allow a Python sequence of QStrings whenever a QStringList is expected.

SIP_SSIZE_T len;

if (sipIsErr == NULL)
{
    if (sipCanConvertToInstance(sipPy, sipClass_QStringList, SIP_NO_CONVERTORS))
        return 1;

    len = PySequence_Size(sipPy);

    if (len < 0)
        return 0;

    for (SIP_SSIZE_T i = 0; i < len; ++i)
        if (!sipCanConvertToInstance(PySequence_ITEM(sipPy, i), sipClass_QString, SIP_NOT_NONE))
            return 0;

    return 1;
}

if (sipCanConvertToInstance(sipPy, sipClass_QStringList, SIP_NO_CONVERTORS))
{
    *sipCppPtr = reinterpret_cast<QStringList *>(sipConvertToInstance(sipPy, sipClass_QStringList, sipTransferObj, SIP_NO_CONVERTORS, 0, sipIsErr));

    return 0;
}

QStringList *sl = new QStringList;

len = PySequence_Size(sipPy);

for (SIP_SSIZE_T i = 0; i < len; ++i)
{
    int state;
    QString *s = reinterpret_cast<QString *>(sipConvertToInstance(PySequence_ITEM(sipPy, i), sipClass_QString, sipTransferObj, SIP_NOT_NONE, &state, sipIsErr));

    if (*sipIsErr)
    {
        sipReleaseInstance(s, sipClass_QString, state);

        delete sl;
        return 0;
    }

    sl->append(*s);

    sipReleaseInstance(s, sipClass_QString, state);
}

*sipCppPtr = sl;

return sipGetState(sipTransferObj);
#line 1550 "sipQtCoreQStringList.cpp"
}


extern "C" {static void *forceConvertTo_QStringList(PyObject *, int *);}
static void *forceConvertTo_QStringList(PyObject *valobj,int *iserrp)
{
    if (*iserrp || valobj == NULL)
        return NULL;

    if (convertTo_QStringList(valobj,NULL,NULL,NULL))
    {
        void *val;

        /*
         * Note that we throw away the flag that says if the value
         * has just been created on the heap or not.
         */
        convertTo_QStringList(valobj,&val,iserrp,NULL);

        return val;
    }

    sipBadClass(sipNm_QtCore_QStringList);

    *iserrp = 1;

    return NULL;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QStringList[] = {
    {(void *)slot_QStringList___iadd__, iconcat_slot},
    {(void *)slot_QStringList___ne__, ne_slot},
    {(void *)slot_QStringList___eq__, eq_slot},
    {(void *)slot_QStringList___imul__, irepeat_slot},
    {(void *)slot_QStringList___mul__, repeat_slot},
    {(void *)slot_QStringList___add__, concat_slot},
    {(void *)slot_QStringList___contains__, contains_slot},
    {(void *)slot_QStringList___getitem__, getitem_slot},
    {(void *)slot_QStringList___delitem__, delitem_slot},
    {(void *)slot_QStringList___setitem__, setitem_slot},
    {(void *)slot_QStringList___len__, len_slot},
    {(void *)slot_QStringList___lshift__, lshift_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QStringList[] = {
    {sipNm_QtCore_append, meth_QStringList_append, METH_VARARGS, NULL},
    {sipNm_QtCore_clear, meth_QStringList_clear, METH_VARARGS, NULL},
    {sipNm_QtCore_contains, meth_QStringList_contains, METH_VARARGS, NULL},
    {sipNm_QtCore_count, meth_QStringList_count, METH_VARARGS, NULL},
    {sipNm_QtCore_filter, meth_QStringList_filter, METH_VARARGS, NULL},
    {sipNm_QtCore_first, meth_QStringList_first, METH_VARARGS, NULL},
    {sipNm_QtCore_indexOf, meth_QStringList_indexOf, METH_VARARGS, NULL},
    {sipNm_QtCore_insert, meth_QStringList_insert, METH_VARARGS, NULL},
    {sipNm_QtCore_isEmpty, meth_QStringList_isEmpty, METH_VARARGS, NULL},
    {sipNm_QtCore_join, meth_QStringList_join, METH_VARARGS, NULL},
    {sipNm_QtCore_last, meth_QStringList_last, METH_VARARGS, NULL},
    {sipNm_QtCore_lastIndexOf, meth_QStringList_lastIndexOf, METH_VARARGS, NULL},
    {sipNm_QtCore_mid, meth_QStringList_mid, METH_VARARGS, NULL},
    {sipNm_QtCore_move, meth_QStringList_move, METH_VARARGS, NULL},
    {sipNm_QtCore_prepend, meth_QStringList_prepend, METH_VARARGS, NULL},
    {sipNm_QtCore_removeAll, meth_QStringList_removeAll, METH_VARARGS, NULL},
    {sipNm_QtCore_removeAt, meth_QStringList_removeAt, METH_VARARGS, NULL},
    {sipNm_QtCore_replace, meth_QStringList_replace, METH_VARARGS, NULL},
    {sipNm_QtCore_replaceInStrings, meth_QStringList_replaceInStrings, METH_VARARGS, NULL},
    {sipNm_QtCore_sort, meth_QStringList_sort, METH_VARARGS, NULL},
    {sipNm_QtCore_swap, meth_QStringList_swap, METH_VARARGS, NULL},
    {sipNm_QtCore_takeAt, meth_QStringList_takeAt, METH_VARARGS, NULL},
    {sipNm_QtCore_takeFirst, meth_QStringList_takeFirst, METH_VARARGS, NULL},
    {sipNm_QtCore_takeLast, meth_QStringList_takeLast, METH_VARARGS, NULL}
};


sipTypeDef sipType_QtCore_QStringList = {
    0,
    0,
    "QtCore.QStringList",
    0,
    {0, 0, 1},
    0,
    slots_QStringList,
    24, methods_QStringList,
    0, 0,
    0,
    init_QStringList,
    0,
    0,
    0,
    0,
    0,
    0,
    dealloc_QStringList,
    cast_QStringList,
    release_QStringList,
    forceConvertTo_QStringList,
    convertTo_QStringList,
    0,
    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    0,
    0,
    assign_QStringList,
    0
};
