/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.7.7 on Fri Oct 30 22:46:27 2009
 *
 * Copyright (c) 2008 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt.
 * 
 * This file may be used under the terms of the GNU General Public
 * License versions 2.0 or 3.0 as published by the Free Software
 * Foundation and appearing in the files LICENSE.GPL2 and LICENSE.GPL3
 * included in the packaging of this file.  Alternatively you may (at
 * your option) use any later version of the GNU General Public
 * License if such license has been publicly approved by Riverbank
 * Computing Limited (or its successors, if any) and the KDE Free Qt
 * Foundation. In addition, as a special exception, Riverbank gives you
 * certain additional rights. These rights are described in the Riverbank
 * GPL Exception version 1.1, which can be found in the file
 * GPL_EXCEPTION.txt in this package.
 * 
 * Please review the following information to ensure GNU General
 * Public Licensing requirements will be met:
 * http://trolltech.com/products/qt/licenses/licensing/opensource/. If
 * you are unsure which license is appropriate for your use, please
 * review the following information:
 * http://trolltech.com/products/qt/licenses/licensing/licensingoverview
 * or contact the sales department at sales@riverbankcomputing.com.
 * 
 * This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
 * INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE. Trolltech reserves all rights not expressly
 * granted herein.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 46 "sip/QtCore/qsize.sip"
#include <qsize.h>
#line 44 "sipQtCoreQSize.cpp"

#line 45 "sip/QtCore/qnamespace.sip"
#include <qnamespace.h>
#line 48 "sipQtCoreQSize.cpp"


extern "C" {static PyObject *meth_QSize_transpose(PyObject *, PyObject *);}
static PyObject *meth_QSize_transpose(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QSize *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QSize,&sipCpp))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->transpose();
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QSize,sipNm_QtCore_transpose);

    return NULL;
}


extern "C" {static PyObject *meth_QSize_scale(PyObject *, PyObject *);}
static PyObject *meth_QSize_scale(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QSize * a0;
        Qt::AspectRatioMode a1;
        QSize *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJAE",&sipSelf,sipClass_QSize,&sipCpp,sipClass_QSize,&a0,sipEnum_Qt_AspectRatioMode,&a1))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->scale(*a0,a1);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        int a0;
        int a1;
        Qt::AspectRatioMode a2;
        QSize *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BiiE",&sipSelf,sipClass_QSize,&sipCpp,&a0,&a1,sipEnum_Qt_AspectRatioMode,&a2))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->scale(a0,a1,a2);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QSize,sipNm_QtCore_scale);

    return NULL;
}


extern "C" {static PyObject *meth_QSize_isNull(PyObject *, PyObject *);}
static PyObject *meth_QSize_isNull(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QSize *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QSize,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isNull();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QSize,sipNm_QtCore_isNull);

    return NULL;
}


extern "C" {static PyObject *meth_QSize_isEmpty(PyObject *, PyObject *);}
static PyObject *meth_QSize_isEmpty(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QSize *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QSize,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isEmpty();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QSize,sipNm_QtCore_isEmpty);

    return NULL;
}


extern "C" {static PyObject *meth_QSize_isValid(PyObject *, PyObject *);}
static PyObject *meth_QSize_isValid(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QSize *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QSize,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isValid();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QSize,sipNm_QtCore_isValid);

    return NULL;
}


extern "C" {static PyObject *meth_QSize_width(PyObject *, PyObject *);}
static PyObject *meth_QSize_width(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QSize *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QSize,&sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->width();
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QSize,sipNm_QtCore_width);

    return NULL;
}


extern "C" {static PyObject *meth_QSize_height(PyObject *, PyObject *);}
static PyObject *meth_QSize_height(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QSize *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QSize,&sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->height();
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QSize,sipNm_QtCore_height);

    return NULL;
}


extern "C" {static PyObject *meth_QSize_setWidth(PyObject *, PyObject *);}
static PyObject *meth_QSize_setWidth(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        QSize *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bi",&sipSelf,sipClass_QSize,&sipCpp,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setWidth(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QSize,sipNm_QtCore_setWidth);

    return NULL;
}


extern "C" {static PyObject *meth_QSize_setHeight(PyObject *, PyObject *);}
static PyObject *meth_QSize_setHeight(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        QSize *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bi",&sipSelf,sipClass_QSize,&sipCpp,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setHeight(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QSize,sipNm_QtCore_setHeight);

    return NULL;
}


extern "C" {static PyObject *meth_QSize_expandedTo(PyObject *, PyObject *);}
static PyObject *meth_QSize_expandedTo(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QSize * a0;
        QSize *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QSize,&sipCpp,sipClass_QSize,&a0))
        {
            QSize *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QSize(sipCpp->expandedTo(*a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QSize,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QSize,sipNm_QtCore_expandedTo);

    return NULL;
}


extern "C" {static PyObject *meth_QSize_boundedTo(PyObject *, PyObject *);}
static PyObject *meth_QSize_boundedTo(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QSize * a0;
        QSize *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QSize,&sipCpp,sipClass_QSize,&a0))
        {
            QSize *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QSize(sipCpp->boundedTo(*a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QSize,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QSize,sipNm_QtCore_boundedTo);

    return NULL;
}


extern "C" {static PyObject *slot_QSize___eq__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QSize___eq__(PyObject *sipSelf,PyObject *sipArg)
{
    QSize *sipCpp = reinterpret_cast<QSize *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QSize));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QSize * a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1JA",sipClass_QSize,&a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = operator==((*sipCpp), *a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,eq_slot,sipClass_QSize,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QSize___ne__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QSize___ne__(PyObject *sipSelf,PyObject *sipArg)
{
    QSize *sipCpp = reinterpret_cast<QSize *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QSize));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QSize * a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1JA",sipClass_QSize,&a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = operator!=((*sipCpp), *a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,ne_slot,sipClass_QSize,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QSize___add__(PyObject *sipArg0,PyObject *sipArg1);}
static PyObject *slot_QSize___add__(PyObject *sipArg0,PyObject *sipArg1)
{
    int sipArgsParsed = 0;

    {
        const QSize * a0;
        const QSize * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QSize,&a0,sipClass_QSize,&a1))
        {
            QSize *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QSize((*a0 + *a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QSize,NULL);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,add_slot,NULL,sipArg0,sipArg1);
}


extern "C" {static PyObject *slot_QSize___sub__(PyObject *sipArg0,PyObject *sipArg1);}
static PyObject *slot_QSize___sub__(PyObject *sipArg0,PyObject *sipArg1)
{
    int sipArgsParsed = 0;

    {
        const QSize * a0;
        const QSize * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QSize,&a0,sipClass_QSize,&a1))
        {
            QSize *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QSize((*a0 - *a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QSize,NULL);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,sub_slot,NULL,sipArg0,sipArg1);
}


extern "C" {static PyObject *slot_QSize___mul__(PyObject *sipArg0,PyObject *sipArg1);}
static PyObject *slot_QSize___mul__(PyObject *sipArg0,PyObject *sipArg1)
{
    int sipArgsParsed = 0;

    {
        double a0;
        const QSize * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"dJA",&a0,sipClass_QSize,&a1))
        {
            QSize *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QSize((a0 * *a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QSize,NULL);
        }
    }

    {
        const QSize * a0;
        double a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAd",sipClass_QSize,&a0,&a1))
        {
            QSize *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QSize((*a0 * a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QSize,NULL);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,mul_slot,NULL,sipArg0,sipArg1);
}


extern "C" {static PyObject *slot_QSize___div__(PyObject *sipArg0,PyObject *sipArg1);}
static PyObject *slot_QSize___div__(PyObject *sipArg0,PyObject *sipArg1)
{
    int sipArgsParsed = 0;

    {
        const QSize * a0;
        double a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAd",sipClass_QSize,&a0,&a1))
        {
            QSize *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QSize((*a0 / a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QSize,NULL);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,div_slot,NULL,sipArg0,sipArg1);
}


extern "C" {static PyObject *slot_QSize___idiv__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QSize___idiv__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf,(PyTypeObject *)sipClass_QSize))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    QSize *sipCpp = reinterpret_cast<QSize *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QSize));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        double a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1d",&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->QSize::operator/=(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QSize___imul__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QSize___imul__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf,(PyTypeObject *)sipClass_QSize))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    QSize *sipCpp = reinterpret_cast<QSize *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QSize));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        double a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1d",&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->QSize::operator*=(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QSize___isub__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QSize___isub__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf,(PyTypeObject *)sipClass_QSize))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    QSize *sipCpp = reinterpret_cast<QSize *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QSize));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QSize * a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1JA",sipClass_QSize,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->QSize::operator-=(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QSize___iadd__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QSize___iadd__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf,(PyTypeObject *)sipClass_QSize))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    QSize *sipCpp = reinterpret_cast<QSize *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QSize));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QSize * a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1JA",sipClass_QSize,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->QSize::operator+=(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static int slot_QSize___nonzero__(PyObject *sipSelf);}
static int slot_QSize___nonzero__(PyObject *sipSelf)
{
    QSize *sipCpp = reinterpret_cast<QSize *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QSize));

    if (!sipCpp)
        return -1;


    {
        {
            int sipRes = 0;

#line 69 "sip/QtCore/qsize.sip"
        sipRes = sipCpp->isValid();
#line 704 "sipQtCoreQSize.cpp"

            return sipRes;
        }
    }
}


extern "C" {static PyObject *slot_QSize___repr__(PyObject *sipSelf);}
static PyObject *slot_QSize___repr__(PyObject *sipSelf)
{
    QSize *sipCpp = reinterpret_cast<QSize *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QSize));

    if (!sipCpp)
        return 0;


    {
        {
            PyObject * sipRes = 0;

#line 60 "sip/QtCore/qsize.sip"
        sipRes = PyString_FromFormat("PyQt4.QtCore.QSize(%i, %i)", sipCpp->width(),
                sipCpp->height());
#line 728 "sipQtCoreQSize.cpp"

            return sipRes;
        }
    }
}


/* Cast a pointer to a type somewhere in its superclass hierarchy. */
extern "C" {static void *cast_QSize(void *, sipWrapperType *);}
static void *cast_QSize(void *ptr,sipWrapperType *targetClass)
{
    if (targetClass == sipClass_QSize)
        return ptr;

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_QSize(void *, int);}
static void release_QSize(void *sipCppV,int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast<QSize *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static PyObject *pickle_QSize(void *);}
static PyObject *pickle_QSize(void *sipCppV)
{
    QSize *sipCpp = reinterpret_cast<QSize *>(sipCppV);
    PyObject *sipRes;

#line 50 "sip/QtCore/qsize.sip"
    sipRes = Py_BuildValue((char *)"ii", sipCpp->width(), sipCpp->height());
#line 767 "sipQtCoreQSize.cpp"

    return sipRes;
}


extern "C" {static void assign_QSize(void *, const void*);}
static void assign_QSize(void *sipDst, const void *sipSrc)
{
    *reinterpret_cast<QSize *>(sipDst) = *reinterpret_cast<const QSize *>(sipSrc);
}


extern "C" {static void dealloc_QSize(sipWrapper *);}
static void dealloc_QSize(sipWrapper *sipSelf)
{
    if (sipIsPyOwned(sipSelf))
    {
        release_QSize(sipSelf->u.cppPtr,0);
    }
}


extern "C" {static void *init_QSize(sipWrapper *, PyObject *, sipWrapper **, int *);}
static void *init_QSize(sipWrapper *,PyObject *sipArgs,sipWrapper **,int *sipArgsParsed)
{
    QSize *sipCpp = 0;

    if (!sipCpp)
    {
        if (sipParseArgs(sipArgsParsed,sipArgs,""))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QSize();
            Py_END_ALLOW_THREADS
        }
    }

    if (!sipCpp)
    {
        int a0;
        int a1;

        if (sipParseArgs(sipArgsParsed,sipArgs,"ii",&a0,&a1))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QSize(a0,a1);
            Py_END_ALLOW_THREADS
        }
    }

    if (!sipCpp)
    {
        const QSize * a0;

        if (sipParseArgs(sipArgsParsed,sipArgs,"JA",sipClass_QSize,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QSize(*a0);
            Py_END_ALLOW_THREADS
        }
    }

    return sipCpp;
}


extern "C" {static void *forceConvertTo_QSize(PyObject *, int *);}
static void *forceConvertTo_QSize(PyObject *valobj,int *iserrp)
{
    if (*iserrp || valobj == NULL)
        return NULL;

    if (valobj == Py_None || sipIsSubClassInstance(valobj,sipClass_QSize))
        return sipConvertToCpp(valobj,sipClass_QSize,iserrp);

    sipBadClass(sipNm_QtCore_QSize);

    *iserrp = 1;

    return NULL;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QSize[] = {
    {(void *)slot_QSize___eq__, eq_slot},
    {(void *)slot_QSize___ne__, ne_slot},
    {(void *)slot_QSize___add__, add_slot},
    {(void *)slot_QSize___sub__, sub_slot},
    {(void *)slot_QSize___mul__, mul_slot},
    {(void *)slot_QSize___div__, div_slot},
    {(void *)slot_QSize___idiv__, idiv_slot},
    {(void *)slot_QSize___imul__, imul_slot},
    {(void *)slot_QSize___isub__, isub_slot},
    {(void *)slot_QSize___iadd__, iadd_slot},
    {(void *)slot_QSize___nonzero__, nonzero_slot},
    {(void *)slot_QSize___repr__, repr_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QSize[] = {
    {sipNm_QtCore_boundedTo, meth_QSize_boundedTo, METH_VARARGS, NULL},
    {sipNm_QtCore_expandedTo, meth_QSize_expandedTo, METH_VARARGS, NULL},
    {sipNm_QtCore_height, meth_QSize_height, METH_VARARGS, NULL},
    {sipNm_QtCore_isEmpty, meth_QSize_isEmpty, METH_VARARGS, NULL},
    {sipNm_QtCore_isNull, meth_QSize_isNull, METH_VARARGS, NULL},
    {sipNm_QtCore_isValid, meth_QSize_isValid, METH_VARARGS, NULL},
    {sipNm_QtCore_scale, meth_QSize_scale, METH_VARARGS, NULL},
    {sipNm_QtCore_setHeight, meth_QSize_setHeight, METH_VARARGS, NULL},
    {sipNm_QtCore_setWidth, meth_QSize_setWidth, METH_VARARGS, NULL},
    {sipNm_QtCore_transpose, meth_QSize_transpose, METH_VARARGS, NULL},
    {sipNm_QtCore_width, meth_QSize_width, METH_VARARGS, NULL}
};


sipTypeDef sipType_QtCore_QSize = {
    0,
    0,
    "QtCore.QSize",
    0,
    {0, 0, 1},
    0,
    slots_QSize,
    11, methods_QSize,
    0, 0,
    0,
    init_QSize,
    0,
    0,
    0,
    0,
    0,
    0,
    dealloc_QSize,
    cast_QSize,
    release_QSize,
    forceConvertTo_QSize,
    0,
    0,
    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    0,
    pickle_QSize,
    assign_QSize,
    0
};
