/*
 * Interface wrapper code.
 *
 * Generated by SIP snapshot-4.10.2-275fa5a54910 on Mon May 17 18:23:30 2010
 *
 * Copyright (c) 2010 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt.
 * 
 * This file may be used under the terms of the GNU General Public
 * License versions 2.0 or 3.0 as published by the Free Software
 * Foundation and appearing in the files LICENSE.GPL2 and LICENSE.GPL3
 * included in the packaging of this file.  Alternatively you may (at
 * your option) use any later version of the GNU General Public
 * License if such license has been publicly approved by Riverbank
 * Computing Limited (or its successors, if any) and the KDE Free Qt
 * Foundation. In addition, as a special exception, Riverbank gives you
 * certain additional rights. These rights are described in the Riverbank
 * GPL Exception version 1.1, which can be found in the file
 * GPL_EXCEPTION.txt in this package.
 * 
 * Please review the following information to ensure GNU General
 * Public Licensing requirements will be met:
 * http://trolltech.com/products/qt/licenses/licensing/opensource/. If
 * you are unsure which license is appropriate for your use, please
 * review the following information:
 * http://trolltech.com/products/qt/licenses/licensing/licensingoverview
 * or contact the sales department at sales@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 346 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtCore/qdatetime.sip"
#include <qdatetime.h>
#line 39 "sipQtCoreQDateTime.cpp"

#line 41 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtCore/qdatetime.sip"
#include <qdatetime.h>
#line 43 "sipQtCoreQDateTime.cpp"
#line 200 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtCore/qdatetime.sip"
#include <qdatetime.h>
#line 46 "sipQtCoreQDateTime.cpp"
#line 40 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtCore/qnamespace.sip"
#include <qnamespace.h>
#line 49 "sipQtCoreQDateTime.cpp"
#line 41 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtCore/qstring.sip"
#include <qstring.h>
#line 52 "sipQtCoreQDateTime.cpp"
#line 350 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtCore/qdatetime.sip"
#include <QHash>

#if PY_VERSION_HEX >= 0x02040000
#include <datetime.h>
#endif
#line 59 "sipQtCoreQDateTime.cpp"


extern "C" {static PyObject *meth_QDateTime_toPyDateTime(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_toPyDateTime(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDateTime, &sipCpp))
        {
            PyObject * sipRes = 0;

#line 487 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtCore/qdatetime.sip"
        if (!PyDateTimeAPI)
            PyDateTime_IMPORT;
        
        // Convert to a Python datetime object.
        QDate qd = sipCpp->date();
        QTime qt = sipCpp->time();
        
        sipRes = PyDateTime_FromDateAndTime(qd.year(), qd.month(), qd.day(),
                                            qt.hour(), qt.minute(), qt.second(), qt.msec() * 1000);
#line 84 "sipQtCoreQDateTime.cpp"

            return sipRes;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_toPyDateTime, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_isNull(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_isNull(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDateTime, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isNull();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_isNull, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_isValid(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_isValid(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDateTime, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isValid();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_isValid, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_date(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_date(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDateTime, &sipCpp))
        {
            QDate *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDate(sipCpp->date());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QDate,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_date, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_time(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_time(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDateTime, &sipCpp))
        {
            QTime *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QTime(sipCpp->time());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_time, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_timeSpec(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_timeSpec(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDateTime, &sipCpp))
        {
            Qt::TimeSpec sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->timeSpec();
            Py_END_ALLOW_THREADS

            return sipConvertFromEnum(sipRes,sipType_Qt_TimeSpec);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_timeSpec, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_toTime_t(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_toTime_t(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDateTime, &sipCpp))
        {
            uint sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->toTime_t();
            Py_END_ALLOW_THREADS

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_toTime_t, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_setDate(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_setDate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const QDate * a0;
        int a0State = 0;
        QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QDateTime, &sipCpp, sipType_QDate, &a0, &a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setDate(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QDate *>(a0),sipType_QDate,a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_setDate, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_setTime(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_setTime(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const QTime * a0;
        int a0State = 0;
        QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QDateTime, &sipCpp, sipType_QTime, &a0, &a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setTime(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QTime *>(a0),sipType_QTime,a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_setTime, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_setTimeSpec(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_setTimeSpec(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        Qt::TimeSpec a0;
        QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QDateTime, &sipCpp, sipType_Qt_TimeSpec, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setTimeSpec(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_setTimeSpec, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_setTime_t(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_setTime_t(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        uint a0;
        QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bu", &sipSelf, sipType_QDateTime, &sipCpp, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setTime_t(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_setTime_t, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_toString(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QDateTime_toString(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        Qt::DateFormat a0 = Qt::TextDate;
        QDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_format,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|E", &sipSelf, sipType_QDateTime, &sipCpp, sipType_Qt_DateFormat, &a0))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->toString(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QString,NULL);
        }
    }

    {
        const QString * a0;
        int a0State = 0;
        QDateTime *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, NULL, NULL, "BJ1", &sipSelf, sipType_QDateTime, &sipCpp, sipType_QString,&a0, &a0State))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->toString(*a0));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QString *>(a0),sipType_QString,a0State);

            return sipConvertFromNewType(sipRes,sipType_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_toString, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_addDays(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_addDays(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QDateTime, &sipCpp, &a0))
        {
            QDateTime *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDateTime(sipCpp->addDays(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_addDays, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_addMonths(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_addMonths(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QDateTime, &sipCpp, &a0))
        {
            QDateTime *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDateTime(sipCpp->addMonths(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_addMonths, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_addYears(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_addYears(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QDateTime, &sipCpp, &a0))
        {
            QDateTime *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDateTime(sipCpp->addYears(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_addYears, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_addSecs(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_addSecs(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QDateTime, &sipCpp, &a0))
        {
            QDateTime *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDateTime(sipCpp->addSecs(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_addSecs, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_addMSecs(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_addMSecs(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        qint64 a0;
        QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bn", &sipSelf, sipType_QDateTime, &sipCpp, &a0))
        {
            QDateTime *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDateTime(sipCpp->addMSecs(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_addMSecs, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_toTimeSpec(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_toTimeSpec(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        Qt::TimeSpec a0;
        QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QDateTime, &sipCpp, sipType_Qt_TimeSpec, &a0))
        {
            QDateTime *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDateTime(sipCpp->toTimeSpec(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_toTimeSpec, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_toLocalTime(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_toLocalTime(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDateTime, &sipCpp))
        {
            QDateTime *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDateTime(sipCpp->toLocalTime());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_toLocalTime, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_toUTC(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_toUTC(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDateTime, &sipCpp))
        {
            QDateTime *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDateTime(sipCpp->toUTC());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_toUTC, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_daysTo(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_daysTo(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const QDateTime * a0;
        int a0State = 0;
        QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QDateTime, &sipCpp, sipType_QDateTime, &a0, &a0State))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->daysTo(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QDateTime *>(a0),sipType_QDateTime,a0State);

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_daysTo, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_secsTo(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_secsTo(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const QDateTime * a0;
        int a0State = 0;
        QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QDateTime, &sipCpp, sipType_QDateTime, &a0, &a0State))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->secsTo(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QDateTime *>(a0),sipType_QDateTime,a0State);

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_secsTo, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_currentDateTime(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_currentDateTime(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            QDateTime *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDateTime(QDateTime::currentDateTime());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_currentDateTime, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_fromString(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QDateTime_fromString(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const QString * a0;
        int a0State = 0;
        Qt::DateFormat a1 = Qt::TextDate;

        static const char *sipKwdList[] = {
            NULL,
            sipName_format,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1|E", sipType_QString,&a0, &a0State, sipType_Qt_DateFormat, &a1))
        {
            QDateTime *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDateTime(QDateTime::fromString(*a0,a1));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QString *>(a0),sipType_QString,a0State);

            return sipConvertFromNewType(sipRes,sipType_QDateTime,NULL);
        }
    }

    {
        const QString * a0;
        int a0State = 0;
        const QString * a1;
        int a1State = 0;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, NULL, NULL, "J1J1", sipType_QString,&a0, &a0State, sipType_QString,&a1, &a1State))
        {
            QDateTime *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDateTime(QDateTime::fromString(*a0,*a1));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QString *>(a0),sipType_QString,a0State);
            sipReleaseType(const_cast<QString *>(a1),sipType_QString,a1State);

            return sipConvertFromNewType(sipRes,sipType_QDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_fromString, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_fromTime_t(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_fromTime_t(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        uint a0;

        if (sipParseArgs(&sipParseErr, sipArgs, "u", &a0))
        {
            QDateTime *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDateTime(QDateTime::fromTime_t(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_fromTime_t, NULL);

    return NULL;
}


extern "C" {static PyObject *slot_QDateTime___ge__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QDateTime___ge__(PyObject *sipSelf,PyObject *sipArg)
{
    QDateTime *sipCpp = reinterpret_cast<QDateTime *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QDateTime));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const QDateTime * a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QDateTime, &a0, &a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QDateTime::operator>=(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QDateTime *>(a0),sipType_QDateTime,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI_QtCore,ge_slot,sipType_QDateTime,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QDateTime___gt__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QDateTime___gt__(PyObject *sipSelf,PyObject *sipArg)
{
    QDateTime *sipCpp = reinterpret_cast<QDateTime *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QDateTime));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const QDateTime * a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QDateTime, &a0, &a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QDateTime::operator>(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QDateTime *>(a0),sipType_QDateTime,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI_QtCore,gt_slot,sipType_QDateTime,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QDateTime___le__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QDateTime___le__(PyObject *sipSelf,PyObject *sipArg)
{
    QDateTime *sipCpp = reinterpret_cast<QDateTime *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QDateTime));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const QDateTime * a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QDateTime, &a0, &a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QDateTime::operator<=(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QDateTime *>(a0),sipType_QDateTime,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI_QtCore,le_slot,sipType_QDateTime,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QDateTime___lt__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QDateTime___lt__(PyObject *sipSelf,PyObject *sipArg)
{
    QDateTime *sipCpp = reinterpret_cast<QDateTime *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QDateTime));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const QDateTime * a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QDateTime, &a0, &a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QDateTime::operator<(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QDateTime *>(a0),sipType_QDateTime,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI_QtCore,lt_slot,sipType_QDateTime,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QDateTime___ne__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QDateTime___ne__(PyObject *sipSelf,PyObject *sipArg)
{
    QDateTime *sipCpp = reinterpret_cast<QDateTime *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QDateTime));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const QDateTime * a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QDateTime, &a0, &a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QDateTime::operator!=(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QDateTime *>(a0),sipType_QDateTime,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI_QtCore,ne_slot,sipType_QDateTime,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QDateTime___eq__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QDateTime___eq__(PyObject *sipSelf,PyObject *sipArg)
{
    QDateTime *sipCpp = reinterpret_cast<QDateTime *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QDateTime));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const QDateTime * a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QDateTime, &a0, &a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QDateTime::operator==(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QDateTime *>(a0),sipType_QDateTime,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI_QtCore,eq_slot,sipType_QDateTime,sipSelf,sipArg);
}


extern "C" {static int slot_QDateTime___bool__(PyObject *sipSelf);}
static int slot_QDateTime___bool__(PyObject *sipSelf)
{
    QDateTime *sipCpp = reinterpret_cast<QDateTime *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QDateTime));

    if (!sipCpp)
        return -1;


    {
        {
            int sipRes = 0;

#line 502 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtCore/qdatetime.sip"
        sipRes = !sipCpp->isNull();
#line 1041 "sipQtCoreQDateTime.cpp"

            return sipRes;
        }
    }
}


extern "C" {static long slot_QDateTime___hash__(PyObject *sipSelf);}
static long slot_QDateTime___hash__(PyObject *sipSelf)
{
    QDateTime *sipCpp = reinterpret_cast<QDateTime *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QDateTime));

    if (!sipCpp)
        return 0;


    {
        {
            long sipRes = 0;

#line 473 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtCore/qdatetime.sip"
        if (sipIsAPIEnabled("QDateTime", 2, 0))
        {
            sipRes = qHash(sipCpp->toString(Qt::ISODate));
        }
        else
        {
            // Mimic Python's default behavour.
            sipRes = _Py_HashPointer(sipSelf);
        }
#line 1072 "sipQtCoreQDateTime.cpp"

            return sipRes;
        }
    }
}


extern "C" {static PyObject *slot_QDateTime___repr__(PyObject *sipSelf);}
static PyObject *slot_QDateTime___repr__(PyObject *sipSelf)
{
    QDateTime *sipCpp = reinterpret_cast<QDateTime *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QDateTime));

    if (!sipCpp)
        return 0;


    {
        {
            PyObject * sipRes = 0;

#line 423 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtCore/qdatetime.sip"
        QDate qd = sipCpp->date();
        QTime qt = sipCpp->time();
        
        #if PY_MAJOR_VERSION >= 3
        sipRes = PyUnicode_FromFormat("PyQt4.QtCore.QDateTime(%i, %i, %i, %i, %i",
                qd.year(), qd.month(), qd.day(), qt.hour(), qt.minute());
        
        if (qt.second() || qt.msec() || sipCpp->timeSpec() != Qt::LocalTime)
        {
            qpycore_Unicode_ConcatAndDel(&sipRes,
                    PyUnicode_FromFormat(", %i", qt.second()));
        
            if (qt.msec() || sipCpp->timeSpec() != Qt::LocalTime)
            {
                qpycore_Unicode_ConcatAndDel(&sipRes, PyUnicode_FromFormat(", %i", qt.msec()));
        
                if (sipCpp->timeSpec() != Qt::LocalTime)
                    qpycore_Unicode_ConcatAndDel(&sipRes,
                            PyUnicode_FromFormat(", PyQt4.QtCore.Qt.TimeSpec(%i)",
                                    (int)sipCpp->timeSpec()));
            }
        }
        
        qpycore_Unicode_ConcatAndDel(&sipRes, PyUnicode_FromString(")"));
        #else
        sipRes = PyString_FromFormat("PyQt4.QtCore.QDateTime(%i, %i, %i, %i, %i",
                qd.year(), qd.month(), qd.day(), qt.hour(), qt.minute());
        
        if (qt.second() || qt.msec() || sipCpp->timeSpec() != Qt::LocalTime)
        {
            PyString_ConcatAndDel(&sipRes,
                    PyString_FromFormat(", %i", qt.second()));
        
            if (qt.msec() || sipCpp->timeSpec() != Qt::LocalTime)
            {
                PyString_ConcatAndDel(&sipRes, PyString_FromFormat(", %i", qt.msec()));
        
                if (sipCpp->timeSpec() != Qt::LocalTime)
                    PyString_ConcatAndDel(&sipRes,
                            PyString_FromFormat(", PyQt4.QtCore.Qt.TimeSpec(%i)",
                                    (int)sipCpp->timeSpec()));
            }
        }
        
        PyString_ConcatAndDel(&sipRes, PyString_FromString(")"));
        #endif
#line 1140 "sipQtCoreQDateTime.cpp"

            return sipRes;
        }
    }
}


/* Cast a pointer to a type somewhere in its superclass hierarchy. */
extern "C" {static void *cast_QDateTime(void *, const sipTypeDef *);}
static void *cast_QDateTime(void *ptr, const sipTypeDef *targetType)
{
    if (targetType == sipType_QDateTime)
        return ptr;

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_QDateTime(void *, int);}
static void release_QDateTime(void *sipCppV,int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast<QDateTime *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static PyObject *pickle_QDateTime(void *);}
static PyObject *pickle_QDateTime(void *sipCppV)
{
    QDateTime *sipCpp = reinterpret_cast<QDateTime *>(sipCppV);
    PyObject *sipRes;

#line 398 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtCore/qdatetime.sip"
    QDate qd = sipCpp->date();
    QTime qt = sipCpp->time();
    
    sipRes = Py_BuildValue((char *)"iiiiiiii", qd.year(), qd.month(), qd.day(),
            qt.hour(), qt.minute(), qt.second(), qt.msec(),
            (int)sipCpp->timeSpec());
#line 1184 "sipQtCoreQDateTime.cpp"

    return sipRes;
}


extern "C" {static void assign_QDateTime(void *, SIP_SSIZE_T, const void *);}
static void assign_QDateTime(void *sipDst, SIP_SSIZE_T sipDstIdx, const void *sipSrc)
{
    reinterpret_cast<QDateTime *>(sipDst)[sipDstIdx] = *reinterpret_cast<const QDateTime *>(sipSrc);
}


extern "C" {static void *array_QDateTime(SIP_SSIZE_T);}
static void *array_QDateTime(SIP_SSIZE_T sipNrElem)
{
    return new QDateTime[sipNrElem];
}


extern "C" {static void *copy_QDateTime(const void *, SIP_SSIZE_T);}
static void *copy_QDateTime(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new QDateTime(reinterpret_cast<const QDateTime *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QDateTime(sipSimpleWrapper *);}
static void dealloc_QDateTime(sipSimpleWrapper *sipSelf)
{
    if (sipIsPyOwned(sipSelf))
    {
        release_QDateTime(sipSelf->u.cppPtr,0);
    }
}


extern "C" {static void *init_QDateTime(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_QDateTime(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    QDateTime *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QDateTime();
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        const QDateTime * a0;
        int a0State = 0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J1", sipType_QDateTime, &a0, &a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QDateTime(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QDateTime *>(a0),sipType_QDateTime,a0State);

            return sipCpp;
        }
    }

    {
        const QDate * a0;
        int a0State = 0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J1", sipType_QDate, &a0, &a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QDateTime(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QDate *>(a0),sipType_QDate,a0State);

            return sipCpp;
        }
    }

    {
        const QDate * a0;
        int a0State = 0;
        const QTime * a1;
        int a1State = 0;
        Qt::TimeSpec a2 = Qt::LocalTime;

        static const char *sipKwdList[] = {
            NULL,
            NULL,
            sipName_timeSpec,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1J1|E", sipType_QDate, &a0, &a0State, sipType_QTime, &a1, &a1State, sipType_Qt_TimeSpec, &a2))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QDateTime(*a0,*a1,a2);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QDate *>(a0),sipType_QDate,a0State);
            sipReleaseType(const_cast<QTime *>(a1),sipType_QTime,a1State);

            return sipCpp;
        }
    }

    {
        int a0;
        int a1;
        int a2;
        int a3;
        int a4;
        int a5 = 0;
        int a6 = 0;
        int a7 = 0;

        static const char *sipKwdList[] = {
            sipName_y,
            sipName_m,
            sipName_d,
            sipName_h,
            sipName_m,
            sipName_s,
            sipName_msec,
            sipName_timeSpec,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "iiiii|iii", &a0, &a1, &a2, &a3, &a4, &a5, &a6, &a7))
        {
#line 413 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtCore/qdatetime.sip"
        // This ctor is mainly supplied to allow pickling.
        QDate qd(a0, a1, a2);
        QTime qt(a3, a4, a5, a6);
        
        sipCpp = new QDateTime(qd, qt, (Qt::TimeSpec)a7);
#line 1321 "sipQtCoreQDateTime.cpp"

            return sipCpp;
        }
    }

    return NULL;
}


extern "C" {static int convertTo_QDateTime(PyObject *, void **, int *, PyObject *);}
static int convertTo_QDateTime(PyObject *sipPy,void **sipCppPtrV,int *sipIsErr,PyObject *sipTransferObj)
{
    QDateTime **sipCppPtr = reinterpret_cast<QDateTime **>(sipCppPtrV);

#line 358 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtCore/qdatetime.sip"
#if PY_VERSION_HEX >= 0x02040000
    if (!PyDateTimeAPI)
        PyDateTime_IMPORT;
#endif

// Allow a Python datetime object whenever a QDateTime is expected.

if (sipIsErr == NULL)
    return (
#if PY_VERSION_HEX >= 0x02040000
            PyDateTime_Check(sipPy) ||
#endif
            sipCanConvertToType(sipPy, sipType_QDateTime, SIP_NO_CONVERTORS));

#if PY_VERSION_HEX >= 0x02040000
if (PyDateTime_Check(sipPy))
{
    QDate qdate(PyDateTime_GET_YEAR(sipPy),
                PyDateTime_GET_MONTH(sipPy),
                PyDateTime_GET_DAY(sipPy));

    QTime qtime(PyDateTime_DATE_GET_HOUR(sipPy),
                PyDateTime_DATE_GET_MINUTE(sipPy),
                PyDateTime_DATE_GET_SECOND(sipPy),
                PyDateTime_DATE_GET_MICROSECOND(sipPy) / 1000);

    QDateTime *qdt = new QDateTime(qdate, qtime);

    *sipCppPtr = qdt;

    return sipGetState(sipTransferObj);
}
#endif

*sipCppPtr = reinterpret_cast<QDateTime *>(sipConvertToType(sipPy, sipType_QDateTime, sipTransferObj, SIP_NO_CONVERTORS, 0, sipIsErr));

return 0;
#line 1374 "sipQtCoreQDateTime.cpp"
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QDateTime[] = {
    {(void *)slot_QDateTime___ge__, ge_slot},
    {(void *)slot_QDateTime___gt__, gt_slot},
    {(void *)slot_QDateTime___le__, le_slot},
    {(void *)slot_QDateTime___lt__, lt_slot},
    {(void *)slot_QDateTime___ne__, ne_slot},
    {(void *)slot_QDateTime___eq__, eq_slot},
    {(void *)slot_QDateTime___bool__, bool_slot},
    {(void *)slot_QDateTime___hash__, hash_slot},
    {(void *)slot_QDateTime___repr__, repr_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QDateTime[] = {
    {SIP_MLNAME_CAST(sipName_addDays), meth_QDateTime_addDays, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_addMSecs), meth_QDateTime_addMSecs, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_addMonths), meth_QDateTime_addMonths, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_addSecs), meth_QDateTime_addSecs, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_addYears), meth_QDateTime_addYears, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_currentDateTime), meth_QDateTime_currentDateTime, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_date), meth_QDateTime_date, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_daysTo), meth_QDateTime_daysTo, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_fromString), (PyCFunction)meth_QDateTime_fromString, METH_VARARGS|METH_KEYWORDS, NULL},
    {SIP_MLNAME_CAST(sipName_fromTime_t), meth_QDateTime_fromTime_t, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_isNull), meth_QDateTime_isNull, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_isValid), meth_QDateTime_isValid, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_secsTo), meth_QDateTime_secsTo, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_setDate), meth_QDateTime_setDate, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_setTime), meth_QDateTime_setTime, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_setTimeSpec), meth_QDateTime_setTimeSpec, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_setTime_t), meth_QDateTime_setTime_t, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_time), meth_QDateTime_time, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_timeSpec), meth_QDateTime_timeSpec, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_toLocalTime), meth_QDateTime_toLocalTime, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_toPyDateTime), meth_QDateTime_toPyDateTime, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_toString), (PyCFunction)meth_QDateTime_toString, METH_VARARGS|METH_KEYWORDS, NULL},
    {SIP_MLNAME_CAST(sipName_toTimeSpec), meth_QDateTime_toTimeSpec, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_toTime_t), meth_QDateTime_toTime_t, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_toUTC), meth_QDateTime_toUTC, METH_VARARGS, NULL}
};


pyqt4ClassTypeDef sipTypeDef_QtCore_QDateTime = {
{
    {
        -1,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_QDateTime,
        {0}
    },
    {
        sipNameNr_QDateTime,
        {0, 0, 1},
        25, methods_QDateTime,
        0, 0,
        0, 0,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    0,
    sipNameNr_PyQt4_QtCore_pyqtWrapperType,
    sipNameNr_sip_simplewrapper,
    0,
    slots_QDateTime,
    init_QDateTime,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_QDateTime,
    assign_QDateTime,
    array_QDateTime,
    copy_QDateTime,
    release_QDateTime,
    cast_QDateTime,
    convertTo_QDateTime,
    0,
    pickle_QDateTime
},
    0,
    0,
    0
};
