"""
mlpy
==================================================

Machine Learning Py (mlpy) is a a high-performance
Python package for predictive modeling.

Homepage: https://mlpy.fbk.eu
"""

from version import version as __version__

from _svm import *
from _irelief import *
from _ranking import *
from _fda import *
from _canberra import *
from _data import *
from _ci import *
from _resampling import *
from _srda import *
from _bmetrics import *
from _knn import *
from _borda import *
from _dwtfs import *
from _pda import *
from _dlda import *
from _hcluster import *
from _dwt import *
from _uwt import *
from _cwt import *
from gslpy import *
from peaksd import *
from misc import *
from _imputing import *
from _extend import *
from _dtw import *
from _kmedoids import *
from _fssun import *

__all__ = []
__all__ += _svm.__all__
__all__ += _knn.__all__
__all__ += _fda.__all__
__all__ += _srda.__all__
__all__ += _pda.__all__
__all__ += _irelief.__all__
__all__ += _dwtfs.__all__
__all__ += _ranking.__all__
__all__ += _resampling.__all__
__all__ += _bmetrics.__all__
__all__ += _data.__all__
__all__ += _canberra.__all__
__all__ += _ci.__all__
__all__ += _borda.__all__
__all__ += _dlda.__all__
__all__ += _hcluster.__all__
__all__ += ['dwt', 'idwt']
__all__ += ['uwt', 'iuwt']
__all__ += _cwt.__all__
__all__ += ['gamma', 'fact', 'quantile', 'cdf_gaussian_P']
__all__ += ['three_points_pd', 'span_pd']
__all__ += ['away']
__all__ += _imputing.__all__
__all__ += _extend.__all__
__all__ += _dtw.__all__
__all__ += _kmedoids.__all__
__all__ += _fssun.__all__
