
import gobject
import location

def on_changed(device, user_data=None):
    print 'on_changed callback'
    fix = device.fix

    if fix[1] & location.GPS_DEVICE_TIME_SET:
        print 'Timestamp set: %s' % fix[2]
        print 'Timestamp accuracy: %s' % fix[3]
    if fix[1] & location.GPS_DEVICE_LATLONG_SET:
        print 'Latitude and longitude set %s, %s' % (fix[4], fix[5])
        print 'Coordinates accuracy: %s' % fix[6]
    if fix[1] & location.GPS_DEVICE_ALTITUDE_SET:
        print 'Altitude set: %s' % fix[7]

def main():
    loop = gobject.MainLoop()

    control = location.GPSDControl.get_default()
    device = location.GPSDevice()

    device.connect('changed', on_changed)

    control.start()

    loop.run()

if __name__ == '__main__':
    main()
