import select


class MainLoop(object):
    def __init__(self, fd, cb):
        self._cb = cb
        self._quit = False
        self._fdpoll = select.poll()
        self._fdpoll.register(fd, select.POLLIN)  # ideal world

    def run(self):
        self._quit = False
        while not self._quit:
            ev = self._fdpoll.poll(1000)
            if ev:  # not dealing with errors
                self._cb()

    def quit(self):
        self._quit = True
