/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include  "thread_support.hpp"

namespace PySide
{

bool thread_support::m_enabled = false;

void
thread_support::init()
{
    PyEval_InitThreads();
    m_enabled = true;
}

void
thread_support::shutdown()
{
    m_enabled = false;
}

bool
thread_support::enabled()
{
    return m_enabled;
}

thread_locker::thread_locker()
{
    if (thread_support::enabled())
        m_gstate = PyGILState_Ensure();
}

thread_locker::~thread_locker()
{
    if (thread_support::enabled())
        PyGILState_Release(m_gstate);
}

py_allow_threads::py_allow_threads()
{
    Py_UNBLOCK_THREADS
}

py_allow_threads::~py_allow_threads()
{
    Py_BLOCK_THREADS
}

} // namespace PySide

