/*
 * Based on code provided by:
 *          Antonio Valentino <antonio.valentino at tiscali.it>
 *          Frédéric <frederic.mantegazza at gbiloba.org>
 */

static void
_transfer_children(QWidget *old, QWidget *target)
{
    if (old->children().size() == 0)
        return;

    PySide::qptr<QWidget> ptr_parent(target);
    python::object target_python(PySide::ptr(target));

    //Transfer children
    foreach(QObject *child, old->children()) {
        QString name(child->objectName());
        if (!name.isEmpty() && !name.startsWith("_") && !name.startsWith("qt_")) {
            bool has_attr = PyObject_HasAttrString(target_python.ptr(),
                                                   name.toAscii().data());
            if (!has_attr) {
                python::setattr(target_python, name.toAscii().data(),
                                python::object(PySide::ptr(child)));
            }

            child->setParent(target);
            PySide::qptr<QWidget> ptr_child(qobject_cast<QWidget*>(child));
            ptr_parent.add_child(ptr_child);

            _transfer_children(qobject_cast<QWidget*>(child), qobject_cast<QWidget*>(child));
        }
    }
}

static python::object
quiloader_load_ui(const QString &ui_file, QWidget *base_instance)
{
    if (!QFile::exists(ui_file))
        return python::object();

    QFile fd(ui_file);
    if (!fd.open(QFile::ReadOnly))
        return python::object();

    QUiLoader loader;
    QWidget *w = loader.load(&fd);
    fd.close();

    if (w == 0)
        return python::object();

    if (base_instance == 0)
        return python::object(PySide::ptr(w, true));

    if (base_instance->layout())
        base_instance->layout()->deleteLater();

    _transfer_children(w, base_instance);

   return python::object(PySide::ptr(w, true));
}
