/**
 * Enable support a pythonic way to add menu action
 * Ex: menubar.add_action("action-name", python-callback)
 **/
static python::object
qmenubar_add_action_with_cb(QMenuBar *self,
                            const QString &text,
                            python::object &callback)
{
    QAction *action = self->addAction(text);
    signal_manager::instance().connect(action,
                                       pyqt_signal("triggered()"),
                                       callback);

    PySide::qptr<QMenuBar> ptr_self(self);
    PySide::qptr<QAction> ptr_action(action);

    ptr_self.add_child(ptr_action);

    return  python::object(PySide::ptr(action));
}

static python::object
qmenubar_add_action_with_slot(QMenuBar *self,
                              const QString &text,
                              QObject &receiver,
                              const pyqt_slot &callback)
{
    QAction *action = self->addAction(text);
    signal_manager::instance().connect(action,
                                       pyqt_signal("triggered()"),
                                       &receiver,
                                       callback);

    PySide::qptr<QMenuBar> ptr_self(self);
    PySide::qptr<QAction> ptr_action(action);

    ptr_self.add_child(ptr_action);

    return  python::object(PySide::ptr(action));
}


